/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.config.migration;

import com.rictacius.customShop.config.Config;
import com.rictacius.customShop.config.ConfigFileException;
import com.rictacius.customShop.config.ItemConfig;
import com.rictacius.customShop.config.ShopConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.material.MaterialData;

class V2ShopsConfig
extends Config {
    private List<ShopConfig> v3ShopConfigs;

    V2ShopsConfig(File parentFolder, String fileName) throws ConfigFileException {
        super(parentFolder, fileName);
    }

    private void throwConfigFileException(String issue) throws ConfigFileException {
        throw new ConfigFileException("v2 shops.yml is invalid: " + issue);
    }

    private void throwConfigFileException(String issue, Throwable cause) throws ConfigFileException {
        throw new ConfigFileException("v2 shops.yml is invalid: " + issue, cause);
    }

    @Override
    protected void onConfigFileLoaded() throws ConfigFileException {
        this.v3ShopConfigs = new ArrayList<ShopConfig>();
        ConfigurationSection shopsSection = this.file.getConfigurationSection("shops");
        if (shopsSection == null) {
            this.throwConfigFileException("no 'shops' section");
        }
        for (String shopName : shopsSection.getKeys(false)) {
            ConfigurationSection shopSection = shopsSection.getConfigurationSection(shopName);
            assert (shopSection != null);
            ShopConfig shopConfig = this.parseShopSection(shopName, shopSection);
            this.v3ShopConfigs.add(shopConfig);
        }
    }

    private ShopConfig parseShopSection(final String shopName, ConfigurationSection shopSection) throws ConfigFileException {
        final String fancyName = shopSection.getString("name");
        final String requiredPermission = shopSection.getString("permission");
        ConfigurationSection itemsSection = shopSection.getConfigurationSection("items");
        if (itemsSection == null) {
            this.throwConfigFileException("no 'shops.[shop].items' section");
        }
        final ArrayList<ItemConfig> itemConfigs = new ArrayList<ItemConfig>();
        for (String itemName : itemsSection.getKeys(false)) {
            String itemConfigStr = itemsSection.getString(itemName);
            if (itemConfigStr == null) {
                this.throwConfigFileException("invalid 'shops.[shop].items.[item]' type, expected String");
            }
            try {
                ItemConfig itemConfig = this.parseItemSection(itemName, itemConfigStr);
                itemConfigs.add(itemConfig);
            }
            catch (Exception e) {
                this.throwConfigFileException("invalid item config(s)", e);
            }
        }
        return new ShopConfig(){

            @Override
            public String getName() {
                return shopName;
            }

            @Override
            public String getFancyName() {
                return fancyName;
            }

            @Override
            @Nullable
            public String getRequiredPermission() {
                return requiredPermission;
            }

            @Override
            public List<ItemConfig> getItems() {
                return itemConfigs;
            }

            @Override
            public String getOnItemBoughtCommand() {
                return null;
            }

            @Override
            public String getOnItemSoldCommand() {
                return null;
            }
        };
    }

    private ItemConfig parseItemSection(final String itemName, String itemConfigStr) {
        String[] parts = itemConfigStr.split(",");
        String[] typeParts = parts[0].split(":");
        int typeId = Integer.parseInt(typeParts[0]);
        int typeData = Integer.parseInt(typeParts[1]);
        final Material material = this.convertLegacyTypeToMaterial(typeId, typeData);
        assert (material != null);
        String amountBuy = parts[1];
        String priceBuy = parts[2];
        String amountSell = parts[3];
        String priceSell = parts[4];
        boolean allowBuy = true;
        boolean allowSell = true;
        int buySize = 0;
        int sellSize = 0;
        double buyPrice = 0.0;
        double sellPrice = 0.0;
        try {
            buySize = Integer.parseInt(amountBuy);
            buyPrice = Double.parseDouble(priceBuy);
        }
        catch (Exception e) {
            allowBuy = false;
        }
        try {
            sellSize = Integer.parseInt(amountSell);
            sellPrice = Double.parseDouble(priceSell);
        }
        catch (Exception e) {
            allowSell = false;
        }
        final boolean finalAllowBuy = allowBuy;
        final boolean finalAllowSell = allowSell;
        final int finalBuySize = buySize;
        final int finalSellSize = sellSize;
        final double finalBuyPrice = buyPrice;
        final double finalSellPrice = sellPrice;
        return new ItemConfig(){

            @Override
            public String getName() {
                return itemName;
            }

            @Override
            public String getFancyName() {
                return itemName;
            }

            @Override
            public Material getMaterial() {
                return material;
            }

            @Override
            public boolean shouldAllowBuy() {
                return finalAllowBuy;
            }

            @Override
            public boolean shouldAllowSell() {
                return finalAllowSell;
            }

            @Override
            public int getBuySize() {
                return finalBuySize;
            }

            @Override
            public int getSellSize() {
                return finalSellSize;
            }

            @Override
            public double getBuyPrice() {
                return finalBuyPrice;
            }

            @Override
            public double getSellPrice() {
                return finalSellPrice;
            }
        };
    }

    private Material convertLegacyTypeToMaterial(int typeId, int typeData) {
        for (Material material : Material.values()) {
            if (material.getId() != typeId) continue;
            return Bukkit.getUnsafe().fromLegacy(new MaterialData(material, (byte)typeData));
        }
        return null;
    }

    YamlConfiguration getV3ShopsConfig() {
        YamlConfiguration config = new YamlConfiguration();
        ConfigurationSection shopsSection = config.createSection("shops");
        for (ShopConfig shopConfig : this.v3ShopConfigs) {
            ConfigurationSection shopSection = shopsSection.createSection(shopConfig.getName());
            shopSection.set("name", (Object)shopConfig.getFancyName());
            shopSection.set("permission", (Object)shopConfig.getRequiredPermission());
            shopSection.set("on-item-bought-cmd", (Object)shopConfig.getOnItemBoughtCommand());
            shopSection.set("on-item-sold-cmd", (Object)shopConfig.getOnItemSoldCommand());
            ConfigurationSection itemsSection = shopSection.createSection("items");
            for (ItemConfig itemConfig : shopConfig.getItems()) {
                ConfigurationSection itemSection = itemsSection.createSection(itemConfig.getName());
                this.addV3ItemConfigValues(itemSection, itemConfig);
            }
        }
        return config;
    }

    private void addV3ItemConfigValues(ConfigurationSection itemSection, ItemConfig itemConfig) {
        itemSection.set("name", (Object)itemConfig.getFancyName());
        itemSection.set("material", (Object)itemConfig.getMaterial().toString());
        itemSection.set("allow-buy", (Object)itemConfig.shouldAllowBuy());
        itemSection.set("allow-sell", (Object)itemConfig.shouldAllowSell());
        itemSection.set("buy-size", (Object)itemConfig.getBuySize());
        itemSection.set("sell-size", (Object)itemConfig.getSellSize());
        itemSection.set("buy-price", (Object)itemConfig.getBuyPrice());
        itemSection.set("sell-price", (Object)itemConfig.getSellPrice());
    }
}

