/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.config.migration;

import com.rictacius.customShop.config.Config;
import com.rictacius.customShop.config.ConfigFileException;
import com.rictacius.customShop.config.migration.MigrationException;
import com.rictacius.customShop.config.migration.Migrator;
import com.rictacius.customShop.config.migration.V2ShopsConfig;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

class ConfigVersion2Migrator
extends Migrator {
    ConfigVersion2Migrator() {
        super(2, 3);
    }

    @Override
    void migrate(File inputFolder, File outputFolder) throws MigrationException {
        this.migrateShops(inputFolder, outputFolder);
        this.migratePluginConfig(inputFolder, outputFolder);
    }

    private void migrateShops(File inputFolder, File outputFolder) throws MigrationException {
        V2ShopsConfig v2ShopsConfig;
        try {
            v2ShopsConfig = new V2ShopsConfig(inputFolder, "shops.yml");
        }
        catch (ConfigFileException e) {
            throw new MigrationException("Failed to parse v2 shops.yml", e);
        }
        YamlConfiguration v3ShopsConfig = v2ShopsConfig.getV3ShopsConfig();
        File outputFile = new File(outputFolder, "shops.yml");
        try {
            v3ShopsConfig.save(outputFile);
        }
        catch (IOException e) {
            throw new MigrationException("Failed to save v3 shops.yml", e);
        }
    }

    private void migratePluginConfig(File inputFolder, File outputFolder) throws MigrationException {
        try {
            Config pluginConfig = new Config(inputFolder, "config.yml"){

                @Override
                protected void onConfigFileLoaded() {
                }
            };
            FileConfiguration configYaml = pluginConfig.getUnderlyingFileConfiguration();
            configYaml.set("config-version", (Object)this.getOutputVersion());
            File outputFile = new File(outputFolder, "config.yml");
            configYaml.save(outputFile);
        }
        catch (ConfigFileException | IOException e) {
            throw new MigrationException("Failed to migrate config.yml", e);
        }
    }
}

