/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.config;

import com.rictacius.customShop.config.Config;
import com.rictacius.customShop.config.ConfigFileException;
import com.rictacius.customShop.config.ItemConfig;
import com.rictacius.customShop.config.ShopConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public class ShopsConfig
extends Config {
    private List<ShopConfig> shopConfigs;

    public ShopsConfig(File parentFolder) throws ConfigFileException {
        super(parentFolder, "shops.yml");
    }

    private void throwInvalidItemConfig(String shopName, String itemName, String problem) throws ConfigFileException {
        this.throwInvalidShopsConfig("(shop '" + shopName + "', item '" + itemName + "'): " + problem);
    }

    private void throwInvalidShopsConfig(String problem) throws ConfigFileException {
        throw new ConfigFileException("shops.yml is invalid: " + problem);
    }

    @Override
    protected void onConfigFileLoaded() throws ConfigFileException {
        this.loadShops();
    }

    private void loadShops() throws ConfigFileException {
        this.shopConfigs = new ArrayList<ShopConfig>();
        ConfigurationSection shopsSection = this.file.getConfigurationSection("shops");
        if (shopsSection == null) {
            this.throwInvalidShopsConfig("no 'shops' section");
        }
        for (String shopName : shopsSection.getKeys(false)) {
            ConfigurationSection shopConfig = shopsSection.getConfigurationSection(shopName);
            assert (shopConfig != null);
            this.shopConfigs.add(this.loadShop(shopName, shopConfig));
        }
    }

    private ShopConfig loadShop(final String shopName, ConfigurationSection shopConfig) throws ConfigFileException {
        final String fancyName = shopConfig.getString("name");
        final String requiredPermission = shopConfig.getString("permission");
        ConfigurationSection itemsConfig = shopConfig.getConfigurationSection("items");
        assert (itemsConfig != null);
        final List<ItemConfig> itemConfigs = this.loadItems(shopName, itemsConfig);
        final String onItemBoughtCommand = shopConfig.getString("on-item-bought-cmd");
        final String onItemSoldCommand = shopConfig.getString("on-item-sold-cmd");
        return new ShopConfig(){

            @Override
            public String getName() {
                return shopName;
            }

            @Override
            public String getFancyName() {
                return fancyName;
            }

            @Override
            @Nullable
            public String getRequiredPermission() {
                return requiredPermission;
            }

            @Override
            public List<ItemConfig> getItems() {
                return itemConfigs;
            }

            @Override
            public String getOnItemBoughtCommand() {
                return onItemBoughtCommand;
            }

            @Override
            public String getOnItemSoldCommand() {
                return onItemSoldCommand;
            }
        };
    }

    private List<ItemConfig> loadItems(String shopName, ConfigurationSection itemsConfig) throws ConfigFileException {
        ArrayList<ItemConfig> itemConfigs = new ArrayList<ItemConfig>();
        for (String itemName : itemsConfig.getKeys(false)) {
            ConfigurationSection itemSection = itemsConfig.getConfigurationSection(itemName);
            assert (itemSection != null);
            itemConfigs.add(this.loadItem(shopName, itemName, itemSection));
        }
        return itemConfigs;
    }

    private ItemConfig loadItem(String shopName, final String itemName, ConfigurationSection itemConfig) throws ConfigFileException {
        final String fancyName = itemConfig.getString("name");
        String materialName = itemConfig.getString("material");
        if (materialName == null) {
            this.throwInvalidItemConfig(shopName, itemName, "item " + itemName + " is missing a material");
        }
        final Material material = Material.matchMaterial((String)materialName);
        boolean allowBuy = itemConfig.getBoolean("allow-buy");
        boolean allowSell = itemConfig.getBoolean("allow-sell");
        if (!allowBuy && !allowSell) {
            this.throwInvalidItemConfig(shopName, itemName, "you can't disable both buying and selling of an item");
        }
        final int buySize = itemConfig.getInt("buy-size");
        final int sellSize = itemConfig.getInt("sell-size");
        if (allowBuy && buySize < 1) {
            allowBuy = false;
        }
        if (allowSell && sellSize < 1) {
            allowSell = false;
        }
        final double buyPrice = itemConfig.getDouble("buy-price");
        final double sellPrice = itemConfig.getDouble("sell-price");
        final boolean finalAllowBuy = allowBuy;
        final boolean finalAllowSell = allowSell;
        return new ItemConfig(){

            @Override
            public String getName() {
                return itemName;
            }

            @Override
            public String getFancyName() {
                return fancyName;
            }

            @Override
            public Material getMaterial() {
                return material;
            }

            @Override
            public boolean shouldAllowBuy() {
                return finalAllowBuy;
            }

            @Override
            public boolean shouldAllowSell() {
                return finalAllowSell;
            }

            @Override
            public int getBuySize() {
                return buySize;
            }

            @Override
            public int getSellSize() {
                return sellSize;
            }

            @Override
            public double getBuyPrice() {
                return buyPrice;
            }

            @Override
            public double getSellPrice() {
                return sellPrice;
            }
        };
    }

    public List<ShopConfig> getShopConfigs() {
        return this.shopConfigs;
    }
}

