/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.config;

import com.rictacius.customShop.config.Config;
import com.rictacius.customShop.config.ConfigFileException;
import java.io.File;

public class PluginConfig
extends Config {
    public PluginConfig(File parentFolder) throws ConfigFileException {
        super(parentFolder, "config.yml");
    }

    @Override
    protected void onConfigFileLoaded() throws ConfigFileException {
        int configVersion = this.getConfigVersion();
        if (configVersion < 3) {
            throw new ConfigFileException("config-version in config.yml is out of date");
        }
        if (configVersion > 3) {
            throw new ConfigFileException("This version of CustomShop cannot support your config.yml config-version");
        }
    }

    private int getConfigVersion() {
        return this.file.getInt("config-version");
    }

    public String getCurrency() {
        return this.file.getString("currency");
    }

    public String getShopPermission() {
        return this.file.getString("shop-perm");
    }

    public String getAdminPermission() {
        return this.file.getString("admin-perm");
    }

    public String getChestShopPermission() {
        return this.file.getString("chestshop-perm");
    }

    public String getItemsSoldMessage() {
        return this.file.getString("items-sold-message");
    }

    public String getNoPermissionMessage() {
        return this.file.getString("no-permission-message");
    }

    public String getUpdateFoundMessage() {
        return this.file.getString("update-found");
    }

    public String getSpanwerPlacedMessage() {
        return this.file.getString("spawner-placed-message");
    }

    public String getItemBuyLore() {
        return this.file.getString("item-buy-lore");
    }

    public String getStackBuyLore() {
        return this.file.getString("stack-buy-lore");
    }

    public String getItemSellLore() {
        return this.file.getString("item-sell-lore");
    }

    public String getStackSellLore() {
        return this.file.getString("stack-sell-lore");
    }

    public String getSpawnerName() {
        return this.file.getString("spawner-name");
    }

    public String getShopInventoryTitle() {
        return this.file.getString("shop-inventory-title");
    }

    public String getSellInventoryTitle() {
        return this.file.getString("sell-inventory-title");
    }

    public boolean shouldEnableStackBuying() {
        return this.file.getBoolean("enable-stack-buying");
    }
}

