/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.config;

import com.rictacius.customShop.Main;
import com.rictacius.customShop.config.ConfigFileException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class Config {
    private String fileName;
    private File configFile;
    protected FileConfiguration file;

    protected Config(File parentFolder, String fileName) throws ConfigFileException {
        this.fileName = fileName;
        this.configFile = new File(parentFolder, fileName);
        if (!this.configFile.exists()) {
            boolean folderCreated = parentFolder.mkdirs();
            if (!folderCreated) {
                throw new ConfigFileException("Failed to create the config file's parent folder.");
            }
            this.writeNewConfig(fileName, this.configFile);
        }
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewConfig(String source, File destFile) {
        ArrayList<String> sourceLines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(Main.class.getClassLoader().getResourceAsStream(source)));
            while ((line = reader.readLine()) != null) {
                sourceLines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            sourceLines.clear();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            Files.write(destFile.toPath(), sourceLines, Charset.forName("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() throws ConfigFileException {
        this.file = this.loadFile();
        this.onConfigFileLoaded();
    }

    private FileConfiguration loadFile() throws ConfigFileException {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new ConfigFileException("Failed to load config yaml", e);
        }
        return config;
    }

    protected abstract void onConfigFileLoaded() throws ConfigFileException;

    public String getFileName() {
        return this.fileName;
    }

    public FileConfiguration getUnderlyingFileConfiguration() {
        return this.file;
    }
}

