/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop;

import com.rictacius.customShop.Commands;
import com.rictacius.customShop.PermCheck;
import com.rictacius.customShop.ServerChecker;
import com.rictacius.customShop.Util;
import com.rictacius.customShop.config.Config;
import com.rictacius.customShop.config.ConfigFileException;
import com.rictacius.customShop.config.PluginConfig;
import com.rictacius.customShop.config.ShopsConfig;
import com.rictacius.customShop.config.migration.Migration;
import com.rictacius.customShop.config.migration.MigrationException;
import com.rictacius.customShop.shop.Sell;
import com.rictacius.customShop.shop.Shops;
import com.rictacius.customShop.updater.Updater;
import com.rictacius.customShop.updater.UpdaterException;
import java.io.File;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    public static Main plugin;
    private static PluginConfig config;
    private static ShopsConfig shopsConfig;
    private static Shops shops;
    private static Sell sell;
    private static Economy economy;
    private final PluginDescriptionFile pdfFile = this.getDescription();
    private boolean updateFound;

    public void onEnable() {
        plugin = this;
        this.registerConfig();
        Util.consoleLog("Registering Events....", ChatColor.YELLOW);
        this.registerEvents();
        Util.consoleLog("Checking for updates....", ChatColor.YELLOW);
        this.checkForUpdates();
        Util.consoleLog(this.pdfFile.getName() + " has been enabled! (V." + this.pdfFile.getVersion() + ")");
    }

    private void registerConfig() {
        this.updateConfig();
        this.createFiles();
        this.setupEconomy();
        shops = new Shops();
        sell = new Sell();
    }

    private void updateConfig() {
        try {
            Util.consoleLog("Updating Config....", ChatColor.YELLOW);
            Migration migration = new Migration(this.getDataFolder());
            migration.migrate();
        }
        catch (MigrationException e) {
            throw new RuntimeException("Failed to load CustomShop: Fatal error while updating config!", e);
        }
        Util.consoleLog("Config updated successfully");
    }

    private void createFiles() {
        try {
            Util.consoleLog("Registering Config....", ChatColor.YELLOW);
            File pluginDataFolder = this.getDataFolder();
            config = new PluginConfig(pluginDataFolder);
            shopsConfig = new ShopsConfig(pluginDataFolder);
        }
        catch (ConfigFileException e) {
            throw new RuntimeException("Failed to load CustomShop: Fatal error while registering config!", e);
        }
        Util.consoleLog("Config successful registered!");
    }

    private void setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            throw new RuntimeException("Failed to load CustomShop: Vault Economy service is required");
        }
        economy = (Economy)economyProvider.getProvider();
    }

    private void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)shops, (Plugin)this);
        pm.registerEvents((Listener)sell, (Plugin)this);
        pm.registerEvents((Listener)new ServerChecker(), (Plugin)this);
        pm.registerEvents((Listener)new Commands(), (Plugin)this);
        Util.consoleLog("Events successful registered!");
    }

    private void checkForUpdates() {
        try {
            Updater updater = new Updater();
            this.updateFound = updater.isNewVersionAvailable();
            if (updater.isDevBuild()) {
                Util.consoleLog("You are running a dev build of CustomShop.");
            } else if (this.updateFound) {
                Util.consoleLog("Found update (new-version = v" + updater.getNewVersionName() + ").");
            } else {
                Util.consoleLog("CustomShop is up to date.");
            }
        }
        catch (UpdaterException e) {
            Util.consoleLog("Could not check for updates", ChatColor.RED);
            this.updateFound = false;
            e.printStackTrace();
        }
    }

    public void onDisable() {
        Util.consoleLog(this.pdfFile.getName() + " has been disabled! (V." + this.pdfFile.getVersion() + ")", ChatColor.YELLOW);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.updateFound && PermCheck.senderHasAccess((CommandSender)e.getPlayer(), config.getAdminPermission())) {
            e.getPlayer().spigot().sendMessage((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getUpdateFoundMessage())));
        }
    }

    void reloadAllConfigFiles() {
        Config[] configFiles;
        for (Config configFile : configFiles = new Config[]{config, shopsConfig}) {
            try {
                configFile.reload();
            }
            catch (ConfigFileException e) {
                Util.consoleLog(ChatColor.GOLD, "Could not reload " + configFile.getFileName(), ChatColor.RED);
                e.printStackTrace();
            }
        }
        shops.loadShops();
    }

    public FileConfiguration getConfig() {
        return Main.getPluginConfig().getUnderlyingFileConfiguration();
    }

    public static PluginConfig getPluginConfig() {
        return config;
    }

    public static ShopsConfig getShopsConfig() {
        return shopsConfig;
    }

    public static Shops getShops() {
        return shops;
    }

    public static Sell getSell() {
        return sell;
    }

    public static Economy getEconomy() {
        return economy;
    }
}

