/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.visual;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.mineacademy.fo.BlockUtil;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.region.Region;
import org.mineacademy.fo.remain.CompParticle;

public final class VisualizedRegion
extends Region {
    private final List<Player> viewers = new ArrayList<Player>();
    private BukkitTask task;
    private CompParticle particle = CompParticle.VILLAGER_HAPPY;

    public VisualizedRegion(Location primary, Location secondary) {
        super(primary, secondary);
    }

    public VisualizedRegion(String name, Location primary, Location secondary) {
        super(name, primary, secondary);
    }

    public void showParticles(Player player, int durationTicks) {
        this.showParticles(player);
        Common.runLater(durationTicks, () -> {
            if (this.canSeeParticles(player)) {
                this.hideParticles(player);
            }
        });
    }

    public void showParticles(Player player) {
        Valid.checkBoolean(!this.canSeeParticles(player), "Player " + player.getName() + " already sees region " + this, new Object[0]);
        Valid.checkBoolean(this.isWhole(), "Cannot show particles of an incomplete region " + this, new Object[0]);
        this.viewers.add(player);
        if (this.task == null) {
            this.startVisualizing();
        }
    }

    public void hideParticles(Player player) {
        Valid.checkBoolean(this.canSeeParticles(player), "Player " + player.getName() + " is not seeing region " + this, new Object[0]);
        this.viewers.remove(player);
        if (this.viewers.isEmpty() && this.task != null) {
            this.stopVisualizing();
        }
    }

    public boolean canSeeParticles(Player player) {
        return this.viewers.contains(player);
    }

    private void startVisualizing() {
        Valid.checkBoolean(this.task == null, "Already visualizing region " + this + "!", new Object[0]);
        Valid.checkBoolean(this.isWhole(), "Cannot visualize incomplete region " + this + "!", new Object[0]);
        this.task = Common.runTimer(23, (Runnable)new BukkitRunnable(){

            public void run() {
                if (VisualizedRegion.this.viewers.isEmpty()) {
                    VisualizedRegion.this.stopVisualizing();
                    return;
                }
                Set<Location> blocks = BlockUtil.getBoundingBox(VisualizedRegion.this.getPrimary(), VisualizedRegion.this.getSecondary());
                for (Location location : blocks) {
                    for (Player viewer : VisualizedRegion.this.viewers) {
                        if (!(viewer.getLocation().distance(location) < 100.0)) continue;
                        VisualizedRegion.this.particle.spawnFor(viewer, location);
                    }
                }
            }
        });
    }

    private void stopVisualizing() {
        Valid.checkNotNull(this.task, "Region " + this + " not visualized");
        this.task.cancel();
        this.task = null;
        this.viewers.clear();
    }

    public static VisualizedRegion deserialize(SerializedMap map) {
        Valid.checkBoolean(map.containsKey("Primary") && map.containsKey("Secondary"), "The region must have Primary and a Secondary location", new Object[0]);
        String name = map.getString("Name");
        Location prim = map.getLocation("Primary");
        Location sec = map.getLocation("Secondary");
        return new VisualizedRegion(name, prim, sec);
    }

    public void setParticle(CompParticle particle) {
        this.particle = particle;
    }
}

