/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.visual;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.mineacademy.fo.menu.tool.BlockTool;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.visual.BlockVisualizer;
import org.mineacademy.fo.visual.VisualizedRegion;

public abstract class VisualTool
extends BlockTool {
    @Override
    protected final void onBlockClick(Player player, ClickType click, Block block) {
        this.stopVisualizing(player);
        this.handleBlockClick(player, click, block);
        this.visualize(player);
    }

    protected abstract void handleBlockClick(Player var1, ClickType var2, Block var3);

    @Override
    protected final void onAirClick(Player player, ClickType click) {
        this.stopVisualizing(player);
        this.handleAirClick(player, click);
        this.visualize(player);
    }

    protected void handleAirClick(Player player, ClickType click) {
    }

    @Override
    protected final void onHotbarFocused(Player player) {
        this.visualize(player);
    }

    @Override
    protected final void onHotbarDefocused(Player player) {
        this.stopVisualizing(player);
    }

    protected abstract List<Location> getVisualizedPoints();

    protected VisualizedRegion getVisualizedRegion() {
        return null;
    }

    protected abstract String getBlockName(Block var1, Player var2);

    protected abstract CompMaterial getBlockMask(Block var1, Player var2);

    private void visualize(Player player) {
        VisualizedRegion region = this.getVisualizedRegion();
        if (region != null && region.isWhole() && !region.canSeeParticles(player)) {
            region.showParticles(player);
        }
        for (Location location : this.getVisualizedPoints()) {
            Block block;
            if (location == null || BlockVisualizer.isVisualized(block = location.getBlock())) continue;
            BlockVisualizer.visualize(block, this.getBlockMask(block, player), this.getBlockName(block, player));
        }
    }

    private void stopVisualizing(Player player) {
        VisualizedRegion region = this.getVisualizedRegion();
        if (region != null && region.canSeeParticles(player)) {
            region.hideParticles(player);
        }
        for (Location location : this.getVisualizedPoints()) {
            Block block;
            if (location == null || !BlockVisualizer.isVisualized(block = location.getBlock())) continue;
            BlockVisualizer.stopVisualizing(block);
        }
    }

    protected VisualTool() {
    }
}

