/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.settings;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.constants.FoConstants;
import org.mineacademy.fo.model.BoxedMessage;
import org.mineacademy.fo.model.Replacer;
import org.mineacademy.fo.model.SimpleSound;
import org.mineacademy.fo.model.SimpleTime;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.YamlConfig;

public abstract class YamlStaticConfig {
    private static YamlConfig TEMPORARY_INSTANCE;

    protected YamlStaticConfig() {
        TEMPORARY_INSTANCE = new YamlConfig(){
            {
                YamlStaticConfig.this.beforeLoad();
            }

            @Override
            protected void onLoadFinish() {
                YamlStaticConfig.this.loadViaReflection();
            }
        };
        TEMPORARY_INSTANCE.setHeader(this.getHeader());
    }

    public static final void load(List<Class<? extends YamlStaticConfig>> classes) throws Exception {
        if (classes == null) {
            return;
        }
        for (Class<? extends YamlStaticConfig> clazz : classes) {
            YamlStaticConfig config = clazz.newInstance();
            config.load();
            TEMPORARY_INSTANCE = null;
        }
    }

    protected String[] getHeader() {
        return FoConstants.Header.UPDATED_FILE;
    }

    protected void beforeLoad() {
    }

    protected void preLoad() {
    }

    protected abstract void load() throws Exception;

    private final void loadViaReflection() {
        Valid.checkNotNull(TEMPORARY_INSTANCE, "Instance cannot be null " + YamlStaticConfig.getFileName());
        Valid.checkNotNull(TEMPORARY_INSTANCE.getConfig(), "Config cannot be null for " + YamlStaticConfig.getFileName());
        Valid.checkNotNull(TEMPORARY_INSTANCE.getDefaults(), "Default config cannot be null for " + YamlStaticConfig.getFileName());
        try {
            this.preLoad();
            if (YamlStaticConfig.class.isAssignableFrom(this.getClass().getSuperclass())) {
                Class<?> superClass = this.getClass().getSuperclass();
                this.invokeAll(superClass);
            }
            this.invokeAll(this.getClass());
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            Remain.sneaky(t);
        }
    }

    private void invokeAll(Class<?> clazz) throws Exception {
        this.invokeMethodsIn(clazz);
        for (Class<?> subClazz : clazz.getDeclaredClasses()) {
            this.invokeMethodsIn(subClazz);
            for (Class<?> subSubClazz : subClazz.getDeclaredClasses()) {
                this.invokeMethodsIn(subSubClazz);
            }
        }
    }

    private void invokeMethodsIn(Class<?> clazz) throws Exception {
        for (Method m : clazz.getDeclaredMethods()) {
            if (!SimplePlugin.getInstance().isEnabled()) {
                return;
            }
            int mod = m.getModifiers();
            if (!m.getName().equals("init")) continue;
            Valid.checkBoolean(Modifier.isPrivate(mod) && Modifier.isStatic(mod) && m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 0, "Method '" + m.getName() + "' in " + clazz + " must be 'private static void init()'", new Object[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        this.checkFields(clazz);
    }

    private void checkFields(Class<?> clazz) throws Exception {
        for (Field f : clazz.getDeclaredFields()) {
            f.setAccessible(true);
            if (Modifier.isPublic(f.getModifiers())) {
                Valid.checkBoolean(!f.getType().isPrimitive(), "Field '" + f.getName() + "' in " + clazz + " must not be primitive!", new Object[0]);
            }
            Object result = null;
            try {
                result = f.get(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Valid.checkNotNull(result, "Null " + f.getType().getSimpleName() + " field '" + f.getName() + "' in " + clazz);
        }
    }

    protected final void createLocalizationFile(String localePrefix) throws Exception {
        TEMPORARY_INSTANCE.loadLocalization(localePrefix);
    }

    protected final void createFileAndLoad(String path) throws Exception {
        TEMPORARY_INSTANCE.loadConfiguration(path, path);
    }

    protected static final void set(String path, Object value) {
        TEMPORARY_INSTANCE.setNoSave(path, value);
    }

    protected static final boolean isSetAbsolute(String path) {
        return TEMPORARY_INSTANCE.isSetAbsolute(path);
    }

    protected static final boolean isSet(String path) {
        return TEMPORARY_INSTANCE.isSet(path);
    }

    protected static final boolean isSetDefault(String path) {
        return TEMPORARY_INSTANCE.isSetDefault(path);
    }

    protected static final boolean isSetDefaultAbsolute(String path) {
        return TEMPORARY_INSTANCE.isSetDefaultAbsolute(path);
    }

    protected static final void move(String fromRelative, String toAbsolute) {
        TEMPORARY_INSTANCE.move(fromRelative, toAbsolute);
    }

    protected static final void move(Object value, String fromPath, String toPath) {
        TEMPORARY_INSTANCE.move(value, fromPath, toPath);
    }

    protected static final void pathPrefix(String pathPrefix) {
        TEMPORARY_INSTANCE.pathPrefix(pathPrefix);
    }

    protected static final String getPathPrefix() {
        return TEMPORARY_INSTANCE.getPathPrefix();
    }

    protected static final void addDefaultIfNotExist(String path) {
        TEMPORARY_INSTANCE.addDefaultIfNotExist(path);
    }

    protected static final String getFileName() {
        return TEMPORARY_INSTANCE.getFileName();
    }

    protected static final YamlConfiguration getConfig() {
        return TEMPORARY_INSTANCE.getConfig();
    }

    protected static final YamlConfiguration getDefaults() {
        return TEMPORARY_INSTANCE.getDefaults();
    }

    protected static final StrictList<Enchantment> getEnchantments(String path) {
        return TEMPORARY_INSTANCE.getEnchants(path);
    }

    protected static final StrictList<CompMaterial> getMaterialList(String path) {
        return TEMPORARY_INSTANCE.getMaterialList(path);
    }

    protected static final StrictList<String> getCommandList(String path) {
        return TEMPORARY_INSTANCE.getCommandList(path);
    }

    protected static final List<String> getStringList(String path) {
        return TEMPORARY_INSTANCE.getStringList(path);
    }

    protected static final <E> List<E> getList(String path, Class<E> listType) {
        return TEMPORARY_INSTANCE.getList(path, listType);
    }

    protected static final <E extends Enum<E>> List<E> getCompatibleEnumList(String path, Class<E> listType) {
        return TEMPORARY_INSTANCE.getCompatibleEnumList(path, listType);
    }

    protected static final boolean getBoolean(String path) {
        return TEMPORARY_INSTANCE.getBoolean(path);
    }

    protected static final String[] getStringArray(String path) {
        return TEMPORARY_INSTANCE.getStringArray(path);
    }

    protected static final String getString(String path) {
        return TEMPORARY_INSTANCE.getString(path);
    }

    protected static final Replacer getReplacer(String path) {
        return TEMPORARY_INSTANCE.getReplacer(path);
    }

    protected static final int getInteger(String path) {
        return TEMPORARY_INSTANCE.getInteger(path);
    }

    @Deprecated
    protected static final double getDoubleSafe(String path) {
        return TEMPORARY_INSTANCE.getDoubleSafe(path);
    }

    protected static final double getDouble(String path) {
        return TEMPORARY_INSTANCE.getDouble(path);
    }

    protected static final SimpleSound getSound(String path) {
        return TEMPORARY_INSTANCE.getSound(path);
    }

    protected static final YamlConfig.CasusHelper getCasus(String path) {
        return TEMPORARY_INSTANCE.getCasus(path);
    }

    protected static final YamlConfig.TitleHelper getTitle(String path) {
        return TEMPORARY_INSTANCE.getTitle(path);
    }

    protected static final SimpleTime getTime(String path) {
        return TEMPORARY_INSTANCE.getTime(path);
    }

    protected static final CompMaterial getMaterial(String path) {
        return TEMPORARY_INSTANCE.getMaterial(path);
    }

    protected static final BoxedMessage getBoxedMessage(String path) {
        return TEMPORARY_INSTANCE.getBoxedMessage(path);
    }

    protected static final <E> E get(String path, Class<E> typeOf) {
        return TEMPORARY_INSTANCE.get(path, typeOf);
    }

    protected static final <E> E getWithData(String path, Class<E> typeOf, Object ... deserializeArguments) {
        return TEMPORARY_INSTANCE.getWithData(path, typeOf, deserializeArguments);
    }

    protected static final Object getObject(String path) {
        return TEMPORARY_INSTANCE.getObject(path);
    }

    protected static final <T> T getOrSetDefault(String path, T defaultValue) {
        return TEMPORARY_INSTANCE.getOrSetDefault(path, defaultValue);
    }

    protected static final SerializedMap getMap(String path) {
        return TEMPORARY_INSTANCE.getMap(path);
    }

    protected static final <Key, Value> LinkedHashMap<Key, Value> getMap(String path, Class<Key> keyType, Class<Value> valueType) {
        return TEMPORARY_INSTANCE.getMap(path, keyType, valueType);
    }

    protected static LinkedHashMap<String, LinkedHashMap<String, Object>> getValuesAndKeys(String path) {
        Valid.checkNotNull(path, "Path cannot be null");
        if (YamlStaticConfig.getDefaults() != null && !YamlStaticConfig.getConfig().isSet(path)) {
            Valid.checkBoolean(YamlStaticConfig.getDefaults().isSet(path), "Default '" + YamlStaticConfig.getFileName() + "' lacks a section at " + path, new Object[0]);
            for (String name : YamlStaticConfig.getDefaults().getConfigurationSection(path).getKeys(false)) {
                for (String setting : YamlStaticConfig.getDefaults().getConfigurationSection(path + "." + name).getKeys(false)) {
                    TEMPORARY_INSTANCE.addDefaultIfNotExist(path + "." + name + "." + setting, Object.class);
                }
            }
        }
        Valid.checkBoolean(YamlStaticConfig.getConfig().isSet(path), "Malfunction copying default section to " + path, new Object[0]);
        TreeMap<String, LinkedHashMap<String, Object>> groups = new TreeMap<String, LinkedHashMap<String, Object>>();
        String old = TEMPORARY_INSTANCE.getPathPrefix();
        TEMPORARY_INSTANCE.pathPrefix(null);
        for (String name : YamlStaticConfig.getConfig().getConfigurationSection(path).getKeys(false)) {
            LinkedHashMap<String, Object> valuesRaw = YamlStaticConfig.getMap(path + "." + name, String.class, Object.class);
            groups.put(name, valuesRaw);
        }
        TEMPORARY_INSTANCE.pathPrefix(old);
        return new LinkedHashMap<String, LinkedHashMap<String, Object>>(groups);
    }
}

