/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.settings;

import java.io.File;
import java.io.InputStream;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.ItemUtil;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.constants.FoConstants;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.model.BoxedMessage;
import org.mineacademy.fo.model.ConfigSerializable;
import org.mineacademy.fo.model.Replacer;
import org.mineacademy.fo.model.SimpleSound;
import org.mineacademy.fo.model.SimpleTime;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.ConfigInstance;
import org.mineacademy.fo.settings.LegacyEnum;

public class YamlConfig
implements ConfigSerializable {
    public static final String NO_DEFAULT = null;
    private static final StrictMap<ConfigInstance, List<YamlConfig>> loadedFiles = new StrictMap();
    private ConfigInstance instance;
    private String[] header;
    private String pathPrefix = null;
    private boolean save = false;
    private boolean usingDefaults = true;
    private boolean loading = false;
    private final boolean checkAssignables = true;

    protected YamlConfig() {
    }

    public static final void clearLoadedFiles() {
        loadedFiles.clear();
    }

    public static final void unregisterLoadedFile(File file) {
        for (ConfigInstance instance : loadedFiles.keySet()) {
            if (!instance.equals(file)) continue;
            loadedFiles.remove(instance);
            break;
        }
    }

    protected static final ConfigInstance findInstance(String fileName) {
        for (ConfigInstance instance : loadedFiles.keySet()) {
            if (!instance.equals(fileName)) continue;
            return instance;
        }
        return null;
    }

    private static void addConfig(ConfigInstance instance, YamlConfig config) {
        List<YamlConfig> existing = loadedFiles.get(instance);
        if (existing == null) {
            existing = new ArrayList<YamlConfig>();
        }
        existing.add(config);
        loadedFiles.put(instance, existing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadLocalization(String localePrefix) throws Exception {
        Valid.checkNotNull(localePrefix, "locale cannot be null!");
        try {
            this.loading = true;
            String localePath = "localization/messages_" + localePrefix + ".yml";
            InputStream is = FileUtil.getInternalResource(localePath);
            Valid.checkNotNull(is, SimplePlugin.getNamed() + " does not support the localization: messages_" + localePrefix + ".yml (For custom locale, set the Locale to 'en' and edit your English file instead)");
            File file = new File(SimplePlugin.getData(), localePath);
            ConfigInstance instance = YamlConfig.findInstance(file.getName());
            if (instance == null) {
                if (!file.exists()) {
                    FileUtil.extract(localePath, line -> this.replaceVariables((String)line, FileUtil.getFileName(localePath)));
                }
                YamlConfiguration config = FileUtil.loadConfigurationStrict(file);
                YamlConfiguration defaultsConfig = Remain.loadConfiguration(is);
                Valid.checkBoolean(file != null && file.exists(), "Failed to load " + localePath + " from " + file, new Object[0]);
                instance = new ConfigInstance(file, config, defaultsConfig);
                YamlConfig.addConfig(instance, this);
            }
            this.instance = instance;
            this.onLoadFinish();
        }
        finally {
            this.loading = false;
        }
        this.saveIfNecessary0();
    }

    protected final void loadConfiguration(String file) {
        this.loadConfiguration(file, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadConfiguration(String from, String to) {
        Valid.checkNotNull(to, "File to path cannot be null!");
        Valid.checkBoolean(to.contains("."), "To path must contain file extension: " + to, new Object[0]);
        if (from != null) {
            Valid.checkBoolean(from.contains("."), "From path must contain file extension: " + from, new Object[0]);
        }
        try {
            this.loading = true;
            ConfigInstance instance = YamlConfig.findInstance(to);
            if (instance == null) {
                File file;
                YamlConfiguration defaultsConfig = null;
                if (from != null) {
                    InputStream is = FileUtil.getInternalResource(from);
                    Valid.checkNotNull(is, "Inbuilt resource not found: " + from);
                    defaultsConfig = Remain.loadConfiguration(is);
                    file = FileUtil.extract(from, to, line -> this.replaceVariables((String)line, FileUtil.getFileName(to)));
                } else {
                    file = FileUtil.getOrMakeFile(to);
                }
                Valid.checkNotNull(file, "Failed to " + (from != null ? "copy settings from " + from + " to " : "read settings from ") + to);
                YamlConfiguration config = FileUtil.loadConfigurationStrict(file);
                instance = new ConfigInstance(file, config, defaultsConfig);
                YamlConfig.addConfig(instance, this);
            }
            this.instance = instance;
            try {
                this.onLoadFinish();
            }
            catch (Exception ex) {
                Common.throwError(ex, "Error loading configuration in " + this.getFileName() + "!", "Problematic section: " + Common.getOrDefault(this.getPathPrefix(), "''"), "Problem: " + ex + " (see below for more)");
            }
        }
        finally {
            this.loading = false;
        }
        this.saveIfNecessary0();
    }

    private void saveIfNecessary0() {
        if (this.save || this.getDefaults() == null) {
            this.save();
            this.save = false;
        }
    }

    private void rewriteVariablesIn(File file) {
        List<String> lines = FileUtil.readLines(file);
        String fileName = FileUtil.getFileName(file.getName()).toLowerCase();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            lines.set(i, this.replaceVariables(line, fileName));
        }
        FileUtil.write(file, lines, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private String replaceVariables(String line, String fileName) {
        line = line.replace("{plugin_name}", SimplePlugin.getNamed().toLowerCase());
        line = line.replace("{file}", fileName);
        line = line.replace("{file_lowercase}", fileName);
        return line;
    }

    protected void onLoadFinish() {
    }

    protected final YamlConfiguration getConfig() {
        return this.instance.getConfig();
    }

    @Nullable
    protected final YamlConfiguration getDefaults() {
        return this.instance.getDefaultConfig();
    }

    protected final String getFileName() {
        return this.instance.getFile().getName();
    }

    protected final void setHeader(String ... header) {
        this.header = header;
    }

    public String getName() {
        return FileUtil.getFileName(this.instance.getFile());
    }

    public final void save() {
        if (this.loading) {
            if (!this.save) {
                this.save = true;
            }
            return;
        }
        String file = this.getFileName();
        this.onSave();
        for (Map.Entry<String, Object> entry : this.serialize().entrySet()) {
            this.setNoSave(entry.getKey(), entry.getValue());
        }
        this.instance.save(this.header != null ? this.header : (file.equals("data.db") ? FoConstants.Header.DATA_FILE : FoConstants.Header.UPDATED_FILE));
        this.rewriteVariablesIn(this.instance.getFile());
    }

    protected void onSave() {
    }

    public final void delete() {
        this.instance.delete();
    }

    public final void reload() {
        try {
            this.instance.reload();
            this.onLoadFinish();
            this.saveIfNecessary0();
        }
        catch (Exception e) {
            Common.error(e, "Failed to reload " + this.getFileName());
        }
    }

    @Override
    public SerializedMap serialize() {
        return new SerializedMap();
    }

    private <T> T getT(String path, Class<T> type) {
        Valid.checkNotNull(path, "Path cannot be null");
        path = this.formPathPrefix(path);
        Valid.checkBoolean(!path.contains(".."), "Path must not contain '..' or more: " + path, new Object[0]);
        Valid.checkBoolean(!path.endsWith("."), "Path must not end with '.': " + path, new Object[0]);
        this.addDefaultIfNotExist(path, type);
        ArrayList raw = this.getConfig().get(path);
        if (this.getDefaults() != null) {
            Valid.checkNotNull(raw, "Failed to insert value at '" + path + "' from default config");
        }
        if (raw != null) {
            if (((Object)raw).equals("[]") && type == List.class) {
                raw = new ArrayList();
            }
            this.checkAssignable(false, path, raw, type);
        }
        return (T)raw;
    }

    protected final <T> T get(String path, Class<T> type) {
        return this.get(path, type, null);
    }

    protected final <T> T get(String path, Class<T> type, T def) {
        Object object = this.getT(path, Object.class);
        return object != null ? SerializeUtil.deserialize(type, object) : def;
    }

    protected final <T> T getWithData(String path, Class<T> type, Object ... deserializeArguments) {
        Object object = this.getT(path, Object.class);
        return object != null ? (T)SerializeUtil.deserialize(type, object, deserializeArguments) : null;
    }

    protected final Object getObject(String path, Object def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getObject(path) : def;
    }

    protected final Object getObject(String path) {
        return this.getT(path, Object.class);
    }

    @Deprecated
    protected final <T> T getEnum(String path, Class<T> type) {
        return this.get(path, type);
    }

    protected final Boolean getBoolean(String path, boolean def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getBoolean(path) : def;
    }

    protected final Boolean getBoolean(String path) {
        return this.getT(path, Boolean.class);
    }

    protected final String getString(String path, String def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getString(path) : def;
    }

    protected final String getString(String path) {
        return this.getT(path, String.class);
    }

    protected final Long getLong(String path, Long def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getLong(path) : def;
    }

    protected final Long getLong(String path) {
        return this.getT(path, Long.class);
    }

    protected final Integer getInteger(String path, Integer def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getInteger(path) : def;
    }

    protected final Integer getInteger(String path) {
        return this.getT(path, Integer.class);
    }

    @Deprecated
    protected final Double getDoubleSafe(String path) {
        return this.getDouble(path);
    }

    protected final Double getDouble(String path, Double def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getDouble(path) : def;
    }

    protected final Double getDouble(String path) {
        Object raw = this.getObject(path);
        return raw != null ? Double.valueOf(Double.parseDouble(raw.toString())) : null;
    }

    protected final Replacer getReplacer(String path, String def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getReplacer(path) : Replacer.of(def);
    }

    protected final Replacer getReplacer(String path) {
        return Replacer.of(this.getString(path));
    }

    protected final LocationList getLocations(String path) {
        return new LocationList(this, this.getList(path, Location.class));
    }

    protected final Location getLocation(String path, Location def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getLocation(path) : def;
    }

    protected final Location getLocation(String path) {
        return this.get(path, Location.class);
    }

    protected final SimpleSound getSound(String path, SimpleSound def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getSound(path) : def;
    }

    protected final SimpleSound getSound(String path) {
        return new SimpleSound(this.getString(path));
    }

    protected final CasusHelper getCasus(String path, CasusHelper def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getCasus(path) : def;
    }

    protected final CasusHelper getCasus(String path) {
        return new CasusHelper(this.getString(path));
    }

    protected final TitleHelper getTitle(String path, String defTitle, String defSubtitle) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getTitle(path) : new TitleHelper(defTitle, defSubtitle);
    }

    protected final TitleHelper getTitle(String path) {
        return new TitleHelper(path);
    }

    protected final SimpleTime getTime(String path, String def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getTime(path) : SimpleTime.from(def);
    }

    protected final SimpleTime getTime(String path) {
        Object obj = this.getObject(path);
        Valid.checkNotNull(obj, "No time specified at the path '" + path + "' in " + this.getFileName());
        return SimpleTime.from(obj.toString());
    }

    protected final BoxedMessage getBoxedMessage(String path, String def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getBoxedMessage(path) : new BoxedMessage(def);
    }

    protected final BoxedMessage getBoxedMessage(String path) {
        return new BoxedMessage(this.getString(path));
    }

    protected final CompMaterial getMaterial(String path, CompMaterial def) {
        this.forceSingleDefaults(path);
        return this.isSet(path) ? this.getMaterial(path) : def;
    }

    protected final CompMaterial getMaterial(String path) {
        String name = this.getString(path);
        return name == null ? null : CompMaterial.fromStringStrict(name);
    }

    protected final List<Object> getList(String path) {
        List list = this.getT(path, List.class);
        return Common.getOrDefault(list, new ArrayList());
    }

    protected final List<SerializedMap> getMapList(String path) {
        return this.getList(path, SerializedMap.class);
    }

    @Deprecated
    protected final <T> Set<T> getSetSafe(String key, Class<T> type) {
        return this.getSet(key, type);
    }

    protected final <T> Set<T> getSet(String key, Class<T> type) {
        List<T> list = this.getList(key, type);
        return list == null ? new HashSet() : new HashSet<T>(list);
    }

    protected final <T> List<T> getList(String path, Class<T> type) {
        return this.getList(path, type, null);
    }

    protected final <T> List<T> getList(String path, Class<T> type, Object ... deserializeParameters) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<Object> objects = this.getList(path);
        if (objects != null) {
            for (Object object : objects) {
                list.add(object != null ? (Object)SerializeUtil.deserialize(type, object, deserializeParameters) : null);
            }
        }
        return list;
    }

    protected final <T extends Enum<T>> List<T> getCompatibleEnumList(String path, Class<T> type) {
        StrictList list = new StrictList();
        List<String> enumNames = this.getStringList(path);
        if (enumNames != null) {
            for (String enumName : enumNames) {
                Object parsedEnum;
                block4: {
                    parsedEnum = null;
                    try {
                        parsedEnum = ReflectionUtil.lookupEnumSilent(type, enumName);
                    }
                    catch (ReflectionUtil.MissingEnumException ex) {
                        if (LegacyEnum.isIncompatible(type, enumName)) break block4;
                        throw ex;
                    }
                }
                if (parsedEnum == null) continue;
                list.add(parsedEnum);
            }
        }
        return list.getSource();
    }

    protected final String[] getStringArray(String path) {
        Object array = this.getObject(path);
        return array != null ? String.join((CharSequence)"\n", array.toString()).split("\n") : new String[]{};
    }

    protected final List<String> getStringList(String path) {
        Object raw = this.getObject(path);
        if (raw instanceof String) {
            String output = (String)raw;
            return "'[]'".equals(output) || "[]".equals(output) ? new ArrayList<String>() : Arrays.asList(output);
        }
        List<Object> list = this.getList(path);
        return list != null ? this.fixYamlBooleansInList(list) : new ArrayList();
    }

    private List<String> fixYamlBooleansInList(@NonNull Iterable<Object> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (Object obj : list) {
            if (obj == null) continue;
            newList.add(obj.toString());
        }
        return newList;
    }

    protected final StrictList<String> getCommandList(String path) {
        List<String> list = this.getStringList(path);
        Valid.checkBoolean(!list.isEmpty(), "Please set at least one command alias in '" + path + "' (" + this.getFileName() + ") for this will be used as your main command!", new Object[0]);
        return new StrictList<String>((Iterable<String>)list);
    }

    protected final StrictList<CompMaterial> getMaterialList(String path) {
        StrictList<CompMaterial> list = new StrictList<CompMaterial>();
        for (String raw : this.getStringList(path)) {
            CompMaterial mat = CompMaterial.fromStringCompat(raw);
            if (mat == null) continue;
            list.add(mat);
        }
        return list;
    }

    protected final StrictList<Enchantment> getEnchants(String path) {
        StrictList<Enchantment> list = new StrictList<Enchantment>();
        for (String name : this.getStringList(path)) {
            list.add(ItemUtil.findEnchantment(name));
        }
        return list;
    }

    protected final SerializedMap getMap(String path) {
        return this.isSet(path) ? SerializedMap.of(Common.getMapFromSection(this.getT(path, Object.class))) : new SerializedMap();
    }

    public final <Key, Value> LinkedHashMap<Key, Value> getMap(@NonNull String path, Class<Key> keyType, Class<Value> valueType) {
        ConfigurationSection configSection;
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        LinkedHashMap<Key, Value> map = new LinkedHashMap<Key, Value>();
        YamlConfiguration config = this.getConfig();
        YamlConfiguration defaults = this.getDefaults();
        path = this.formPathPrefix(path);
        if (defaults != null && !config.isSet(path)) {
            Valid.checkBoolean(defaults.isSet(path), "Default '" + this.getFileName() + "' lacks a map at " + path, new Object[0]);
            for (String key : defaults.getConfigurationSection(path).getKeys(false)) {
                this.addDefaultIfNotExist(path + "." + key, valueType);
            }
        }
        if ((configSection = config.getConfigurationSection(path)) != null) {
            for (Map.Entry entry : configSection.getValues(false).entrySet()) {
                Key key = SerializeUtil.deserialize(keyType, entry.getKey());
                Value value = SerializeUtil.deserialize(valueType, entry.getValue());
                this.checkAssignable(false, path, key, keyType);
                this.checkAssignable(false, path, value, valueType);
                map.put(key, value);
            }
        }
        return map;
    }

    @Deprecated
    protected final <E extends Enum<E>> StrictList<E> getEnumList_OLD(String path, Class<E> listType) {
        StrictList<Object> list = new StrictList<Object>();
        for (String item : this.getStringList(path)) {
            Object mat;
            if (item.equals("*")) {
                return new StrictList();
            }
            if (listType == Material.class) {
                mat = CompMaterial.fromStringCompat(item).getMaterial();
                if (mat == null) continue;
                list.add(mat);
                continue;
            }
            if (listType == CompMaterial.class) {
                mat = CompMaterial.fromStringCompat(item);
                if (mat == null) continue;
                list.add(mat);
                continue;
            }
            if (listType == CreatureSpawnEvent.SpawnReason.class && "DROWNED".equals(item) && MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) continue;
            list.add(ReflectionUtil.lookupEnum(listType, item));
        }
        return list;
    }

    protected final void save(String path, Object value) {
        this.setNoSave(path, value);
        this.save();
    }

    protected final void setIfNotExist(String path, Object value) {
        if (!this.isSet(path)) {
            this.setNoSave(path, value);
        }
    }

    protected final void setNoSave(String path, Object value) {
        path = this.formPathPrefix(path);
        value = SerializeUtil.serialize(value);
        this.getConfig().set(path, value);
        this.save = true;
    }

    protected final void move(String fromRelative, String toAbsolute) {
        this.move(this.getObject(fromRelative), fromRelative, toAbsolute);
    }

    protected final void move(Object value, String fromPathRel, String toPathAbs) {
        String oldPathPrefix = this.pathPrefix;
        fromPathRel = this.formPathPrefix(fromPathRel);
        this.getConfig().set(fromPathRel, null);
        this.pathPrefix = oldPathPrefix;
        this.checkAndFlagForSave(toPathAbs, value, false);
        this.getConfig().set(toPathAbs, value);
        Common.log("&7Update " + this.getFileName() + ". Move &b'&f" + fromPathRel + "&b' &7(was '" + value + "&7') to &b'&f" + toPathAbs + "&b'&r");
        this.pathPrefix = oldPathPrefix;
    }

    protected final <O, N> void convertMapList(String path, String mapSection, Class<O> from, Class<N> to, Function<O, N> converter) {
        ArrayList<SerializedMap> list = new ArrayList<SerializedMap>();
        for (SerializedMap classMap : this.getMapList(path)) {
            classMap.convert(mapSection, from, to, converter);
            list.add(classMap);
        }
        this.save(path, list);
    }

    protected final <O, N> void convert(String path, Class<O> from, Class<N> to, Function<O, N> converter) {
        Object old = this.getObject(path);
        if (old != null) {
            if (old instanceof Collection) {
                Collection collection = (Collection)old;
                if (collection.isEmpty() || !from.isAssignableFrom(collection.iterator().next().getClass())) {
                    return;
                }
                ArrayList<N> newCollection = new ArrayList<N>();
                for (Object oldItem : collection) {
                    newCollection.add(converter.apply(oldItem));
                }
                this.save(path, newCollection);
                Common.log("&7Converted '" + path + "' from " + from.getSimpleName() + "[] to " + to.getSimpleName() + "[]");
            } else if (from.isAssignableFrom(old.getClass())) {
                this.save(path, converter.apply(old));
                Common.log("&7Converted '" + path + "' from '" + from.getSimpleName() + "' to '" + to.getSimpleName() + "'");
            }
        }
    }

    protected final <T> T getOrSetDefault(String path, T defaultValue) {
        if (this.isSet(path)) {
            if (defaultValue instanceof Replacer) {
                return (T)Replacer.of(this.getString(path));
            }
            return (T)this.get(path, defaultValue.getClass());
        }
        this.save(path, defaultValue);
        return defaultValue;
    }

    protected final boolean isSet(String path) {
        return this.isSetAbsolute(this.formPathPrefix(path));
    }

    protected final boolean isSetAbsolute(String path) {
        return this.getConfig().isSet(path);
    }

    protected final boolean isSetDefault(String path) {
        return this.isSetDefaultAbsolute(this.formPathPrefix(path));
    }

    protected final boolean isSetDefaultAbsolute(String path) {
        return this.getDefaults() != null && this.getDefaults().isSet(path);
    }

    protected final void addDefaultIfNotExist(String pathAbs) {
        this.addDefaultIfNotExist(pathAbs, Object.class);
    }

    public void addDefaultIfNotExist(String pathAbs, Class<?> type) {
        if (this.usingDefaults && this.getDefaults() != null && !this.isSetAbsolute(pathAbs)) {
            Object object = this.getDefaults().get(pathAbs);
            Valid.checkNotNull(object, "Default '" + this.getFileName() + "' lacks " + Common.article(type.getSimpleName()) + " at '" + pathAbs + "'");
            this.checkAssignable(true, pathAbs, object, type);
            this.checkAndFlagForSave(pathAbs, object);
            this.getConfig().set(pathAbs, object);
        }
    }

    private void forceSingleDefaults(String path) {
        if (this.getDefaults() != null) {
            throw new FoException("Cannot use get method with default when getting " + this.formPathPrefix(path) + " and using a default config for " + this.getFileName());
        }
    }

    private <T> void checkAndFlagForSave(String path, T def) {
        this.checkAndFlagForSave(path, def, true);
    }

    private <T> void checkAndFlagForSave(String path, T def, boolean logUpdate) {
        Valid.checkBoolean(this.instance.getFile() != null && this.instance.getFile().exists() && this.instance.getConfig() != null, "Inbuilt file or config is null! File: " + this.instance.getFile() + ", config: " + this.instance.getConfig(), new Object[0]);
        if (this.getDefaults() != null) {
            Valid.checkNotNull(def, "Inbuilt config " + this.getFileName() + " lacks " + (def == null ? "key" : def.getClass().getSimpleName()) + " at \"" + path + "\". Is it outdated?");
        }
        if (logUpdate) {
            Common.log("&7Update " + this.getFileName() + " at &b'&f" + path + "&b' &7-> " + (def == null ? "&ckey removed" : "&b'&f" + def + "&b'") + "&r");
        }
        this.save = true;
    }

    private void checkAssignable(boolean fromDefault, String path, Object value, Class<?> clazz) {
        if (!clazz.isAssignableFrom(value.getClass()) && !clazz.getSimpleName().equals(value.getClass().getSimpleName())) {
            throw new FoException("Malformed configuration! Key '" + path + "' in " + (fromDefault ? "inbuilt " : "") + this.getFileName() + " must be " + clazz.getSimpleName() + " but got " + value.getClass().getSimpleName() + ": '" + value + "'");
        }
    }

    protected String formPathPrefix(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String prefixed = this.pathPrefix != null ? this.pathPrefix + (!path.isEmpty() ? "." + path : "") : path;
        return prefixed.endsWith(".") ? prefixed.substring(0, prefixed.length() - 1) : prefixed;
    }

    protected void pathPrefix(String pathPrefix) {
        if (pathPrefix != null) {
            Valid.checkBoolean(!pathPrefix.endsWith("."), "Path prefix must not end with a dot: " + pathPrefix, new Object[0]);
            Valid.checkBoolean(!pathPrefix.endsWith(".yml"), "Path prefix must not end with .yml!", new Object[0]);
        }
        this.pathPrefix = pathPrefix != null && !pathPrefix.isEmpty() ? pathPrefix : null;
    }

    protected final String getPathPrefix() {
        return this.pathPrefix;
    }

    @Deprecated
    protected final LinkedHashMap<String, LinkedHashMap<String, Object>> getValuesAndKeys_OLD(String path) {
        Valid.checkNotNull(path, "Path cannot be null");
        path = this.formPathPrefix(path);
        if (this.getDefaults() != null && !this.getConfig().isSet(path)) {
            Valid.checkBoolean(this.getDefaults().isSet(path), "Default '" + this.getFileName() + "' lacks a section at " + path, new Object[0]);
            for (String name : this.getDefaults().getConfigurationSection(path).getKeys(false)) {
                for (String setting : this.getDefaults().getConfigurationSection(path + "." + name).getKeys(false)) {
                    this.addDefaultIfNotExist(path + "." + name + "." + setting, Object.class);
                }
            }
        }
        Valid.checkBoolean(this.getConfig().isSet(path), "Malfunction copying default section to " + path, new Object[0]);
        TreeMap<String, LinkedHashMap<String, Object>> groups = new TreeMap<String, LinkedHashMap<String, Object>>();
        for (String name : this.getConfig().getConfigurationSection(path).getKeys(false)) {
            LinkedHashMap<String, Object> valuesRaw = this.getMap(path + "." + name, String.class, Object.class);
            groups.put(name, valuesRaw);
        }
        return new LinkedHashMap<String, LinkedHashMap<String, Object>>(groups);
    }

    public void setUsingDefaults(boolean usingDefaults) {
        this.usingDefaults = usingDefaults;
    }

    public final class TitleHelper {
        private final String title;
        private final String subtitle;

        private TitleHelper(String path) {
            this(this$0.getString(path + ".Title"), this$0.getString(path + ".Subtitle"));
        }

        private TitleHelper(String title, String subtitle) {
            this.title = Common.colorize(title);
            this.subtitle = Common.colorize(subtitle);
        }

        public void playLong(Player player, Function<String, String> replacer) {
            this.play(player, 5, 80, 15, replacer);
        }

        public void playShort(Player player, Function<String, String> replacer) {
            this.play(player, 3, 40, 5, replacer);
        }

        public void play(Player player, int fadeIn, int stay, int fadeOut, Function<String, String> replacer) {
            Remain.sendTitle(player, fadeIn, stay, fadeOut, replacer.apply(this.title), replacer.apply(this.subtitle));
        }
    }

    public final class CasusHelper {
        private final String akuzativSg;
        private final String akuzativPl;
        private final String genitivPl;

        private CasusHelper(String raw) {
            String[] values = raw.split(", ");
            if (values.length == 2) {
                this.akuzativSg = values[0];
                this.genitivPl = this.akuzativPl = values[1];
                return;
            }
            if (values.length != 3) {
                throw new FoException("Malformed type, use format: 'second, seconds' OR 'sekundu, sekundy, sekund' (if your language has it)");
            }
            this.akuzativSg = values[0];
            this.akuzativPl = values[1];
            this.genitivPl = values[2];
        }

        public String getPlural() {
            return this.genitivPl;
        }

        public String formatWithCount(long count) {
            return count + " " + this.formatWithoutCount(count);
        }

        public String formatWithoutCount(long count) {
            if (count == 1L) {
                return this.akuzativSg;
            }
            if (count > 1L && count < 5L) {
                return this.akuzativPl;
            }
            return this.genitivPl;
        }
    }

    public static final class LocationList
    implements Iterable<Location> {
        private final YamlConfig settings;
        private final List<Location> points;

        private LocationList(YamlConfig settings, List<Location> points) {
            this.settings = settings;
            this.points = points;
        }

        public boolean toggle(Location location) {
            for (Location point : this.points) {
                if (!Valid.locationEquals(point, location)) continue;
                this.points.remove(point);
                this.settings.save();
                return false;
            }
            this.points.add(location);
            this.settings.save();
            return true;
        }

        public void add(Location location) {
            Valid.checkBoolean(!this.hasLocation(location), "Location at " + location + " already exists!", new Object[0]);
            this.points.add(location);
            this.settings.save();
        }

        public void remove(Location location) {
            Location point = this.find(location);
            Valid.checkNotNull(point, "Location at " + location + " does not exist!");
            this.points.remove(point);
            this.settings.save();
        }

        public boolean hasLocation(Location location) {
            return this.find(location) != null;
        }

        public Location find(Location location) {
            for (Location entrance : this.points) {
                if (!Valid.locationEquals(entrance, location)) continue;
                return entrance;
            }
            return null;
        }

        public List<Location> getLocations() {
            return Collections.unmodifiableList(this.points);
        }

        @Override
        public Iterator<Location> iterator() {
            return this.points.iterator();
        }

        public int size() {
            return this.points.size();
        }
    }

    @Deprecated
    public static final class TimeHelper {
    }
}

