/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.settings;

import java.util.List;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.settings.SimpleLocalization;
import org.mineacademy.fo.settings.YamlStaticConfig;

public abstract class SimpleSettings
extends YamlStaticConfig {
    private static boolean settingsClassCalled;
    protected static Integer VERSION;
    public static StrictList<String> DEBUG_SECTIONS;
    public static String PLUGIN_PREFIX;
    public static Integer LAG_THRESHOLD_MILLIS;
    public static Integer REGEX_TIMEOUT;
    public static StrictList<String> MAIN_COMMAND_ALIASES;
    public static String LOCALE_PREFIX;
    public static String SERVER_NAME;
    public static String BUNGEE_SERVER_NAME;
    public static Boolean NOTIFY_UPDATES;

    @Override
    protected final void load() throws Exception {
        this.createFileAndLoad(this.getSettingsFileName());
    }

    protected String getSettingsFileName() {
        return "settings.yml";
    }

    @Override
    protected void preLoad() {
        SimpleSettings.pathPrefix(null);
        VERSION = SimpleSettings.getInteger("Version");
        if (VERSION.intValue() != this.getConfigVersion()) {
            SimpleSettings.set("Version", this.getConfigVersion());
        }
    }

    protected abstract int getConfigVersion();

    private static void init() {
        Valid.checkBoolean(!settingsClassCalled, "Settings class already loaded!", new Object[0]);
        SimpleSettings.pathPrefix(null);
        SimpleSettings.upgradeOldSettings();
        if (SimpleSettings.isSetDefault("Prefix")) {
            PLUGIN_PREFIX = SimpleSettings.getString("Prefix");
        }
        if (SimpleSettings.isSetDefault("Log_Lag_Over_Milis")) {
            LAG_THRESHOLD_MILLIS = SimpleSettings.getInteger("Log_Lag_Over_Milis");
            Valid.checkBoolean(LAG_THRESHOLD_MILLIS == -1 || LAG_THRESHOLD_MILLIS >= 0, "Log_Lag_Over_Milis must be either -1 to disable, 0 to log all or greater!", new Object[0]);
            if (LAG_THRESHOLD_MILLIS == 0) {
                Common.log("&eLog_Lag_Over_Milis is 0, all performance is logged. Set to -1 to disable.");
            }
        }
        if (SimpleSettings.isSetDefault("Debug")) {
            DEBUG_SECTIONS = new StrictList<String>((Iterable<String>)SimpleSettings.getStringList("Debug"));
        }
        if (SimpleSettings.isSetDefault("Regex_Timeout_Milis")) {
            REGEX_TIMEOUT = SimpleSettings.getInteger("Regex_Timeout_Milis");
        }
        if (SimpleSettings.isSetDefault("Server_Name")) {
            SERVER_NAME = Common.colorize(SimpleSettings.getString("Server_Name"));
        }
        boolean keySet = SimpleSettings.isSetDefault("Bungee_Server_Name");
        if (SimplePlugin.getInstance().getBungeeCord() != null && !keySet) {
            throw new FoException("Since you override getBungeeCord in your main plugin class you must set the 'Bungee_Server_Name' key in " + SimpleSettings.getFileName());
        }
        BUNGEE_SERVER_NAME = keySet ? SimpleSettings.getString("Bungee_Server_Name") : BUNGEE_SERVER_NAME;
        boolean hasLocalization = SimpleSettings.hasLocalization();
        boolean keySet2 = SimpleSettings.isSetDefault("Locale");
        if (hasLocalization && !keySet2) {
            throw new FoException("Since you have your Localization class you must set the 'Locale' key in " + SimpleSettings.getFileName());
        }
        LOCALE_PREFIX = keySet2 ? SimpleSettings.getString("Locale") : LOCALE_PREFIX;
        keySet = SimpleSettings.isSetDefault("Command_Aliases");
        if (SimplePlugin.getInstance().getMainCommand() != null && !keySet) {
            throw new FoException("Since you override getMainCommand in your main plugin class you must set the 'Command_Aliases' key in " + SimpleSettings.getFileName());
        }
        MAIN_COMMAND_ALIASES = keySet ? SimpleSettings.getCommandList("Command_Aliases") : MAIN_COMMAND_ALIASES;
        keySet = SimpleSettings.isSetDefault("Notify_Updates");
        NOTIFY_UPDATES = keySet ? SimpleSettings.getBoolean("Notify_Updates") : NOTIFY_UPDATES;
        settingsClassCalled = true;
    }

    private static boolean hasLocalization() {
        SimplePlugin plugin = SimplePlugin.getInstance();
        int localeClasses = 0;
        if (plugin.getSettings() != null) {
            for (Class<? extends YamlStaticConfig> clazz : plugin.getSettings()) {
                if (!SimpleLocalization.class.isAssignableFrom(clazz)) continue;
                ++localeClasses;
            }
        }
        Valid.checkBoolean(localeClasses < 2, "You cannot have more than 1 class extend SimpleLocalization!", new Object[0]);
        return localeClasses == 1;
    }

    private static void upgradeOldSettings() {
        if (SimpleSettings.isSetAbsolute("Debugger")) {
            SimpleSettings.move("Debugger", "Debug");
        }
        if (SimpleSettings.isSetAbsolute("Serialization_Number")) {
            SimpleSettings.move("Serialization_Number", "Serialization");
        }
        if (SimpleSettings.isSetAbsolute("Debugger.Keys")) {
            SimpleSettings.move("Debugger.Keys", "Serialization");
            SimpleSettings.move("Debugger.Sections", "Debug");
        }
        if (SimpleSettings.isSetAbsolute("Debug") && !(SimpleSettings.getObject("Debug") instanceof List)) {
            SimpleSettings.set("Debug", null);
        }
        if (SimpleSettings.isSetAbsolute("Plugin_Prefix")) {
            SimpleSettings.move("Plugin_Prefix", "Prefix");
        }
        if (SimpleSettings.isSetAbsolute("Check_Updates")) {
            SimpleSettings.move("Check_Updates", "Notify_Updates");
        }
    }

    public static final Boolean isSettingsCalled() {
        return settingsClassCalled;
    }

    public static final void resetSettingsCall() {
        settingsClassCalled = false;
    }

    static {
        DEBUG_SECTIONS = new StrictList();
        PLUGIN_PREFIX = "&7" + SimplePlugin.getNamed() + " //";
        LAG_THRESHOLD_MILLIS = 100;
        REGEX_TIMEOUT = 100;
        MAIN_COMMAND_ALIASES = new StrictList();
        LOCALE_PREFIX = "en";
        SERVER_NAME = "Server";
        BUNGEE_SERVER_NAME = "Server";
        NOTIFY_UPDATES = true;
    }
}

