/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.settings;

import org.mineacademy.fo.Valid;
import org.mineacademy.fo.settings.SimpleSettings;
import org.mineacademy.fo.settings.YamlStaticConfig;

public abstract class SimpleLocalization
extends YamlStaticConfig {
    private static boolean localizationClassCalled;
    protected static Integer VERSION;
    public static String NO_PERMISSION;
    public static String SERVER_PREFIX;
    public static String CONSOLE_NAME;
    public static String DATA_MISSING;
    public static String CONVERSATION_REQUIRES_PLAYER;

    @Override
    protected final void load() throws Exception {
        this.createLocalizationFile(SimpleSettings.LOCALE_PREFIX);
    }

    @Override
    protected void preLoad() {
        SimpleLocalization.pathPrefix(null);
        VERSION = SimpleLocalization.getInteger("Version");
        if (VERSION.intValue() != this.getConfigVersion()) {
            SimpleLocalization.set("Version", this.getConfigVersion());
        }
    }

    protected abstract int getConfigVersion();

    private static void init() {
        SimpleLocalization.pathPrefix(null);
        Valid.checkBoolean(!localizationClassCalled, "Localization class already loaded!", new Object[0]);
        if (SimpleLocalization.isSetDefault("No_Permission")) {
            NO_PERMISSION = SimpleLocalization.getString("No_Permission");
        }
        if (SimpleLocalization.isSetDefault("Server_Prefix")) {
            SERVER_PREFIX = SimpleLocalization.getString("Server_Prefix");
        }
        if (SimpleLocalization.isSetDefault("Console_Name")) {
            CONSOLE_NAME = SimpleLocalization.getString("Console_Name");
        }
        if (SimpleLocalization.isSetDefault("Data_Missing")) {
            DATA_MISSING = SimpleLocalization.getString("Data_Missing");
        }
        if (SimpleLocalization.isSetDefault("Conversation_Requires_Player")) {
            CONVERSATION_REQUIRES_PLAYER = SimpleLocalization.getString("Conversation_Requires_Player");
        }
        localizationClassCalled = true;
    }

    public static final Boolean isLocalizationCalled() {
        return localizationClassCalled;
    }

    public static final void resetLocalizationCall() {
        localizationClassCalled = false;
    }

    static {
        NO_PERMISSION = "&cInsufficient permission ({permission}).";
        SERVER_PREFIX = "[Server]";
        CONSOLE_NAME = "Console";
        DATA_MISSING = "&c{name} lacks database information! Please only create {type} in-game! Skipping..";
        CONVERSATION_REQUIRES_PLAYER = "Only players may enter this conversation.";
    }

    public static class Update {
        public static String AVAILABLE = "&2A new version of &3{plugin_name}&2 is available.\n&2Current version: &f{current}&2; New version: &f{new}\n&2URL: &7https://spigotmc.org/resources/{resource_id}/.";
        public static String DOWNLOADED = "&3{plugin_name}&2 has been upgraded from {current} to {new}.\n&2Visit &7https://spigotmc.org/resources/{resource_id} &2for more information.\n&2Please restart the server to load the new version.";

        private static void init() {
            YamlStaticConfig.pathPrefix(null);
            if (YamlStaticConfig.isSetAbsolute("Update_Available")) {
                YamlStaticConfig.move("Update_Available", "Update.Available");
            }
            YamlStaticConfig.pathPrefix("Update");
            if (YamlStaticConfig.isSetDefault("Available")) {
                AVAILABLE = YamlStaticConfig.getString("Available");
            }
            if (YamlStaticConfig.isSetDefault("Downloaded")) {
                DOWNLOADED = YamlStaticConfig.getString("Downloaded");
            }
        }
    }

    public static class Menu {
        public static String ITEM_DELETED = "&2The {item} has been deleted.";

        private static void init() {
            YamlStaticConfig.pathPrefix("Menu");
            if (YamlStaticConfig.isSetDefault("Item_Deleted")) {
                ITEM_DELETED = YamlStaticConfig.getString("Item_Deleted");
            }
        }
    }

    public static class Player {
        public static String NOT_ONLINE = "&cPlayer {player} &cis not online on this server.";

        private static void init() {
            YamlStaticConfig.pathPrefix("Player");
            if (YamlStaticConfig.isSetDefault("Not_Online")) {
                NOT_ONLINE = YamlStaticConfig.getString("Not_Online");
            }
        }
    }

    public static class Commands {
        public static String NO_CONSOLE = "&cYou may only use this command as a player";
        public static String COOLDOWN_WAIT = "&cWait {duration} second(s) before using this command again.";
        public static String INVALID_ARGUMENT = "&cInvalid argument. Run &6/{label} ? &cfor help.";
        public static String INVALID_SUB_ARGUMENT = "&cInvalid argument. Run '/{label} {0}' for help.";
        public static String INVALID_ARGUMENT_MULTILINE = "&cInvalid argument. Usage:";
        public static String LABEL_AUTHORS = "Made by";
        public static String LABEL_DESCRIPTION = "&cDescription: {description}";
        public static String LABEL_OPTIONAL_ARGS = "optional arguments";
        public static String LABEL_REQUIRED_ARGS = "required arguments";
        public static String LABEL_USAGES = "&cUsages:";
        public static String LABEL_USAGE = "&cUsage:";
        public static String RELOAD_SUCCESS = "&6{plugin_name} {plugin_version} has been reloaded.";
        public static String RELOAD_FAIL = "&4Oups, &creloading failed! See the console for more information. Error: {error}";
        public static String ERROR = "&4&lOups! &cThe command failed :( Check the console and report the error.";
        public static String HEADER_NO_SUBCOMMANDS = "&cYou don't have permissions to view any subcommands.";
        public static String RELOADING = "reloading";
        public static String DISABLED = "disabled";
        public static String USE_WHILE_NULL = "&cCannot use this command while the plugin is {state}.";

        private static void init() {
            YamlStaticConfig.pathPrefix("Commands");
            if (YamlStaticConfig.isSetDefault("No_Console")) {
                NO_CONSOLE = YamlStaticConfig.getString("No_Console");
            }
            if (YamlStaticConfig.isSetDefault("Cooldown_Wait")) {
                COOLDOWN_WAIT = YamlStaticConfig.getString("Cooldown_Wait");
            }
            if (YamlStaticConfig.isSetDefault("Invalid_Argument")) {
                INVALID_ARGUMENT = YamlStaticConfig.getString("Invalid_Argument");
            }
            if (YamlStaticConfig.isSetDefault("Invalid_Sub_Argument")) {
                INVALID_SUB_ARGUMENT = YamlStaticConfig.getString("Invalid_Sub_Argument");
            }
            if (YamlStaticConfig.isSetDefault("Invalid_Argument_Multiline")) {
                INVALID_ARGUMENT_MULTILINE = YamlStaticConfig.getString("Invalid_Argument_Multiline");
            }
            if (YamlStaticConfig.isSetDefault("Label_Authors")) {
                LABEL_AUTHORS = YamlStaticConfig.getString("Label_Authors");
            }
            if (YamlStaticConfig.isSetDefault("Label_Description")) {
                LABEL_DESCRIPTION = YamlStaticConfig.getString("Label_Description");
            }
            if (YamlStaticConfig.isSetDefault("Label_Optional_Args")) {
                LABEL_OPTIONAL_ARGS = YamlStaticConfig.getString("Label_Optional_Args");
            }
            if (YamlStaticConfig.isSetDefault("Label_Required_Args")) {
                LABEL_REQUIRED_ARGS = YamlStaticConfig.getString("Label_Required_Args");
            }
            if (YamlStaticConfig.isSetDefault("Label_Usage")) {
                LABEL_USAGE = YamlStaticConfig.getString("Label_Usage");
            }
            if (YamlStaticConfig.isSetDefault("Label_Usages")) {
                LABEL_USAGES = YamlStaticConfig.getString("Label_Usages");
            }
            if (YamlStaticConfig.isSetDefault("Reload_Success")) {
                RELOAD_SUCCESS = YamlStaticConfig.getString("Reload_Success");
            }
            if (YamlStaticConfig.isSetDefault("Reload_Fail")) {
                RELOAD_FAIL = YamlStaticConfig.getString("Reload_Fail");
            }
            if (YamlStaticConfig.isSetDefault("Error")) {
                ERROR = YamlStaticConfig.getString("Error");
            }
            if (YamlStaticConfig.isSetDefault("Header_No_Subcommands")) {
                HEADER_NO_SUBCOMMANDS = YamlStaticConfig.getString("Header_No_Subcommands");
            }
            if (YamlStaticConfig.isSet("Reloading")) {
                RELOADING = YamlStaticConfig.getString("Reloading");
            }
            if (YamlStaticConfig.isSet("Disabled")) {
                DISABLED = YamlStaticConfig.getString("Disabled");
            }
            if (YamlStaticConfig.isSet("Use_While_Null")) {
                USE_WHILE_NULL = YamlStaticConfig.getString("Use_While_Null");
            }
        }
    }
}

