/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.settings;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.settings.YamlConfig;

class ConfigInstance {
    private final File file;
    private final YamlConfiguration config;
    private final YamlConfiguration defaultConfig;

    protected void save(String[] header) {
        if (header != null) {
            this.config.options().copyHeader(true);
            this.config.options().header(String.join((CharSequence)"\n", header));
        }
        try {
            this.config.save(this.file);
        }
        catch (NullPointerException ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("Nodes must be provided")) {
                Map dump = this.config.getValues(true);
                FileUtil.write("error_yaml.log", Common.configLine(), "Got null nodes error when saving " + this.file, "Please report this to plugin developers!", Common.configLine(), "Raw dump:", dump.toString());
                FileUtil.write("error_yaml.log", "", "Serialized: ", SerializeUtil.serialize(dump).toString());
                Common.error(ex, "Failed to save " + this.file + ", please see error_yaml.log in your plugin folder and report this to plugin developers!");
            }
            throw ex;
        }
        catch (IOException e) {
            Common.error(e, "Failed to save " + this.file.getName());
        }
    }

    protected void reload() throws Exception {
        this.config.load(this.file);
    }

    protected void delete() {
        YamlConfig.unregisterLoadedFile(this.file);
        this.file.delete();
    }

    public boolean equals(File file) {
        return this.equals((Object)file);
    }

    public boolean equals(String fileName) {
        return this.equals((Object)fileName);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigInstance ? ((ConfigInstance)obj).file.getName().equals(this.file.getName()) : (obj instanceof File ? ((File)obj).getName().equals(this.file.getName()) : (obj instanceof String ? ((String)obj).equals(this.file.getName()) : false));
    }

    protected File getFile() {
        return this.file;
    }

    protected YamlConfiguration getConfig() {
        return this.config;
    }

    protected YamlConfiguration getDefaultConfig() {
        return this.defaultConfig;
    }

    public ConfigInstance(File file, YamlConfiguration config, YamlConfiguration defaultConfig) {
        this.file = file;
        this.config = config;
        this.defaultConfig = defaultConfig;
    }
}

