/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Set;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.meta.ItemMeta;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTCompoundList;
import org.mineacademy.fo.remain.nbt.NBTContainer;
import org.mineacademy.fo.remain.nbt.NBTDoubleList;
import org.mineacademy.fo.remain.nbt.NBTFloatList;
import org.mineacademy.fo.remain.nbt.NBTIntegerList;
import org.mineacademy.fo.remain.nbt.NBTList;
import org.mineacademy.fo.remain.nbt.NBTListCompound;
import org.mineacademy.fo.remain.nbt.NBTLongList;
import org.mineacademy.fo.remain.nbt.NBTStringList;
import org.mineacademy.fo.remain.nbt.NBTType;
import org.mineacademy.fo.remain.nbt.NbtApiException;
import org.mineacademy.fo.remain.nbt.WrapperClass;
import org.mineacademy.fo.remain.nbt.WrapperObject;
import org.mineacademy.fo.remain.nbt.WrapperReflection;
import org.mineacademy.fo.remain.nbt.WrapperVersion;

public class NBTReflectionUtil {
    private static final Gson gson;
    private static Field field_unhandledTags;

    private NBTReflectionUtil() {
    }

    static Object getNMSEntity(Entity entity) {
        try {
            return WrapperReflection.CRAFT_ENTITY_GET_HANDLE.run(WrapperClass.CRAFT_ENTITY.getClazz().cast(entity), new Object[0]);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting the NMS Entity from a Bukkit Entity!", e);
        }
    }

    static Object readNBT(InputStream stream) {
        try {
            return WrapperReflection.NBTFILE_READ.run(null, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while reading a NBT File!", e);
        }
    }

    static Object writeNBT(Object nbt, OutputStream stream) {
        try {
            return WrapperReflection.NBTFILE_WRITE.run(null, nbt, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while writing NBT!", e);
        }
    }

    static void writeApiNBT(NBTCompound comp, OutputStream stream) {
        try {
            Object nbttag = comp.getCompound();
            if (nbttag == null) {
                nbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            }
            if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
                return;
            }
            Object workingtag = NBTReflectionUtil.gettoCompount(nbttag, comp);
            WrapperReflection.NBTFILE_WRITE.run(null, workingtag, stream);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while writing NBT!", e);
        }
    }

    static Object getItemRootNBTTagCompound(Object nmsitem) {
        try {
            if (nmsitem == null) {
                return WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            }
            Object answer = WrapperReflection.NMSITEM_GETTAG.run(nmsitem, new Object[0]);
            return answer != null ? answer : WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting an Itemstack's NBTCompound!", e);
        }
    }

    static Object convertNBTCompoundtoNMSItem(NBTCompound nbtcompound) {
        try {
            Object nmsComp = NBTReflectionUtil.gettoCompount(nbtcompound.getCompound(), nbtcompound);
            if (WrapperVersion.getVersion().getVersionId() >= WrapperVersion.MC1_11_R1.getVersionId()) {
                return WrapperObject.NMS_COMPOUNDFROMITEM.getInstance(nmsComp);
            }
            return WrapperReflection.NMSITEM_CREATESTACK.run(null, nmsComp);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while converting NBTCompound to NMS ItemStack!", e);
        }
    }

    static NBTContainer convertNMSItemtoNBTCompound(Object nmsitem) {
        try {
            Object answer = WrapperReflection.NMSITEM_SAVE.run(nmsitem, WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]));
            return new NBTContainer(answer);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while converting NMS ItemStack to NBTCompound!", e);
        }
    }

    static Map<String, Object> getUnhandledNBTTags(ItemMeta meta) {
        try {
            return (Map)field_unhandledTags.get(meta);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting unhandled tags from ItemMeta!", e);
        }
    }

    static Object getEntityNBTTagCompound(Object nmsEntity) {
        try {
            Object nbt = WrapperClass.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object answer = WrapperReflection.NMS_ENTITY_GET_NBT.run(nmsEntity, nbt);
            if (answer == null) {
                answer = nbt;
            }
            return answer;
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBTCompound from NMS Entity!", e);
        }
    }

    static Object setEntityNBTTag(Object nbtTag, Object nmsEntity) {
        try {
            WrapperReflection.NMS_ENTITY_SET_NBT.run(nmsEntity, nbtTag);
            return nmsEntity;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while setting the NBTCompound of an Entity", ex);
        }
    }

    static Object getTileEntityNBTTagCompound(BlockState tile) {
        try {
            Object pos = WrapperObject.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
            Object cworld = WrapperClass.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = WrapperReflection.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o = WrapperReflection.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            Object tag = WrapperClass.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object answer = WrapperReflection.TILEENTITY_GET_NBT.run(o, tag);
            if (answer == null) {
                answer = tag;
            }
            return answer;
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBTCompound from TileEntity!", e);
        }
    }

    static void setTileEntityNBTTagCompound(BlockState tile, Object comp) {
        try {
            Object pos = WrapperObject.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
            Object cworld = WrapperClass.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = WrapperReflection.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o = WrapperReflection.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            if (WrapperVersion.getVersion().getVersionId() >= WrapperVersion.MC1_16_R1.getVersionId()) {
                Object blockData = WrapperReflection.TILEENTITY_GET_BLOCKDATA.run(o, new Object[0]);
                WrapperReflection.TILEENTITY_SET_NBT.run(o, blockData, comp);
            } else {
                WrapperReflection.TILEENTITY_SET_NBT_LEGACY1151.run(o, comp);
            }
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting NBTData for a TileEntity!", e);
        }
    }

    private static Object getSubNBTTagCompound(Object compound, String name) {
        try {
            if (((Boolean)WrapperReflection.COMPOUND_HAS_KEY.run(compound, name)).booleanValue()) {
                return WrapperReflection.COMPOUND_GET_COMPOUND.run(compound, name);
            }
            throw new NbtApiException("Tried getting invalide compound '" + name + "' from '" + compound + "'!");
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting NBT subcompounds!", e);
        }
    }

    static void addNBTTagCompound(NBTCompound comp, String name) {
        if (name == null) {
            NBTReflectionUtil.remove(comp, name);
            return;
        }
        Object nbttag = comp.getCompound();
        if (nbttag == null) {
            nbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(nbttag, comp);
        try {
            WrapperReflection.COMPOUND_SET.run(workingtag, name, WrapperClass.NMS_NBTTAGCOMPOUND.getClazz().newInstance());
            comp.setCompound(nbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while adding a Compound!", e);
        }
    }

    static Boolean valideCompound(NBTCompound comp) {
        Object root = comp.getCompound();
        if (root == null) {
            root = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        return NBTReflectionUtil.gettoCompount(root, comp) != null;
    }

    static Object gettoCompount(Object nbttag, NBTCompound comp) {
        ArrayDeque<String> structure = new ArrayDeque<String>();
        while (comp.getParent() != null) {
            structure.add(comp.getName());
            comp = comp.getParent();
        }
        while (!structure.isEmpty()) {
            String target = (String)structure.pollLast();
            if ((nbttag = NBTReflectionUtil.getSubNBTTagCompound(nbttag, target)) != null) continue;
            throw new NbtApiException("Unable to find tag '" + target + "' in " + nbttag);
        }
        return nbttag;
    }

    static void mergeOtherNBTCompound(NBTCompound comp, NBTCompound nbtcompoundSrc) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        Object rootnbttagSrc = nbtcompoundSrc.getCompound();
        if (rootnbttagSrc == null) {
            rootnbttagSrc = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(nbtcompoundSrc).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtagSrc = NBTReflectionUtil.gettoCompount(rootnbttagSrc, nbtcompoundSrc);
        try {
            WrapperReflection.COMPOUND_MERGE.run(workingtag, workingtagSrc);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while merging two NBTCompounds!", e);
        }
    }

    static String getContent(NBTCompound comp, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            return WrapperReflection.COMPOUND_GET.run(workingtag, key).toString();
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while getting the Content for key '" + key + "'!", e);
        }
    }

    public static void set(NBTCompound comp, String key, Object val) {
        if (val == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            WrapperReflection.COMPOUND_SET.run(workingtag, key, val);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting key '" + key + "' to '" + val + "'!", e);
        }
    }

    public static <T> NBTList<T> getList(NBTCompound comp, String key, NBTType type, Class<T> clazz) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return null;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        try {
            Object nbt = WrapperReflection.COMPOUND_GET_LIST.run(workingtag, key, type.getId());
            if (clazz == String.class) {
                return new NBTStringList(comp, key, type, nbt);
            }
            if (clazz == NBTListCompound.class) {
                return new NBTCompoundList(comp, key, type, nbt);
            }
            if (clazz == Integer.class) {
                return new NBTIntegerList(comp, key, type, nbt);
            }
            if (clazz == Float.class) {
                return new NBTFloatList(comp, key, type, nbt);
            }
            if (clazz == Double.class) {
                return new NBTDoubleList(comp, key, type, nbt);
            }
            if (clazz == Long.class) {
                return new NBTLongList(comp, key, type, nbt);
            }
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while getting a list with the type '" + (Object)((Object)type) + "'!", ex);
        }
    }

    static void setObject(NBTCompound comp, String key, Object value) {
        if (!WrapperVersion.hasGsonSupport()) {
            return;
        }
        try {
            String json = gson.toJson(value);
            NBTReflectionUtil.setData(comp, WrapperReflection.COMPOUND_SET_STRING, key, json);
        }
        catch (Exception e) {
            throw new NbtApiException("Exception while setting the Object '" + value + "'!", e);
        }
    }

    public static <T> T getObject(NBTCompound comp, String key, Class<T> type) {
        if (!WrapperVersion.hasGsonSupport()) {
            return null;
        }
        String json = (String)NBTReflectionUtil.getData(comp, WrapperReflection.COMPOUND_GET_STRING, key);
        if (json == null) {
            return null;
        }
        Object obj = gson.fromJson(json, type);
        return type.cast(obj);
    }

    public static void remove(NBTCompound comp, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            return;
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        WrapperReflection.COMPOUND_REMOVE_KEY.run(workingtag, key);
        comp.setCompound(rootnbttag);
    }

    static Set<String> getKeys(NBTCompound comp) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        return (Set)WrapperReflection.COMPOUND_GET_KEYS.run(workingtag, new Object[0]);
    }

    static void setData(NBTCompound comp, WrapperReflection type, String key, Object data) {
        if (data == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = WrapperObject.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        type.run(workingtag, key, data);
        comp.setCompound(rootnbttag);
    }

    public static Object getData(NBTCompound comp, WrapperReflection type, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            return null;
        }
        if (!NBTReflectionUtil.valideCompound(comp).booleanValue()) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.gettoCompount(rootnbttag, comp);
        return type.run(workingtag, key);
    }

    static {
        block2: {
            gson = new Gson();
            try {
                field_unhandledTags = WrapperClass.CRAFT_METAITEM.getClazz().getDeclaredField("unhandledTags");
                field_unhandledTags.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (!MinecraftVersion.atLeast(MinecraftVersion.V.v1_8)) break block2;
                e.printStackTrace();
            }
        }
    }
}

