/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTContainer;
import org.mineacademy.fo.remain.nbt.NBTReflectionUtil;
import org.mineacademy.fo.remain.nbt.WrapperReflection;

public class NBTItem
extends NBTCompound {
    private ItemStack bukkitItem;

    public NBTItem(ItemStack item) {
        super(null, null);
        if (item == null) {
            throw new NullPointerException("ItemStack can't be null!");
        }
        this.bukkitItem = item.clone();
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getItemRootNBTTagCompound(WrapperReflection.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
    }

    @Override
    protected void setCompound(Object compound) {
        Object stack = WrapperReflection.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
        WrapperReflection.ITEMSTACK_SET_TAG.run(stack, compound);
        this.bukkitItem = (ItemStack)WrapperReflection.ITEMSTACK_BUKKITMIRROR.run(null, stack);
    }

    public void applyNBT(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air!");
        }
        NBTItem nbti = new NBTItem(new ItemStack(item.getType()));
        nbti.mergeCompound(this);
        item.setItemMeta(nbti.getItem().getItemMeta());
    }

    public void clearCustomNBT() {
        ItemMeta meta = this.bukkitItem.getItemMeta();
        NBTReflectionUtil.getUnhandledNBTTags(meta).clear();
        this.bukkitItem.setItemMeta(meta);
    }

    public ItemStack getItem() {
        return this.bukkitItem;
    }

    protected void setItem(ItemStack item) {
        this.bukkitItem = item;
    }

    public boolean hasNBTData() {
        return this.getCompound() != null;
    }

    static NBTContainer convertItemtoNBT(ItemStack item) {
        return NBTReflectionUtil.convertNMSItemtoNBTCompound(WrapperReflection.ITEMSTACK_NMSCOPY.run(null, item));
    }

    static ItemStack convertNBTtoItem(NBTCompound comp) {
        return (ItemStack)WrapperReflection.ITEMSTACK_BUKKITMIRROR.run(null, NBTReflectionUtil.convertNBTCompoundtoNMSItem(comp));
    }
}

