/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTList;
import org.mineacademy.fo.remain.nbt.NBTType;
import org.mineacademy.fo.remain.nbt.NbtApiException;
import org.mineacademy.fo.remain.nbt.WrapperClass;
import org.mineacademy.fo.remain.nbt.WrapperReflection;

public class NBTIntegerList
extends NBTList<Integer> {
    NBTIntegerList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(Integer object) {
        try {
            Constructor<?> con = WrapperClass.NMS_NBTTAGINT.getClazz().getDeclaredConstructor(Integer.TYPE);
            con.setAccessible(true);
            return con.newInstance(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public Integer get(int index) {
        try {
            Object obj = WrapperReflection.LIST_GET.run(this.listObject, index);
            return Integer.valueOf(obj.toString());
        }
        catch (NumberFormatException nf) {
            return 0;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

