/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTList;
import org.mineacademy.fo.remain.nbt.NBTType;
import org.mineacademy.fo.remain.nbt.NbtApiException;
import org.mineacademy.fo.remain.nbt.WrapperClass;
import org.mineacademy.fo.remain.nbt.WrapperReflection;

public class NBTFloatList
extends NBTList<Float> {
    NBTFloatList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(Float object) {
        try {
            Constructor<?> con = WrapperClass.NMS_NBTTAGFLOAT.getClazz().getDeclaredConstructor(Float.TYPE);
            con.setAccessible(true);
            return con.newInstance(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public Float get(int index) {
        try {
            Object obj = WrapperReflection.LIST_GET.run(this.listObject, index);
            return Float.valueOf(obj.toString());
        }
        catch (NumberFormatException nf) {
            return Float.valueOf(0.0f);
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

