/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import org.apache.commons.lang.NotImplementedException;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTList;
import org.mineacademy.fo.remain.nbt.NBTListCompound;
import org.mineacademy.fo.remain.nbt.NBTType;
import org.mineacademy.fo.remain.nbt.NbtApiException;
import org.mineacademy.fo.remain.nbt.WrapperClass;
import org.mineacademy.fo.remain.nbt.WrapperReflection;
import org.mineacademy.fo.remain.nbt.WrapperVersion;

public class NBTCompoundList
extends NBTList<NBTListCompound> {
    NBTCompoundList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    public NBTListCompound addCompound() {
        return (NBTListCompound)this.addCompound(null);
    }

    private NBTCompound addCompound(NBTCompound comp) {
        try {
            Object compound = WrapperClass.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (WrapperVersion.getVersion().getVersionId() >= WrapperVersion.MC1_14_R1.getVersionId()) {
                WrapperReflection.LIST_ADD.run(this.listObject, this.size(), compound);
            } else {
                WrapperReflection.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            this.getParent().saveCompound();
            NBTListCompound listcomp = new NBTListCompound(this, compound);
            if (comp != null) {
                listcomp.mergeCompound(comp);
            }
            return listcomp;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    @Deprecated
    public boolean add(NBTListCompound empty) {
        return this.addCompound(empty) != null;
    }

    @Override
    public void add(int index, NBTListCompound element) {
        if (element != null) {
            throw new NotImplementedException("You need to pass null! ListCompounds from other lists won't work.");
        }
        try {
            Object compound = WrapperClass.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            if (WrapperVersion.getVersion().getVersionId() >= WrapperVersion.MC1_14_R1.getVersionId()) {
                WrapperReflection.LIST_ADD.run(this.listObject, index, compound);
            } else {
                WrapperReflection.LEGACY_LIST_ADD.run(this.listObject, compound);
            }
            super.getParent().saveCompound();
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public NBTListCompound get(int index) {
        try {
            Object compound = WrapperReflection.LIST_GET_COMPOUND.run(this.listObject, index);
            return new NBTListCompound(this, compound);
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    public NBTListCompound set(int index, NBTListCompound element) {
        throw new NotImplementedException("This method doesn't work in the ListCompound context.");
    }

    @Override
    protected Object asTag(NBTListCompound object) {
        return null;
    }
}

