/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.nbt;

import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.remain.nbt.NBTCompoundList;
import org.mineacademy.fo.remain.nbt.NBTItem;
import org.mineacademy.fo.remain.nbt.NBTList;
import org.mineacademy.fo.remain.nbt.NBTListCompound;
import org.mineacademy.fo.remain.nbt.NBTReflectionUtil;
import org.mineacademy.fo.remain.nbt.NBTType;
import org.mineacademy.fo.remain.nbt.NbtApiException;
import org.mineacademy.fo.remain.nbt.WrapperReflection;
import org.mineacademy.fo.remain.nbt.WrapperVersion;

public class NBTCompound {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final String compundName;
    private final NBTCompound parent;

    protected NBTCompound(NBTCompound owner, String name) {
        this.compundName = name;
        this.parent = owner;
    }

    Lock getReadLock() {
        return this.readLock;
    }

    Lock getWriteLock() {
        return this.writeLock;
    }

    protected void saveCompound() {
        if (this.parent != null) {
            this.parent.saveCompound();
        }
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object compound) {
        this.parent.setCompound(compound);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    void mergeCompound(NBTCompound comp) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.mergeOtherNBTCompound(this, comp);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setString(String key, String value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_STRING, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getString(String key) {
        try {
            this.readLock.lock();
            String string = (String)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_STRING, key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected String getContent(String key) {
        return NBTReflectionUtil.getContent(this, key);
    }

    public void setInteger(String key, Integer value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_INT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Integer getInteger(String key) {
        try {
            this.readLock.lock();
            Integer n = (Integer)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_INT, key);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDouble(String key, Double value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_DOUBLE, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Double getDouble(String key) {
        try {
            this.readLock.lock();
            Double d = (Double)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_DOUBLE, key);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setByte(String key, Byte value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_BYTE, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Byte getByte(String key) {
        try {
            this.readLock.lock();
            Byte by = (Byte)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_BYTE, key);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setShort(String key, Short value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_SHORT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Short getShort(String key) {
        try {
            this.readLock.lock();
            Short s = (Short)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_SHORT, key);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setLong(String key, Long value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_LONG, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Long getLong(String key) {
        try {
            this.readLock.lock();
            Long l = (Long)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_LONG, key);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setFloat(String key, Float value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_FLOAT, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Float getFloat(String key) {
        try {
            this.readLock.lock();
            Float f = (Float)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_FLOAT, key);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setByteArray(String key, byte[] value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_BYTEARRAY, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public byte[] getByteArray(String key) {
        try {
            this.readLock.lock();
            byte[] byArray = (byte[])NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_BYTEARRAY, key);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setIntArray(String key, int[] value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_INTARRAY, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int[] getIntArray(String key) {
        try {
            this.readLock.lock();
            int[] nArray = (int[])NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_INTARRAY, key);
            return nArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setBoolean(String key, Boolean value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_BOOLEAN, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void set(String key, Object val) {
        NBTReflectionUtil.set(this, key, val);
        this.saveCompound();
    }

    public Boolean getBoolean(String key) {
        try {
            this.readLock.lock();
            Boolean bl = (Boolean)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_BOOLEAN, key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setObject(String key, Object value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setObject(this, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObject(String key, Class<T> type) {
        try {
            this.readLock.lock();
            T t = NBTReflectionUtil.getObject(this, key, type);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setItemStack(String key, ItemStack item) {
        try {
            this.writeLock.lock();
            this.removeKey(key);
            this.addCompound(key).mergeCompound(NBTItem.convertItemtoNBT(item));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getItemStack(String key) {
        try {
            this.readLock.lock();
            NBTCompound comp = this.getCompound(key);
            ItemStack itemStack = NBTItem.convertNBTtoItem(comp);
            return itemStack;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setUUID(String key, UUID value) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, WrapperReflection.COMPOUND_SET_UUID, key, value);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public UUID getUUID(String key) {
        try {
            this.readLock.lock();
            UUID uUID = (UUID)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_UUID, key);
            return uUID;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasKey(String key) {
        try {
            this.readLock.lock();
            Boolean b = (Boolean)NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_HAS_KEY, key);
            if (b == null) {
                Boolean bl = false;
                return bl;
            }
            Boolean bl = b;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeKey(String key) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.remove(this, key);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getKeys() {
        try {
            this.readLock.lock();
            Set<String> set = NBTReflectionUtil.getKeys(this);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompound addCompound(String name) {
        try {
            this.writeLock.lock();
            if (this.getType(name) == NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = this.getCompound(name);
                return nBTCompound;
            }
            NBTReflectionUtil.addNBTTagCompound(this, name);
            NBTCompound comp = this.getCompound(name);
            if (comp == null) {
                throw new NbtApiException("Error while adding Compound, got null!");
            }
            this.saveCompound();
            NBTCompound nBTCompound = comp;
            return nBTCompound;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompound getCompound(String name) {
        try {
            this.readLock.lock();
            if (this.getType(name) != NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = null;
                return nBTCompound;
            }
            NBTCompound next = new NBTCompound(this, name);
            if (NBTReflectionUtil.valideCompound(next).booleanValue()) {
                NBTCompound nBTCompound = next;
                return nBTCompound;
            }
            NBTCompound nBTCompound = null;
            return nBTCompound;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<String> getStringList(String name) {
        try {
            this.writeLock.lock();
            NBTList<String> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagString, String.class);
            this.saveCompound();
            NBTList<String> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Integer> getIntegerList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Integer> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagInt, Integer.class);
            this.saveCompound();
            NBTList<Integer> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Float> getFloatList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Float> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagFloat, Float.class);
            this.saveCompound();
            NBTList<Float> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Double> getDoubleList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Double> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagDouble, Double.class);
            this.saveCompound();
            NBTList<Double> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Long> getLongList(String name) {
        try {
            this.writeLock.lock();
            NBTList<Long> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagLong, Long.class);
            this.saveCompound();
            NBTList<Long> nBTList = list;
            return nBTList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompoundList getCompoundList(String name) {
        try {
            this.writeLock.lock();
            NBTCompoundList list = (NBTCompoundList)NBTReflectionUtil.getList(this, name, NBTType.NBTTagCompound, NBTListCompound.class);
            this.saveCompound();
            NBTCompoundList nBTCompoundList = list;
            return nBTCompoundList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTType getType(String name) {
        try {
            this.readLock.lock();
            if (WrapperVersion.getVersion() == WrapperVersion.MC1_7_R4) {
                NBTType nBTType = null;
                return nBTType;
            }
            Object o = NBTReflectionUtil.getData(this, WrapperReflection.COMPOUND_GET_TYPE, name);
            if (o == null) {
                NBTType nBTType = null;
                return nBTType;
            }
            NBTType nBTType = NBTType.valueOf(((Byte)o).byteValue());
            return nBTType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void writeCompound(OutputStream stream) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.writeApiNBT(this, stream);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.asNBTString();
    }

    @Deprecated
    public String toString(String key) {
        return this.asNBTString();
    }

    @Deprecated
    public String asNBTString() {
        try {
            this.readLock.lock();
            Object comp = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
            if (comp == null) {
                String string = "{}";
                return string;
            }
            String string = comp.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

