/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.remain.Remain;

@Deprecated
public class ChatInternals {
    private static Object enumTitle;
    private static Object enumSubtitle;
    private static Object enumReset;
    private static Constructor<?> tabConstructor;
    private static Constructor<?> titleTimesConstructor;
    private static Constructor<?> titleConstructor;
    private static Constructor<?> subtitleConstructor;
    private static Constructor<?> resetTitleConstructor;
    private static Method componentSerializer;
    private static Constructor<?> chatMessageConstructor;

    public static void sendTitleLegacy(Player player, int fadeIn, int stay, int fadeOut, String title, String subtitle) {
        Valid.checkBoolean(MinecraftVersion.olderThan(MinecraftVersion.V.v1_12), "This method is unsupported on MC 1.13 and later", new Object[0]);
        try {
            Object packet;
            if (titleConstructor == null) {
                return;
            }
            ChatInternals.resetTitleLegacy(player);
            if (titleTimesConstructor != null) {
                Object packet2 = titleTimesConstructor.newInstance(fadeIn, stay, fadeOut);
                Remain.sendPacket(player, packet2);
            }
            if (title != null) {
                Object chatTitle = ChatInternals.serializeText(title);
                packet = titleConstructor.newInstance(enumTitle, chatTitle);
                Remain.sendPacket(player, packet);
            }
            if (subtitle != null) {
                Object chatSubtitle = ChatInternals.serializeText(subtitle);
                packet = subtitleConstructor.newInstance(enumSubtitle, chatSubtitle);
                Remain.sendPacket(player, packet);
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException("Error sending title to: " + player.getName(), ex);
        }
    }

    public static void resetTitleLegacy(Player player) {
        Valid.checkBoolean(MinecraftVersion.olderThan(MinecraftVersion.V.v1_12), "This method is unsupported on MC 1.13 and later", new Object[0]);
        try {
            if (resetTitleConstructor == null) {
                return;
            }
            Object packet = resetTitleConstructor.newInstance(enumReset, null);
            Remain.sendPacket(player, packet);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException("Error resetting title to: " + player.getName());
        }
    }

    public static void sendTablistLegacy(Player player, String headerRaw, String footerRaw) {
        Valid.checkBoolean(MinecraftVersion.olderThan(MinecraftVersion.V.v1_12), "This method is unsupported on MC 1.13 and later", new Object[0]);
        try {
            if (tabConstructor == null) {
                return;
            }
            Object header = ChatInternals.serializeText(headerRaw);
            Object packet = tabConstructor.newInstance(header);
            if (footerRaw != null) {
                Object footer = ChatInternals.serializeText(footerRaw);
                Field f = packet.getClass().getDeclaredField("b");
                f.setAccessible(true);
                f.set(packet, footer);
            }
            Remain.sendPacket(player, packet);
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Failed to send tablist to " + player.getName() + ", title: " + headerRaw + " " + footerRaw);
        }
    }

    public static void sendActionBarLegacy(Player player, String message) {
        Valid.checkBoolean(MinecraftVersion.olderThan(MinecraftVersion.V.v1_12), "This method is unsupported on MC 1.13 and later", new Object[0]);
        ChatInternals.sendChat(player, message, (byte)2);
    }

    private static void sendChat(Player pl, String text, byte type) {
        try {
            Object packet;
            Object message = ChatInternals.serializeText(text);
            Valid.checkNotNull(message, "Message cannot be null!");
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_12)) {
                Class<?> chatMessageTypeEnum = ReflectionUtil.getNMSClass("ChatMessageType");
                packet = chatMessageConstructor.newInstance(message, chatMessageTypeEnum.getMethod("a", Byte.TYPE).invoke(null, type));
            } else {
                packet = chatMessageConstructor.newInstance(message, type);
            }
            Remain.sendPacket(pl, packet);
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Failed to send chat packet type " + type + " to " + pl.getName() + ", message: " + text);
        }
    }

    private static Object serializeText(String text) throws ReflectiveOperationException {
        text = ChatInternals.removeBracketsAndColorize(text);
        try {
            return componentSerializer.invoke(null, "{\"text\":\"" + Matcher.quoteReplacement(text) + "\"}");
        }
        catch (Throwable t) {
            throw new FoException(t, "Failed to serialize text: " + text);
        }
    }

    private static String removeBracketsAndColorize(String text) {
        if (text == null) {
            return "";
        }
        if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        return Common.colorize(text);
    }

    public static void callStatic() {
    }

    static {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_12) && MinecraftVersion.newerThan(MinecraftVersion.V.v1_6)) {
            try {
                Class<?> chatBaseComponent = ReflectionUtil.getNMSClass("IChatBaseComponent");
                Class<?> serializer = null;
                serializer = MinecraftVersion.newerThan(MinecraftVersion.V.v1_7) ? chatBaseComponent.getDeclaredClasses()[0] : ReflectionUtil.getNMSClass("ChatSerializer");
                componentSerializer = serializer.getMethod("a", String.class);
                Class<?> chatPacket = ReflectionUtil.getNMSClass("PacketPlayOutChat");
                if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_11)) {
                    chatMessageConstructor = chatPacket.getConstructor(chatBaseComponent, ReflectionUtil.getNMSClass("ChatMessageType"));
                } else {
                    Constructor<?> constructor = chatMessageConstructor = MinecraftVersion.newerThan(MinecraftVersion.V.v1_7) ? chatPacket.getConstructor(chatBaseComponent, Byte.TYPE) : chatPacket.getConstructor(chatBaseComponent);
                }
                if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
                    Class<?> titlePacket = ReflectionUtil.getNMSClass("PacketPlayOutTitle");
                    Class<?> enumAction = titlePacket.getDeclaredClasses()[0];
                    enumTitle = enumAction.getField("TITLE").get(null);
                    enumSubtitle = enumAction.getField("SUBTITLE").get(null);
                    enumReset = enumAction.getField("RESET").get(null);
                    tabConstructor = ReflectionUtil.getNMSClass("PacketPlayOutPlayerListHeaderFooter").getConstructor(chatBaseComponent);
                    titleTimesConstructor = titlePacket.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    titleConstructor = titlePacket.getConstructor(enumAction, chatBaseComponent);
                    subtitleConstructor = titlePacket.getConstructor(enumAction, chatBaseComponent);
                    resetTitleConstructor = titlePacket.getConstructor(enumAction, chatBaseComponent);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
                throw new ReflectionUtil.ReflectionException("Error initiating Chat/Title/ActionBAR API (incompatible Craftbukkit? - " + Bukkit.getVersion() + " / " + Bukkit.getBukkitVersion() + " / " + MinecraftVersion.getServerVersion() + ")", t);
            }
        }
    }
}

