/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompBarColor;
import org.mineacademy.fo.remain.CompBarStyle;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.remain.internal.EnderDragonEntity;
import org.mineacademy.fo.remain.internal.v1_6;
import org.mineacademy.fo.remain.internal.v1_7;
import org.mineacademy.fo.remain.internal.v1_8;
import org.mineacademy.fo.remain.internal.v1_8Hack;
import org.mineacademy.fo.remain.internal.v1_9Native;

@Deprecated
public class BossBarInternals
implements Listener {
    private static Class<?> entityClass;
    private static boolean isBelowGround;
    private static HashMap<UUID, EnderDragonEntity> players;
    private static HashMap<UUID, Integer> timers;
    private static BossBarInternals singleton;

    private BossBarInternals() {
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPluginDisable(PluginDisableEvent e) {
        if (!MinecraftVersion.olderThan(MinecraftVersion.V.v1_6) && e.getPlugin().equals((Object)SimplePlugin.getInstance()) && singleton != null) {
            singleton.stop();
        }
    }

    private void stop() {
        if (!MinecraftVersion.olderThan(MinecraftVersion.V.v1_6)) {
            for (Player player : Remain.getOnlinePlayers()) {
                BossBarInternals.removeBar(player);
            }
            players.clear();
            Iterator<Object> iterator = timers.values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Bukkit.getScheduler().cancelTask(n);
            }
            timers.clear();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        BossBarInternals.removeBar(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        BossBarInternals.removeBar(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.handleTeleport(event.getPlayer(), event.getTo().clone());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerRespawnEvent event) {
        this.handleTeleport(event.getPlayer(), event.getRespawnLocation().clone());
    }

    private void handleTeleport(Player player, Location loc) {
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_6) || !BossBarInternals.hasBar(player)) {
            return;
        }
        EnderDragonEntity oldDragon = BossBarInternals.getDragon(player, "");
        if (oldDragon instanceof v1_9Native) {
            return;
        }
        Common.runLater(2, () -> {
            if (!BossBarInternals.hasBar(player)) {
                return;
            }
            float health = oldDragon.health;
            String message = oldDragon.name;
            Remain.sendPacket(player, BossBarInternals.getDragon(player, "").getDestroyPacket());
            players.remove(player.getUniqueId());
            EnderDragonEntity dragon = BossBarInternals.addDragon(player, loc, message);
            dragon.health = health;
            BossBarInternals.sendDragon(dragon, player);
        });
    }

    public static void setMessage(Player player, String message, float percent, CompBarColor color, CompBarStyle style) {
        Valid.checkBoolean(0.0f <= percent && percent <= 100.0f, "Percent must be between 0F and 100F, but was: " + percent, new Object[0]);
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_6)) {
            return;
        }
        if (BossBarInternals.hasBar(player)) {
            BossBarInternals.removeBar(player);
        }
        EnderDragonEntity dragon = BossBarInternals.getDragon(player, message);
        dragon.name = BossBarInternals.cleanMessage(message);
        dragon.health = percent / 100.0f * dragon.getMaxHealth();
        if (color != null) {
            dragon.barColor = color;
        }
        if (style != null) {
            dragon.barStyle = style;
        }
        BossBarInternals.cancelTimer(player);
        BossBarInternals.sendDragon(dragon, player);
    }

    public static void setMessage(Player player, String message, int seconds, CompBarColor color, CompBarStyle style) {
        Valid.checkBoolean(seconds > 0, "Seconds must be > 1 ", new Object[0]);
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_6)) {
            return;
        }
        if (BossBarInternals.hasBar(player)) {
            BossBarInternals.removeBar(player);
        }
        EnderDragonEntity dragon = BossBarInternals.getDragon(player, message);
        dragon.name = BossBarInternals.cleanMessage(message);
        dragon.health = dragon.getMaxHealth();
        if (color != null) {
            dragon.barColor = color;
        }
        if (style != null) {
            dragon.barStyle = style;
        }
        float dragonHealthMinus = dragon.getMaxHealth() / (float)seconds;
        BossBarInternals.cancelTimer(player);
        timers.put(player.getUniqueId(), Common.runTimer(20, 20, () -> {
            EnderDragonEntity drag = BossBarInternals.getDragon(player, "");
            drag.health -= dragonHealthMinus;
            if (drag.health <= 1.0f) {
                BossBarInternals.removeBar(player);
                BossBarInternals.cancelTimer(player);
            } else {
                BossBarInternals.sendDragon(drag, player);
            }
        }).getTaskId());
        BossBarInternals.sendDragon(dragon, player);
    }

    public static void removeBar(Player player) {
        if (!BossBarInternals.hasBar(player)) {
            return;
        }
        if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_6)) {
            return;
        }
        EnderDragonEntity dragon = BossBarInternals.getDragon(player, "");
        if (dragon instanceof v1_9Native) {
            ((v1_9Native)dragon).removePlayer(player);
        } else {
            Remain.sendPacket(player, BossBarInternals.getDragon(player, "").getDestroyPacket());
        }
        players.remove(player.getUniqueId());
        BossBarInternals.cancelTimer(player);
    }

    private static boolean hasBar(Player player) {
        return players.containsKey(player.getUniqueId());
    }

    private static String cleanMessage(String message) {
        if (message.length() > 64) {
            message = message.substring(0, 63);
        }
        return message;
    }

    private static void cancelTimer(Player player) {
        Integer timerID = timers.remove(player.getUniqueId());
        if (timerID != null) {
            Bukkit.getScheduler().cancelTask(timerID.intValue());
        }
    }

    private static void sendDragon(EnderDragonEntity dragon, Player player) {
        if (dragon instanceof v1_9Native) {
            v1_9Native bar = (v1_9Native)dragon;
            bar.addPlayer(player);
            bar.setProgress(dragon.health / dragon.getMaxHealth());
        } else {
            Remain.sendPacket(player, dragon.getMetaPacket(dragon.getWatcher()));
            Remain.sendPacket(player, dragon.getTeleportPacket(BossBarInternals.getDragonLocation(player.getLocation())));
        }
    }

    private static EnderDragonEntity getDragon(Player player, String message) {
        if (BossBarInternals.hasBar(player)) {
            return players.get(player.getUniqueId());
        }
        return BossBarInternals.addDragon(player, BossBarInternals.cleanMessage(message));
    }

    private static EnderDragonEntity addDragon(Player player, String message) {
        EnderDragonEntity dragon = BossBarInternals.newDragon(message, BossBarInternals.getDragonLocation(player.getLocation()));
        if (dragon instanceof v1_9Native) {
            ((v1_9Native)dragon).addPlayer(player);
        } else {
            Remain.sendPacket(player, dragon.getSpawnPacket());
        }
        players.put(player.getUniqueId(), dragon);
        return dragon;
    }

    private static EnderDragonEntity addDragon(Player player, Location loc, String message) {
        EnderDragonEntity dragon = BossBarInternals.newDragon(message, BossBarInternals.getDragonLocation(loc));
        if (dragon instanceof v1_9Native) {
            ((v1_9Native)dragon).addPlayer(player);
        } else {
            Remain.sendPacket(player, dragon.getSpawnPacket());
        }
        players.put(player.getUniqueId(), dragon);
        return dragon;
    }

    private static Location getDragonLocation(Location loc) {
        if (isBelowGround) {
            loc.subtract(0.0, 300.0, 0.0);
            return loc;
        }
        float pitch = loc.getPitch();
        if (pitch >= 55.0f) {
            loc.add(0.0, -300.0, 0.0);
        } else if (pitch <= -55.0f) {
            loc.add(0.0, 300.0, 0.0);
        } else {
            loc = loc.getBlock().getRelative(BossBarInternals.getDirection(loc), Bukkit.getViewDistance() * 16).getLocation();
        }
        return loc;
    }

    private static BlockFace getDirection(Location loc) {
        float dir = Math.round(loc.getYaw() / 90.0f);
        if (dir == -4.0f || dir == 0.0f || dir == 4.0f) {
            return BlockFace.SOUTH;
        }
        if (dir == -1.0f || dir == 3.0f) {
            return BlockFace.EAST;
        }
        if (dir == -2.0f || dir == 2.0f) {
            return BlockFace.NORTH;
        }
        if (dir == -3.0f || dir == 1.0f) {
            return BlockFace.WEST;
        }
        return null;
    }

    private static EnderDragonEntity newDragon(String message, Location loc) {
        EnderDragonEntity fakeDragon = null;
        try {
            fakeDragon = (EnderDragonEntity)entityClass.getConstructor(String.class, Location.class).newInstance(message, loc);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return fakeDragon;
    }

    public static void callStatic() {
    }

    static {
        isBelowGround = true;
        players = new HashMap();
        timers = new HashMap();
        singleton = null;
        if (Remain.isProtocol18Hack()) {
            entityClass = v1_8Hack.class;
            isBelowGround = false;
        } else if (MinecraftVersion.equals(MinecraftVersion.V.v1_6)) {
            entityClass = v1_6.class;
        } else if (MinecraftVersion.equals(MinecraftVersion.V.v1_7)) {
            entityClass = v1_7.class;
        } else if (MinecraftVersion.equals(MinecraftVersion.V.v1_8)) {
            entityClass = v1_8.class;
            isBelowGround = false;
        } else if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_8)) {
            entityClass = v1_9Native.class;
        }
        if (!MinecraftVersion.olderThan(MinecraftVersion.V.v1_6)) {
            Valid.checkNotNull(entityClass, "Compatible does not support Boss bar on MC version " + MinecraftVersion.getServerVersion() + "!");
            if (singleton == null && SimplePlugin.getInstance().isEnabled()) {
                singleton = new BossBarInternals();
                Bukkit.getPluginManager().registerEvents((Listener)singleton, (Plugin)SimplePlugin.getInstance());
                if (Remain.isProtocol18Hack()) {
                    Common.runTimer(5, () -> {
                        for (UUID uuid : players.keySet()) {
                            Player player = Remain.getPlayerByUUID(uuid);
                            Remain.sendPacket(player, players.get(uuid).getTeleportPacket(BossBarInternals.getDragonLocation(player.getLocation())));
                        }
                    });
                }
            }
        }
    }
}

