/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.ItemUtil;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.model.UUIDToNameConverter;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.AdvancementAccessor;
import org.mineacademy.fo.remain.BungeeChatProvider;
import org.mineacademy.fo.remain.CompBarColor;
import org.mineacademy.fo.remain.CompBarStyle;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.SneakyThrow;
import org.mineacademy.fo.remain.internal.BossBarInternals;
import org.mineacademy.fo.remain.internal.ChatInternals;
import org.mineacademy.fo.remain.internal.ParticleInternals;
import org.mineacademy.fo.remain.nbt.NBTInternals;

public final class Remain {
    private static final Pattern RGB_HEX_ENCODED_REGEX = Pattern.compile("(?i)(\u00a7x)((\u00a7[0-9A-F]){6})");
    private static final Method getPlayersMethod;
    private static final Method getHealthMethod;
    private static Method getHandle;
    private static Field fieldPlayerConnection;
    private static Method sendPacket;
    private static boolean isGetPlayersCollection;
    private static boolean isGetHealthDouble;
    private static boolean hasExtendedPlayerTitleAPI;
    private static boolean hasParticleAPI;
    private static boolean newScoreboardAPI;
    private static boolean hasBookEvent;
    private static boolean hasInventoryLocation;
    private static boolean hasScoreboardTags;
    private static boolean hasSpawnEggMeta;
    private static boolean hasAdvancements;
    private static boolean bungeeApiPresent;
    private static final StrictMap<UUID, StrictMap<Material, Integer>> cooldowns;

    private Remain() {
    }

    public static Object getHandleWorld(World world) {
        Object nms = null;
        Method handle = ReflectionUtil.getMethod(world.getClass(), "getHandle");
        try {
            nms = handle.invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return nms;
    }

    public static Object getHandleEntity(Entity entity) {
        Object nms_entity = null;
        Method handle = ReflectionUtil.getMethod(entity.getClass(), "getHandle");
        try {
            nms_entity = handle.invoke((Object)entity, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return nms_entity;
    }

    public static boolean isProtocol18Hack() {
        try {
            ReflectionUtil.getNMSClass("PacketPlayOutEntityTeleport").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void sendPacket(Player player, Object packet) {
        if (getHandle == null || fieldPlayerConnection == null || sendPacket == null) {
            System.out.println("Cannot send packet " + packet.getClass().getSimpleName() + " on your server sofware (known to be broken on Cauldron).");
            return;
        }
        try {
            Object handle = getHandle.invoke((Object)player, new Object[0]);
            Object playerConnection = fieldPlayerConnection.get(handle);
            sendPacket.invoke(playerConnection, packet);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException("Could not send " + packet.getClass().getSimpleName() + " to " + player.getName(), ex);
        }
    }

    public static int getHealth(LivingEntity entity) {
        return isGetHealthDouble ? (int)entity.getHealth() : Remain.getHealhLegacy(entity);
    }

    public static int getMaxHealth(LivingEntity entity) {
        return isGetHealthDouble ? (int)entity.getMaxHealth() : Remain.getMaxHealhLegacy(entity);
    }

    public static Collection<? extends Player> getOnlinePlayers() {
        return isGetPlayersCollection ? Bukkit.getOnlinePlayers() : Arrays.asList(Remain.getPlayersLegacy());
    }

    public static FallingBlock spawnFallingBlock(Block block) {
        return Remain.spawnFallingBlock(block.getLocation().add(0.5, 0.0, 0.5), block.getType(), block.getData());
    }

    public static FallingBlock spawnFallingBlock(Location loc, Block block) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            return loc.getWorld().spawnFallingBlock(loc, block.getBlockData());
        }
        try {
            return (FallingBlock)loc.getWorld().getClass().getMethod("spawnFallingBlock", Location.class, Integer.TYPE, Byte.TYPE).invoke((Object)loc.getWorld(), loc, ReflectionUtil.invoke("getTypeId", (Object)block, new Object[0]), block.getData());
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material material) {
        return Remain.spawnFallingBlock(loc, material, (byte)0);
    }

    public static FallingBlock spawnFallingBlock(Location loc, Material material, byte data) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            return loc.getWorld().spawnFallingBlock(loc, material, data);
        }
        try {
            return (FallingBlock)loc.getWorld().getClass().getMethod("spawnFallingBlock", Location.class, Integer.TYPE, Byte.TYPE).invoke((Object)loc.getWorld(), loc, material.getId(), data);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static Item spawnItem(Location location, ItemStack item, Consumer<Item> modifier) {
        try {
            Class<?> nmsWorldClass = ReflectionUtil.getNMSClass("World");
            Class<?> nmsStackClass = ReflectionUtil.getNMSClass("ItemStack");
            Class<?> nmsEntityClass = ReflectionUtil.getNMSClass("Entity");
            Class<?> nmsItemClass = ReflectionUtil.getNMSClass("EntityItem");
            Constructor<?> entityConstructor = nmsItemClass.getConstructor(nmsWorldClass, Double.TYPE, Double.TYPE, Double.TYPE, nmsStackClass);
            Object nmsWorld = location.getWorld().getClass().getMethod("getHandle", new Class[0]).invoke((Object)location.getWorld(), new Object[0]);
            Method asNmsCopy = ReflectionUtil.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class);
            Object nmsEntity = entityConstructor.newInstance(nmsWorld, location.getX(), location.getY(), location.getZ(), asNmsCopy.invoke(null, item));
            Class<?> craftItemClass = ReflectionUtil.getOBCClass("entity.CraftItem");
            Class<?> craftServerClass = ReflectionUtil.getOBCClass("CraftServer");
            Object bukkitItem = craftItemClass.getConstructor(craftServerClass, nmsItemClass).newInstance(Bukkit.getServer(), nmsEntity);
            Valid.checkBoolean(bukkitItem instanceof Item, "Failed to make an dropped item, got " + bukkitItem.getClass().getSimpleName(), new Object[0]);
            modifier.accept((Item)bukkitItem);
            Method addEntity = location.getWorld().getClass().getMethod("addEntity", nmsEntityClass, CreatureSpawnEvent.SpawnReason.class);
            addEntity.invoke((Object)location.getWorld(), nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return (Item)bukkitItem;
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Error spawning item " + item.getType() + " at " + location);
            return null;
        }
    }

    public static void setData(Block block, int data) {
        try {
            Block.class.getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)data);
        }
        catch (NoSuchMethodException ex) {
            block.setBlockData(Bukkit.getUnsafe().fromLegacy(block.getType(), (byte)data), true);
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
        }
    }

    public static void setTypeAndData(Block block, CompMaterial material, byte data) {
        Remain.setTypeAndData(block, material.getMaterial(), data);
    }

    public static void setTypeAndData(Block block, Material material, byte data) {
        Remain.setTypeAndData(block, material, data, true);
    }

    public static void setTypeAndData(Block block, Material material, byte data, boolean physics) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            block.setType(material);
            block.setBlockData(Bukkit.getUnsafe().fromLegacy(material, data), physics);
        } else {
            try {
                block.getClass().getMethod("setTypeIdAndData", Integer.TYPE, Byte.TYPE, Boolean.TYPE).invoke((Object)block, material.getId(), data, physics);
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String toLegacyText(String json) throws InteractiveTextFoundException {
        return Remain.toLegacyText(json, true);
    }

    public static String toLegacyText(String json, boolean denyEvents) throws InteractiveTextFoundException {
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        StringBuilder text = new StringBuilder();
        try {
            for (BaseComponent comp : ComponentSerializer.parse((String)json)) {
                if ((comp.getHoverEvent() != null || comp.getClickEvent() != null) && denyEvents) {
                    throw new InteractiveTextFoundException();
                }
                text.append(comp.toLegacyText());
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof InteractiveTextFoundException) {
                throw throwable;
            }
            Debugger.saveError(throwable, "Unable to parse JSON message.", "JSON: " + json, "Error: %error");
        }
        return text.toString();
    }

    public static String toJson(String message) {
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        return Remain.toJson(TextComponent.fromLegacyText((String)message));
    }

    public static String toJson(BaseComponent ... comps) {
        String json;
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        try {
            json = ComponentSerializer.toString((BaseComponent[])comps);
        }
        catch (Throwable t) {
            json = new Gson().toJson((Object)new TextComponent(comps).toLegacyText());
        }
        return json;
    }

    public static String toJson(ItemStack item) {
        Class<?> craftItemstack = ReflectionUtil.getOBCClass("inventory.CraftItemStack");
        Method asNMSCopyMethod = ReflectionUtil.getMethod(craftItemstack, "asNMSCopy", ItemStack.class);
        Class<?> nmsItemStack = ReflectionUtil.getNMSClass("ItemStack");
        Class<?> nbtTagCompound = ReflectionUtil.getNMSClass("NBTTagCompound");
        Method saveItemstackMethod = ReflectionUtil.getMethod(nmsItemStack, "save", nbtTagCompound);
        Object nmsNbtTagCompoundObj = ReflectionUtil.instantiate(nbtTagCompound);
        Object nmsItemStackObj = ReflectionUtil.invoke(asNMSCopyMethod, null, item);
        Object itemAsJsonObject = ReflectionUtil.invoke(saveItemstackMethod, nmsItemStackObj, nmsNbtTagCompoundObj);
        return itemAsJsonObject.toString();
    }

    public static BaseComponent[] toComponent(String json) {
        Valid.checkBoolean(bungeeApiPresent, "(Un)packing chat requires Spigot 1.7.10 or newer", new Object[0]);
        return ComponentSerializer.parse((String)json);
    }

    public static void sendJson(CommandSender sender, String json, SerializedMap placeholders) {
        try {
            BaseComponent[] components = ComponentSerializer.parse((String)json);
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_16)) {
                Remain.replaceHexPlaceholders(Arrays.asList(components), placeholders);
            }
            Remain.sendComponent(sender, components);
        }
        catch (RuntimeException ex) {
            Common.error(ex, "Malformed JSON when sending message to " + sender.getName() + " with JSON: " + json);
        }
    }

    private static void replaceHexPlaceholders(List<BaseComponent> components, SerializedMap placeholders) {
        for (BaseComponent component : components) {
            if (component instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)component;
                String text = textComponent.getText();
                for (Map.Entry<String, Object> entry : placeholders.entrySet()) {
                    String key = entry.getKey();
                    String value = Common.simplify(entry.getValue());
                    Matcher match = RGB_HEX_ENCODED_REGEX.matcher(text);
                    while (match.find()) {
                        String color = "#" + match.group(2).replace("\u00a7", "");
                        value = match.replaceAll("");
                        textComponent.setColor(ChatColor.of((String)color));
                    }
                    key = key.charAt(0) != '{' ? "{" + key : key;
                    key = key.charAt(key.length() - 1) != '}' ? key + "}" : key;
                    text = text.replace(key, value);
                    textComponent.setText(text);
                }
            }
            if (component.getExtra() != null) {
                Remain.replaceHexPlaceholders(component.getExtra(), placeholders);
            }
            if (component.getHoverEvent() == null) continue;
            Remain.replaceHexPlaceholders(Arrays.asList(component.getHoverEvent().getValue()), placeholders);
        }
    }

    public static void sendJson(CommandSender sender, String json) {
        try {
            Remain.sendComponent(sender, ComponentSerializer.parse((String)json));
        }
        catch (RuntimeException ex) {
            Common.error(ex, "Malformed JSON when sending message to " + sender.getName() + " with JSON: " + json);
        }
    }

    public static void sendComponent(CommandSender sender, Object comps) {
        BungeeChatProvider.sendComponent(sender, comps);
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        Remain.sendTitle(player, 20, 60, 20, title, subtitle);
    }

    public static void sendTitle(Player player, int fadeIn, int stay, int fadeOut, String title, String subtitle) {
        if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
            if (hasExtendedPlayerTitleAPI) {
                player.sendTitle(Common.colorize(title), Common.colorize(subtitle), fadeIn, stay, fadeOut);
            } else {
                ChatInternals.sendTitleLegacy(player, fadeIn, stay, fadeOut, title, subtitle);
            }
        } else {
            Common.tell((CommandSender)player, title);
            Common.tell((CommandSender)player, subtitle);
        }
    }

    public static void resetTitle(Player player) {
        if (hasExtendedPlayerTitleAPI) {
            player.resetTitle();
        } else {
            ChatInternals.resetTitleLegacy(player);
        }
    }

    public static void sendTablist(Player player, String header, String footer) {
        Valid.checkBoolean(MinecraftVersion.newerThan(MinecraftVersion.V.v1_7), "Sending tab list requires Minecraft 1.8x or newer!", new Object[0]);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            player.setPlayerListHeaderFooter(Common.colorize(header), Common.colorize(footer));
        } else {
            ChatInternals.sendTablistLegacy(player, header, footer);
        }
    }

    public static void sendActionBar(Player player, String text) {
        if (!MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
            Common.tell((CommandSender)player, text);
            return;
        }
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Common.colorize(text)));
        }
        catch (NoSuchMethodError err) {
            ChatInternals.sendActionBarLegacy(player, text);
        }
    }

    public static void sendBossbarPercent(Player player, String message, float percent) {
        Remain.sendBossbarPercent(player, message, percent, null, null);
    }

    public static void sendBossbarPercent(Player player, String message, float percent, CompBarColor color, CompBarStyle style) {
        BossBarInternals.setMessage(player, message, percent, color, style);
    }

    public static void sendBossbarTimed(Player player, String message, int seconds) {
        Remain.sendBossbarTimed(player, message, seconds, null, null);
    }

    public static void sendBossbarTimed(Player player, String message, int seconds, CompBarColor color, CompBarStyle style) {
        BossBarInternals.setMessage(player, message, seconds, color, style);
    }

    public static void removeBar(Player player) {
        BossBarInternals.removeBar(player);
    }

    public static PluginCommand newCommand(String label) {
        try {
            Constructor con = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            con.setAccessible(true);
            return (PluginCommand)con.newInstance(new Object[]{label, SimplePlugin.getInstance()});
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Unable to create command: /" + label);
        }
    }

    public static void setCommandName(PluginCommand command, String name) {
        try {
            command.setName(name);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static void registerCommand(Command command) {
        SimpleCommandMap commandMap = Remain.getCommandMap();
        commandMap.register(command.getLabel(), command);
        Valid.checkBoolean(command.isRegistered(), "Command /" + command.getLabel() + " could not have been registered properly!", new Object[0]);
    }

    public static void unregisterCommand(String label) {
        Remain.unregisterCommand(label, true);
    }

    public static void unregisterCommand(String label, boolean removeAliases) {
        try {
            PluginCommand command = Bukkit.getPluginCommand((String)label);
            if (command != null) {
                Field commandField = Command.class.getDeclaredField("commandMap");
                commandField.setAccessible(true);
                if (command.isRegistered()) {
                    command.unregister((CommandMap)commandField.get(command));
                }
            }
            Field f = SimpleCommandMap.class.getDeclaredField("knownCommands");
            f.setAccessible(true);
            Map cmdMap = (Map)f.get(Remain.getCommandMap());
            cmdMap.remove(label);
            if (command != null && removeAliases) {
                for (String alias : command.getAliases()) {
                    cmdMap.remove(alias);
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Failed to unregister command /" + label);
        }
    }

    private static SimpleCommandMap getCommandMap() {
        try {
            return (SimpleCommandMap)ReflectionUtil.getOBCClass("CraftServer").getDeclaredMethod("getCommandMap", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Unable to get the command map");
        }
    }

    public static void registerEnchantment(Enchantment enchantment) {
        Remain.unregisterEnchantment(enchantment);
        ReflectionUtil.setStaticField(Enchantment.class, "acceptingNew", true);
        Enchantment.registerEnchantment((Enchantment)enchantment);
    }

    public static void unregisterEnchantment(Enchantment enchantment) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            Map byKey = (Map)ReflectionUtil.getStaticFieldContent(Enchantment.class, "byKey");
            byKey.remove(enchantment.getKey());
        }
        Map byName = (Map)ReflectionUtil.getStaticFieldContent(Enchantment.class, "byName");
        byName.remove(enchantment.getName());
    }

    public static Location getLocation(Inventory inv) {
        if (hasInventoryLocation) {
            try {
                return inv.getLocation();
            }
            catch (NullPointerException ex) {
                return null;
            }
        }
        return inv.getHolder() instanceof BlockState ? ((BlockState)inv.getHolder()).getLocation() : (!inv.getViewers().isEmpty() ? ((HumanEntity)inv.getViewers().iterator().next()).getLocation() : null);
    }

    public static String getLocale(Player player) {
        try {
            return player.getLocale();
        }
        catch (Throwable t) {
            try {
                Player.Spigot spigot = player.spigot();
                Method method = ReflectionUtil.getMethod(spigot.getClass(), "getLocale");
                return (String)ReflectionUtil.invoke(method, (Object)spigot, new Object[0]);
            }
            catch (Throwable tt) {
                return null;
            }
        }
    }

    public static String getNMSStatisticName(Statistic stat, @Nullable Material mat, @Nullable EntityType en) {
        Class<?> craftStatistic = ReflectionUtil.getOBCClass("CraftStatistic");
        Object nmsStatistic = null;
        try {
            nmsStatistic = stat.getType() == Statistic.Type.UNTYPED ? craftStatistic.getMethod("getNMSStatistic", stat.getClass()).invoke(null, stat) : (stat.getType() == Statistic.Type.ENTITY ? craftStatistic.getMethod("getEntityStatistic", stat.getClass(), en.getClass()).invoke(null, stat, en) : craftStatistic.getMethod("getMaterialStatistic", stat.getClass(), mat.getClass()).invoke(null, stat, mat));
            Valid.checkNotNull(nmsStatistic, "Could not get NMS statistic from Bukkit's " + stat);
            if (MinecraftVersion.equals(MinecraftVersion.V.v1_8)) {
                Field f = nmsStatistic.getClass().getField("name");
                f.setAccessible(true);
                return f.get(nmsStatistic).toString();
            }
            return (String)nmsStatistic.getClass().getMethod("getName", new Class[0]).invoke(nmsStatistic, new Object[0]);
        }
        catch (Throwable t) {
            throw new FoException(t, "Error getting NMS statistic name from " + stat);
        }
    }

    public static void respawn(Player player) {
        Remain.respawn(player, 2);
    }

    public static void respawn(Player player, int delayTicks) {
        Common.runLater(delayTicks, () -> {
            try {
                player.spigot().respawn();
            }
            catch (NoSuchMethodError err) {
                try {
                    Constructor<?>[] constructors;
                    Object respawnEnum = ReflectionUtil.getNMSClass("EnumClientCommand").getEnumConstants()[0];
                    for (Constructor<?> constructor : constructors = ReflectionUtil.getNMSClass("PacketPlayInClientCommand").getConstructors()) {
                        Class<?>[] args = constructor.getParameterTypes();
                        if (args.length != 1 || args[0] != respawnEnum.getClass()) continue;
                        Object packet = ReflectionUtil.getNMSClass("PacketPlayInClientCommand").getConstructor(args).newInstance(respawnEnum);
                        Remain.sendPacket(player, packet);
                    }
                }
                catch (Throwable e) {
                    throw new FoException(e, "Failed to send respawn packet to " + player.getName());
                }
            }
        });
    }

    @Deprecated
    public static void updateInventoryTitle(Player player, String title) {
        try {
            Object packet;
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_8)) {
                return;
            }
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_9) && title.length() > 16) {
                title = title.substring(0, 15);
            }
            Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object activeContainer = entityPlayer.getClass().getField("activeContainer").get(entityPlayer);
            Constructor<?> chatMessageConst = ReflectionUtil.getNMSClass("ChatMessage").getConstructor(String.class, Object[].class);
            Object windowId = activeContainer.getClass().getField("windowId").get(activeContainer);
            Object chatMessage = chatMessageConst.newInstance(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title), new Object[0]);
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                Class<?> containersClass = ReflectionUtil.getNMSClass("Containers");
                Constructor<?> packetConst = ReflectionUtil.getNMSClass("PacketPlayOutOpenWindow").getConstructor(Integer.TYPE, containersClass, ReflectionUtil.getNMSClass("IChatBaseComponent"));
                int inventorySize = player.getOpenInventory().getTopInventory().getSize() / 9;
                if (inventorySize < 1 || inventorySize > 6) {
                    Common.log("Cannot update title for " + player.getName() + " as their inventory has non typical size: " + inventorySize + " rows");
                    return;
                }
                Object container = containersClass.getField("GENERIC_9X" + inventorySize).get(null);
                packet = packetConst.newInstance(windowId, container, chatMessage);
            } else {
                Constructor<?> packetConst = ReflectionUtil.getNMSClass("PacketPlayOutOpenWindow").getConstructor(Integer.TYPE, String.class, ReflectionUtil.getNMSClass("IChatBaseComponent"), Integer.TYPE);
                packet = packetConst.newInstance(windowId, "minecraft:chest", chatMessage, player.getOpenInventory().getTopInventory().getSize());
            }
            Remain.sendPacket(player, packet);
            entityPlayer.getClass().getMethod("updateInventory", ReflectionUtil.getNMSClass("Container")).invoke(entityPlayer, activeContainer);
        }
        catch (ReflectiveOperationException ex) {
            Common.error(ex, "Error updating " + player.getName() + " inventory title to '" + title + "'");
        }
    }

    public static void sendBlockChange(int delayTicks, Player player, Location location, CompMaterial material) {
        if (delayTicks > 0) {
            Common.runLater(delayTicks, () -> Remain.sendBlockChange0(player, location, material));
        } else {
            Remain.sendBlockChange0(player, location, material);
        }
    }

    private static void sendBlockChange0(Player player, Location location, CompMaterial material) {
        try {
            player.sendBlockChange(location, material.getMaterial().createBlockData());
        }
        catch (NoSuchMethodError ex) {
            player.sendBlockChange(location, material.getMaterial(), (byte)material.getData());
        }
    }

    public static void sendBlockChange(int delayTicks, Player player, Block block) {
        if (delayTicks > 0) {
            Common.runLater(delayTicks, () -> Remain.sendBlockChange0(player, block));
        } else {
            Remain.sendBlockChange0(player, block);
        }
    }

    private static void sendBlockChange0(Player player, Block block) {
        try {
            player.sendBlockChange(block.getLocation(), block.getBlockData());
        }
        catch (NoSuchMethodError ex) {
            player.sendBlockChange(block.getLocation(), block.getType(), block.getData());
        }
    }

    public static int getPlaytimeMinutes(Player player) {
        return player.getStatistic(Remain.getPlayTimeStatisticName()) / (Remain.isPlaytimeStatisticTicks() ? 20 : 1);
    }

    public static Statistic getPlayTimeStatisticName() {
        return Statistic.valueOf((String)(MinecraftVersion.olderThan(MinecraftVersion.V.v1_13) ? "PLAY_ONE_TICK" : "PLAY_ONE_MINUTE"));
    }

    public static boolean isPlaytimeStatisticTicks() {
        return MinecraftVersion.olderThan(MinecraftVersion.V.v1_13);
    }

    public static boolean isInteractEventPrimaryHand(PlayerInteractEvent e) {
        try {
            return e.getHand() != null && e.getHand() == EquipmentSlot.HAND;
        }
        catch (NoSuchMethodError err) {
            return true;
        }
    }

    public static boolean isInteractEventPrimaryHand(PlayerInteractEntityEvent e) {
        try {
            return e.getHand() != null && e.getHand() == EquipmentSlot.HAND;
        }
        catch (NoSuchMethodError err) {
            return true;
        }
    }

    public static Score getScore(Objective obj, String entry) {
        Valid.checkNotNull(obj, "Objective cannot be null");
        entry = Common.colorize(entry);
        try {
            return obj.getScore(entry);
        }
        catch (NoSuchMethodError err) {
            return obj.getScore(Bukkit.getOfflinePlayer((String)entry));
        }
    }

    public static OfflinePlayer getOfflinePlayerByUUID(UUID id) {
        try {
            return Bukkit.getOfflinePlayer((UUID)id);
        }
        catch (NoSuchMethodError err) {
            UUIDToNameConverter f = new UUIDToNameConverter(id);
            try {
                String name = f.call();
                return Bukkit.getOfflinePlayer((String)name);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    public static Player getPlayerByUUID(UUID id) {
        try {
            return Bukkit.getPlayer((UUID)id);
        }
        catch (NoSuchMethodError err) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!player.getUniqueId().equals(id)) continue;
                return player;
            }
            return null;
        }
    }

    public static double getFinalDamage(EntityDamageEvent e) {
        try {
            return e.getFinalDamage();
        }
        catch (NoSuchMethodError err) {
            return e.getDamage();
        }
    }

    public static Inventory getClickedInventory(InventoryClickEvent e) {
        int slot = e.getRawSlot();
        InventoryView view = e.getView();
        return slot < 0 ? null : (view.getTopInventory() != null && slot < view.getTopInventory().getSize() ? view.getTopInventory() : view.getBottomInventory());
    }

    public static String getName(Entity entity) {
        try {
            return entity.getName();
        }
        catch (NoSuchMethodError t) {
            return entity instanceof Player ? ((Player)entity).getName() : ItemUtil.bountifyCapitalized(entity.getType());
        }
    }

    public static void setCustomName(Entity en, String name) {
        try {
            en.setCustomNameVisible(true);
            en.setCustomName(Common.colorize(name));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static CompMaterial getMaterial(String material, CompMaterial fallback) {
        Material mat = null;
        try {
            mat = Material.getMaterial((String)material);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mat != null ? CompMaterial.fromMaterial(mat) : fallback;
    }

    public static Material getMaterial(String newMaterial, String oldMaterial) {
        try {
            return Material.getMaterial((String)newMaterial);
        }
        catch (Throwable t) {
            return Material.getMaterial((String)oldMaterial);
        }
    }

    public static Block getTargetBlock(LivingEntity en, int radius) {
        try {
            return en.getTargetBlock((Set)null, radius);
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                return null;
            }
            try {
                return (Block)en.getClass().getMethod("getTargetBlock", HashSet.class, Integer.TYPE).invoke((Object)en, null, radius);
            }
            catch (ReflectiveOperationException ex2) {
                throw new FoException(t, "Unable to get target block for " + en);
            }
        }
    }

    public static void sendToast(Player receiver, String message) {
        Remain.sendToast(receiver, message, CompMaterial.BOOK);
    }

    public static void sendToast(Player receiver, String message, CompMaterial icon) {
        String colorized;
        if (hasAdvancements && message != null && !message.isEmpty() && !(colorized = Common.colorize(message)).isEmpty()) {
            Valid.checkSync("Toasts may only be sent from the main thread");
            new AdvancementAccessor(colorized, icon.toString().toLowerCase()).show(receiver);
        }
    }

    public static void setCooldown(Player player, Material material, int cooldownTicks) {
        try {
            player.setCooldown(material, cooldownTicks);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            cooldown.override(material, cooldownTicks);
            cooldowns.override(player.getUniqueId(), cooldown);
        }
    }

    public static boolean hasCooldown(Player player, Material material) {
        try {
            return player.hasCooldown(material);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            return cooldown.contains(material);
        }
    }

    public static int getCooldown(Player player, Material material) {
        try {
            return player.getCooldown(material);
        }
        catch (Throwable t) {
            StrictMap<Material, Integer> cooldown = Remain.getCooldown(player);
            return cooldown.getOrDefault(material, 0);
        }
    }

    private static StrictMap<Material, Integer> getCooldown(Player player) {
        return cooldowns.getOrDefault(player.getUniqueId(), new StrictMap());
    }

    public static Entity getEntity(UUID uuid) {
        Remain.catchAsync("iterating through entities [CMN]");
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!entity.getUniqueId().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static Collection<Entity> getNearbyEntities(Location location, double radius) {
        try {
            return location.getWorld().getNearbyEntities(location, radius, radius, radius);
        }
        catch (Throwable t) {
            ArrayList<Entity> found = new ArrayList<Entity>();
            for (Entity e : location.getWorld().getEntities()) {
                if (!(e.getLocation().distance(location) <= radius)) continue;
                found.add(e);
            }
            return found;
        }
    }

    public static void takeHandItem(Player player) {
        Remain.takeItemAndSetAsHand(player, player.getItemInHand());
    }

    public static void takeItemAndSetAsHand(Player player, ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItemInHand(item);
        } else {
            player.getInventory().setItemInHand(null);
        }
        player.updateInventory();
    }

    public static void takeItemOnePiece(Player player, ItemStack item) {
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_15)) {
            item.setAmount(item.getAmount() - 1);
        } else {
            Common.runLater(() -> {
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                } else if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_9)) {
                    item.setAmount(0);
                } else {
                    ItemStack[] content = player.getInventory().getContents();
                    for (int i = 0; i < content.length; ++i) {
                        ItemStack c = content[i];
                        if (c == null || !c.equals((Object)item)) continue;
                        content[i] = null;
                        break;
                    }
                    player.getInventory().setContents(content);
                }
                player.updateInventory();
            });
        }
    }

    public static void setPotion(ItemStack item, PotionEffectType type, int level) {
        PotionType wrapped = PotionType.getByEffect((PotionEffectType)type);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        try {
            PotionData data = new PotionData(level > 0 && wrapped != null ? wrapped : PotionType.WATER);
            if (level > 0 && wrapped == null) {
                meta.addEnchant(Enchantment.DURABILITY, 1, true);
            }
            meta.setBasePotionData(data);
        }
        catch (NoClassDefFoundError | NoSuchMethodError ex) {
            meta.setMainEffect(type);
            meta.addCustomEffect(new PotionEffect(type, Integer.MAX_VALUE, level - 1), true);
        }
        item.setItemMeta((ItemMeta)meta);
    }

    public static String getI18NDisplayName(ItemStack item) {
        try {
            return (String)item.getClass().getDeclaredMethod("getI18NDisplayName", new Class[0]).invoke((Object)item, new Object[0]);
        }
        catch (Throwable t) {
            return ItemUtil.bountifyCapitalized(item.getType());
        }
    }

    public static YamlConfiguration loadConfiguration(InputStream is) {
        YamlConfiguration conf = null;
        try {
            conf = Remain.loadConfigurationStrict(is);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        Valid.checkNotNull(conf, "Could not load configuration from " + is);
        return conf;
    }

    public static YamlConfiguration loadConfigurationStrict(InputStream is) throws Throwable {
        YamlConfiguration conf = new YamlConfiguration();
        try {
            conf.load((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        catch (NoSuchMethodError ex) {
            Remain.loadFromString(is, conf);
        }
        return conf;
    }

    private static void loadFromString(InputStream stream, YamlConfiguration conf) throws IOException, InvalidConfigurationException {
        Valid.checkNotNull(stream, "Stream cannot be null");
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream);
        try (BufferedReader input = new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        conf.loadFromString(builder.toString());
    }

    public static double getMaxHealth() {
        try {
            String health = String.valueOf(Class.forName("org.spigotmc.SpigotConfig").getField("maxHealth").get(null));
            return health.contains(".") ? Double.parseDouble(health) : (double)Integer.parseInt(health);
        }
        catch (Throwable t) {
            return 2048.0;
        }
    }

    public static boolean isStatSavingDisabled() {
        try {
            return (Boolean)Class.forName("org.spigotmc.SpigotConfig").getField("disableStatSaving").get(null);
        }
        catch (ReflectiveOperationException ex) {
            try {
                YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)new File("spigot.yml"));
                return cfg.isSet("stats.disable-saving") ? cfg.getBoolean("stats.disable-saving") : false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    public static void catchAsync(String message) {
        try {
            Class.forName("org.spigotmc.AsyncCatcher").getMethod("catchOp", String.class).invoke(null, message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sneaky(Throwable throwable) {
        try {
            SneakyThrow.sneaky(throwable);
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError err) {
            throw new FoException(throwable);
        }
    }

    public static void setGameRule(World world, String gameRule, boolean value) {
        try {
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                GameRule rule = GameRule.getByName((String)gameRule);
                world.setGameRule(rule, (Object)value);
            } else {
                world.setGameRuleValue(gameRule, "" + value);
            }
        }
        catch (Throwable t) {
            Common.error(t, "Game rule " + gameRule + " not found.");
        }
    }

    public static boolean isPaper() {
        try {
            Bukkit.class.getMethod("getTPS", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isBungeeApiPresent() {
        return bungeeApiPresent;
    }

    public static boolean hasNewScoreboardAPI() {
        return newScoreboardAPI;
    }

    public static boolean hasParticleAPI() {
        return hasParticleAPI;
    }

    public static boolean hasBookEvent() {
        return hasBookEvent;
    }

    public static boolean hasScoreboardTags() {
        return hasScoreboardTags;
    }

    public static boolean hasSpawnEggMeta() {
        return hasSpawnEggMeta;
    }

    private static Player[] getPlayersLegacy() {
        try {
            return (Player[])getPlayersMethod.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    private static int getHealhLegacy(LivingEntity entity) {
        try {
            return (Integer)getHealthMethod.invoke((Object)entity, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    private static int getMaxHealhLegacy(LivingEntity entity) {
        try {
            Object number = LivingEntity.class.getMethod("getMaxHealth", new Class[0]).invoke((Object)entity, new Object[0]);
            if (number instanceof Double) {
                return ((Double)number).intValue();
            }
            if (number instanceof Integer) {
                return (Integer)number;
            }
            return (int)Double.parseDouble(number.toString());
        }
        catch (ReflectiveOperationException ex) {
            throw new FoException(ex, "Reflection malfunction");
        }
    }

    static {
        isGetPlayersCollection = false;
        isGetHealthDouble = false;
        hasExtendedPlayerTitleAPI = false;
        hasParticleAPI = true;
        newScoreboardAPI = true;
        hasBookEvent = true;
        hasInventoryLocation = true;
        hasScoreboardTags = true;
        hasSpawnEggMeta = true;
        hasAdvancements = true;
        bungeeApiPresent = true;
        cooldowns = new StrictMap();
        Valid.checkBoolean(MinecraftVersion.getCurrent().isTested(), "Your Minecraft version " + (Object)((Object)MinecraftVersion.getCurrent()) + " is unsupported by " + SimplePlugin.getNamed(), new Object[0]);
        try {
            ChatInternals.callStatic();
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
                NBTInternals.checkCompatible();
            }
            ((Object)((Object)ParticleInternals.ANGRY_VILLAGER)).getClass();
            for (Material material : Material.values()) {
                CompMaterial.fromString(material.toString());
            }
            for (CompMaterial compMaterial : CompMaterial.values()) {
                compMaterial.getMaterial();
            }
            ReflectionUtil.getNMSClass("Entity");
        }
        catch (Throwable throwable) {
            System.out.println("** COMPATIBILITY TEST FAILED - THIS PLUGIN WILL NOT FUNCTION **");
            System.out.println("** YOUR MINECRAFT VERSION APPEARS UNSUPPORTED: " + (Object)((Object)MinecraftVersion.getCurrent()) + " **");
            throwable.printStackTrace();
            System.out.println("***************************************************************");
            throw new FoException("(This is a proxy exception, look for errors above)");
        }
        try {
            try {
                Class.forName("org.bukkit.Sound");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Minecraft 1.2.5 is not supported.");
            }
            try {
                getHandle = ReflectionUtil.getOBCClass("entity.CraftPlayer").getMethod("getHandle", new Class[0]);
                fieldPlayerConnection = ReflectionUtil.getNMSClass("EntityPlayer").getField("playerConnection");
                sendPacket = ReflectionUtil.getNMSClass("PlayerConnection").getMethod("sendPacket", ReflectionUtil.getNMSClass("Packet"));
            }
            catch (Throwable throwable) {
                System.out.println("Unable to find setup some parts of reflection. Plugin will still function.");
                System.out.println("Error: " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
                System.out.println("Ignore this if using Cauldron. Otherwise check if your server is compatibible.");
                fieldPlayerConnection = null;
                sendPacket = null;
                getHandle = null;
            }
            getPlayersMethod = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]);
            isGetPlayersCollection = getPlayersMethod.getReturnType() == Collection.class;
            getHealthMethod = LivingEntity.class.getMethod("getHealth", new Class[0]);
            isGetHealthDouble = getHealthMethod.getReturnType() == Double.TYPE;
            hasExtendedPlayerTitleAPI = MinecraftVersion.atLeast(MinecraftVersion.V.v1_11);
            try {
                World.class.getMethod("spawnParticle", Particle.class, Location.class, Integer.TYPE);
            }
            catch (NoClassDefFoundError | ReflectiveOperationException throwable) {
                hasParticleAPI = false;
            }
            try {
                Class.forName("net.md_5.bungee.chat.ComponentSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bungeeApiPresent = false;
                throw new FoException("&cYour server version (&f" + Bukkit.getBukkitVersion().replace("-SNAPSHOT", "") + "&c) doesn't\n &cinclude &elibraries required&c for this plugin to\n &crun. Install the following plugin for compatibility:\n &fhttps://www.spigotmc.org/resources/38379");
            }
            try {
                Objective.class.getMethod("getScore", String.class);
            }
            catch (NoClassDefFoundError | NoSuchMethodException throwable) {
                newScoreboardAPI = false;
            }
            try {
                Class.forName("org.bukkit.event.player.PlayerEditBookEvent").getName();
            }
            catch (ClassNotFoundException classNotFoundException) {
                hasBookEvent = false;
            }
            try {
                Inventory.class.getMethod("getLocation", new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                hasInventoryLocation = false;
            }
            try {
                Entity.class.getMethod("getScoreboardTags", new Class[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                hasScoreboardTags = false;
            }
            try {
                Class.forName("org.bukkit.inventory.meta.SpawnEggMeta");
            }
            catch (ClassNotFoundException classNotFoundException) {
                hasSpawnEggMeta = false;
            }
            try {
                Class.forName("org.bukkit.advancement.Advancement");
                Class.forName("org.bukkit.NamespacedKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                hasAdvancements = false;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new UnsupportedOperationException("Failed to set up reflection, " + SimplePlugin.getNamed() + " won't work properly", reflectiveOperationException);
        }
    }

    public static class InteractiveTextFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private InteractiveTextFoundException() {
        }
    }
}

