/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.remain.NmsAccessor;

public final class NmsEntity {
    private final World bukkitWorld;
    private final Object nmsEntity;

    public NmsEntity(Class<?> entityClass) {
        this(new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0), entityClass);
    }

    public NmsEntity(Location location, Class<?> entityClass) {
        try {
            NmsAccessor.call();
        }
        catch (Throwable t) {
            throw new FoException(t, "Failed to setup entity reflection! MC version: " + (Object)((Object)MinecraftVersion.getCurrent()));
        }
        this.bukkitWorld = location.getWorld();
        this.nmsEntity = MinecraftVersion.equals(MinecraftVersion.V.v1_7) ? NmsEntity.getHandle(location, entityClass) : this.createEntity(location, entityClass);
    }

    private static Object getHandle(Location location, Class<?> entityClass) {
        Entity entity = new Location(location.getWorld(), -1.0, 0.0, -1.0).getWorld().spawn(location, entityClass);
        try {
            return entity.getClass().getMethod("getHandle", new Class[0]).invoke((Object)entity, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new Error(ex);
        }
    }

    private Object createEntity(Location location, Class<?> entityClass) {
        try {
            return NmsAccessor.createEntity.invoke((Object)this.bukkitWorld, location, entityClass);
        }
        catch (ReflectiveOperationException e) {
            throw new FoException(e, "Error creating entity " + entityClass + " at " + location);
        }
    }

    public <T extends Entity> T addEntity(CreatureSpawnEvent.SpawnReason reason) {
        try {
            return (T)((Entity)NmsAccessor.addEntity(this.bukkitWorld, this.nmsEntity, reason));
        }
        catch (ReflectiveOperationException e) {
            throw new FoException(e, "Error creating entity " + this.nmsEntity + " for " + reason);
        }
    }

    public Entity getBukkitEntity() {
        try {
            return (Entity)NmsAccessor.getBukkitEntity.invoke(this.nmsEntity, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new FoException(e, "Error getting bukkit entity from " + this.nmsEntity);
        }
    }

    public Object getNmsEntity() {
        return this.nmsEntity;
    }
}

