/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import java.lang.reflect.Method;
import org.apache.commons.lang.WordUtils;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.meta.ItemMeta;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.remain.nbt.NBTEntity;

public enum CompProperty {
    UNBREAKABLE(ItemMeta.class, Boolean.TYPE),
    GLOWING(Entity.class, Boolean.TYPE),
    AI(Entity.class, Boolean.TYPE),
    GRAVITY(Entity.class, Boolean.TYPE),
    SILENT(Entity.class, Boolean.TYPE),
    INVULNERABLE(Entity.class, Boolean.TYPE);

    private final Class<?> requiredClass;
    private final Class<?> setterMethodType;

    public final void apply(Object instance, Object key) {
        Valid.checkNotNull(instance, "instance is null!");
        Valid.checkBoolean(this.requiredClass.isAssignableFrom(instance.getClass()), (Object)((Object)this) + " accepts " + this.requiredClass.getSimpleName() + ", not " + instance.getClass().getSimpleName(), new Object[0]);
        try {
            Method m = this.getMethod(instance.getClass());
            m.setAccessible(true);
            m.invoke(instance, key);
        }
        catch (ReflectiveOperationException e) {
            if (e instanceof NoSuchMethodException && MinecraftVersion.olderThan(MinecraftVersion.V.values()[0])) {
                if (instance instanceof Entity) {
                    NBTEntity nbtEntity = new NBTEntity((Entity)instance);
                    boolean has = Boolean.parseBoolean(key.toString());
                    if (this == INVULNERABLE) {
                        nbtEntity.setInteger("Invulnerable", has ? 1 : 0);
                    } else if (this == AI) {
                        nbtEntity.setInteger("NoAI", has ? 0 : 1);
                    } else if (this == GRAVITY) {
                        nbtEntity.setInteger("NoGravity", has ? 0 : 1);
                    }
                }
            }
            e.printStackTrace();
        }
    }

    public final boolean isAvailable(Class<?> clazz) {
        block2: {
            try {
                this.getMethod(clazz);
            }
            catch (ReflectiveOperationException e) {
                if (!(e instanceof NoSuchMethodException) || !MinecraftVersion.olderThan(MinecraftVersion.V.values()[0])) break block2;
                return false;
            }
        }
        return true;
    }

    private final Method getMethod(Class<?> clazz) throws ReflectiveOperationException {
        return clazz.getMethod("set" + (this.toString().equals("AI") ? "AI" : WordUtils.capitalize((String)this.toString().toLowerCase())), this.setterMethodType);
    }

    private CompProperty(Class<?> requiredClass, Class<?> setterMethodType) {
        this.requiredClass = requiredClass;
        this.setterMethodType = setterMethodType;
    }

    public Class<?> getRequiredClass() {
        return this.requiredClass;
    }
}

