/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import java.lang.reflect.Method;
import lombok.NonNull;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.DataMap;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTItem;

public final class CompMonsterEgg {
    private static final String TAG = SimplePlugin.getNamed() + "_NbtTag";
    public static boolean acceptUnsafeEggs = false;

    private CompMonsterEgg() {
    }

    public static ItemStack makeEgg(EntityType type) {
        return CompMonsterEgg.makeEgg(type, 1);
    }

    public static ItemStack makeEgg(EntityType type, int count) {
        Valid.checkNotNull(type, "Entity type cannot be null!");
        ItemStack itemStack = new ItemStack(CompMaterial.makeMonsterEgg(type).getMaterial(), count);
        if (itemStack.getType().toString().equals("MONSTER_EGG")) {
            itemStack = CompMonsterEgg.setEntity(itemStack, type);
        }
        return itemStack;
    }

    public static EntityType getEntity(ItemStack item) {
        Valid.checkBoolean(CompMaterial.isMonsterEgg(item.getType()), "Item must be a monster egg not " + item, new Object[0]);
        EntityType type = null;
        type = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13) ? CompMonsterEgg.getTypeFromMaterial(item) : (Remain.hasSpawnEggMeta() ? CompMonsterEgg.getTypeByMeta(item) : CompMonsterEgg.getTypeByData(item));
        if (type == null) {
            type = CompMonsterEgg.getTypeByNbt(item);
        }
        if (type == null && acceptUnsafeEggs) {
            type = EntityType.UNKNOWN;
        }
        Valid.checkNotNull(type, "Could not detect monster type from " + item + " (data = " + item.getData() + ", dura = " + item.getDurability() + ")");
        return type;
    }

    private static EntityType getTypeFromMaterial(ItemStack item) {
        String name = item.getType().toString().replace("_SPAWN_EGG", "");
        EntityType type = null;
        try {
            type = EntityType.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            for (EntityType all : EntityType.values()) {
                if (all.getName() == null || !all.getName().equalsIgnoreCase(name)) continue;
                type = all;
            }
        }
        Valid.checkNotNull(type, "Unable to find EntityType from Material." + item.getType());
        return type;
    }

    private static EntityType getTypeByMeta(ItemStack item) {
        ItemMeta m = item.getItemMeta();
        return item.hasItemMeta() && m instanceof SpawnEggMeta ? ((SpawnEggMeta)m).getSpawnedType() : null;
    }

    private static EntityType getTypeByData(ItemStack item) {
        EntityType type = CompMonsterEgg.readEntity0(item);
        if (type == null) {
            if (item.getDurability() != 0) {
                type = DataMap.getEntity(item.getDurability());
            }
            if (type == null && item.getData().getData() != 0) {
                type = DataMap.getEntity(item.getData().getData());
            }
        }
        return type;
    }

    private static EntityType readEntity0(ItemStack item) {
        Valid.checkNotNull(item, "Reading entity got null item");
        NBTItem nbt = new NBTItem(item);
        String type = nbt.hasKey(TAG) != false ? nbt.getCompound(TAG).getString("entity") : null;
        return type != null && !type.isEmpty() ? EntityType.valueOf((String)type) : null;
    }

    private static EntityType getTypeByNbt(@NonNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        try {
            Class<?> NMSItemStackClass = ReflectionUtil.getNMSClass("ItemStack");
            Class<?> craftItemStackClass = ReflectionUtil.getOBCClass("inventory.CraftItemStack");
            Method asNMSCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            Object stack = asNMSCopyMethod.invoke(null, item);
            Object tagCompound = NMSItemStackClass.getMethod("getTag", new Class[0]).invoke(stack, new Object[0]);
            if (tagCompound == null && acceptUnsafeEggs) {
                return null;
            }
            Valid.checkNotNull(tagCompound, "Spawn egg lacks tag compound: " + item);
            Method tagGetCompound = tagCompound.getClass().getMethod("getCompound", String.class);
            Object entityTag = tagGetCompound.invoke(tagCompound, "EntityTag");
            Method tagGetString = entityTag.getClass().getMethod("getString", String.class);
            String idString = (String)tagGetString.invoke(entityTag, "id");
            if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_11) && idString.startsWith("minecraft:")) {
                idString = idString.split("minecraft:")[1];
            }
            EntityType type = EntityType.fromName((String)idString);
            return type;
        }
        catch (ReflectiveOperationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ItemStack setEntity(ItemStack item, EntityType type) {
        Valid.checkNotNull(item, "Item == null");
        Valid.checkBoolean(type.isSpawnable(), type + " cannot be spawned and thus set into a monster egg!", new Object[0]);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_13)) {
            item.setType(CompMaterial.makeMonsterEgg(type).getMaterial());
            return item;
        }
        Valid.checkBoolean(CompMaterial.isMonsterEgg(item.getType()), "Item must be a monster egg not " + item, new Object[0]);
        item = Remain.hasSpawnEggMeta() ? CompMonsterEgg.setTypeByMeta(item, type) : CompMonsterEgg.setTypeByData(item, type);
        return item;
    }

    private static ItemStack setTypeByMeta(ItemStack item, EntityType type) {
        SpawnEggMeta m = (SpawnEggMeta)item.getItemMeta();
        m.setSpawnedType(type);
        item.setItemMeta((ItemMeta)m);
        return item;
    }

    private static ItemStack setTypeByData(ItemStack item, EntityType type) {
        Integer data = DataMap.getData(type);
        if (data != -1) {
            item.setDurability(((Number)data).shortValue());
            item.getData().setData(((Number)data).byteValue());
            return CompMonsterEgg.writeEntity0(item, type);
        }
        if (!acceptUnsafeEggs) {
            throw new FoException("Could not set monster egg to " + type);
        }
        return item;
    }

    private static ItemStack writeEntity0(ItemStack item, EntityType type) {
        Valid.checkNotNull(item, "setting nbt got null item");
        Valid.checkNotNull(type, "setting nbt got null entity");
        NBTItem nbt = new NBTItem(item);
        NBTCompound tag = nbt.addCompound(TAG);
        tag.setString("entity", type.toString());
        return nbt.getItem();
    }
}

