/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.constants.FoConstants;
import org.mineacademy.fo.model.ConfigSerializable;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.remain.nbt.NBTCompound;
import org.mineacademy.fo.remain.nbt.NBTItem;
import org.mineacademy.fo.settings.YamlSectionConfig;

public final class CompMetadata {
    private static final String DELIMITER = "%-%";

    private CompMetadata() {
    }

    public static ItemStack setMetadata(ItemStack item, String key, String value) {
        Valid.checkNotNull(item, "Setting NBT tag got null item");
        NBTItem nbt = new NBTItem(item);
        NBTCompound tag = nbt.addCompound(FoConstants.NBT.TAG);
        tag.setString(key, value);
        return nbt.getItem();
    }

    public static void setMetadata(Entity entity, String tag) {
        CompMetadata.setMetadata(entity, tag, tag);
    }

    public static void setMetadata(Entity entity, String key, String value) {
        Valid.checkNotNull(entity);
        String tag = CompMetadata.format(key, value);
        if (Remain.hasScoreboardTags()) {
            if (!entity.getScoreboardTags().contains(tag)) {
                entity.addScoreboardTag(tag);
            }
        } else {
            entity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
            MetadataFile.getInstance().addMetadata(entity, key, value);
        }
    }

    private static String format(String key, String value) {
        return SimplePlugin.getNamed() + DELIMITER + key + DELIMITER + value;
    }

    public static void setMetadata(BlockState tileEntity, String key, String value) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        Valid.checkNotNull(value);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            CompMetadata.setNamedspaced((TileState)tileEntity, key, value);
            tileEntity.update();
        } else {
            tileEntity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
            tileEntity.update();
            MetadataFile.getInstance().addMetadata(tileEntity, key, value);
        }
    }

    private static void setNamedspaced(TileState tile, String key, String value) {
        tile.getPersistentDataContainer().set(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING, (Object)value);
    }

    public static String getMetadata(ItemStack item, String key) {
        Valid.checkNotNull(item, "Reading NBT tag got null item");
        String compoundTag = FoConstants.NBT.TAG;
        NBTItem nbt = new NBTItem(item);
        String value = nbt.hasKey(compoundTag) != false ? nbt.getCompound(compoundTag).getString(key) : null;
        return Common.getOrNull(value);
    }

    public static String getMetadata(Entity entity, String key) {
        Valid.checkNotNull(entity);
        if (Remain.hasScoreboardTags()) {
            for (String line : entity.getScoreboardTags()) {
                String tag = CompMetadata.getTag(line, key);
                if (tag == null || tag.isEmpty()) continue;
                return tag;
            }
        }
        String value = entity.hasMetadata(key) ? ((MetadataValue)entity.getMetadata(key).get(0)).asString() : null;
        return Common.getOrNull(value);
    }

    private static String getTag(String raw, String key) {
        String[] parts = raw.split(DELIMITER);
        return parts.length == 3 && parts[0].equals(SimplePlugin.getNamed()) && parts[1].equals(key) ? parts[2] : null;
    }

    public static String getMetadata(BlockState tileEntity, String key) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            return CompMetadata.getNamedspaced((TileState)tileEntity, key);
        }
        String value = tileEntity.hasMetadata(key) ? ((MetadataValue)tileEntity.getMetadata(key).get(0)).asString() : null;
        return Common.getOrNull(value);
    }

    private static String getNamedspaced(TileState tile, String key) {
        String value = (String)tile.getPersistentDataContainer().get(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING);
        return Common.getOrNull(value);
    }

    public static boolean hasMetadata(ItemStack item, String key) {
        Valid.checkNotNull(item);
        NBTItem nbt = new NBTItem(item);
        NBTCompound tag = nbt.getCompound(FoConstants.NBT.TAG);
        return tag != null && tag.hasKey(key) != false;
    }

    public static boolean hasMetadata(Entity entity, String key) {
        Valid.checkNotNull(entity);
        if (Remain.hasScoreboardTags()) {
            for (String line : entity.getScoreboardTags()) {
                if (!CompMetadata.hasTag(line, key)) continue;
                return true;
            }
        }
        return entity.hasMetadata(key);
    }

    public static boolean hasMetadata(BlockState tileEntity, String key) {
        Valid.checkNotNull(tileEntity);
        Valid.checkNotNull(key);
        if (MinecraftVersion.atLeast(MinecraftVersion.V.v1_14)) {
            Valid.checkBoolean(tileEntity instanceof TileState, "BlockState must be instance of a TileState not " + tileEntity, new Object[0]);
            return CompMetadata.hasNamedspaced((TileState)tileEntity, key);
        }
        return tileEntity.hasMetadata(key);
    }

    private static boolean hasNamedspaced(TileState tile, String key) {
        return tile.getPersistentDataContainer().has(new NamespacedKey((Plugin)SimplePlugin.getInstance(), key), PersistentDataType.STRING);
    }

    private static boolean hasTag(String raw, String tag) {
        String[] parts = raw.split(DELIMITER);
        return parts.length == 3 && parts[0].equals(SimplePlugin.getNamed()) && parts[1].equals(tag);
    }

    public static void setTempMetadata(Entity entity, String tag) {
        entity.setMetadata(CompMetadata.createTempMetadataKey(tag), (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)tag));
    }

    public static void setTempMetadata(Entity entity, String tag, Object key) {
        entity.setMetadata(CompMetadata.createTempMetadataKey(tag), (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), key));
    }

    public static MetadataValue getTempMetadata(Entity entity, String tag) {
        String key = CompMetadata.createTempMetadataKey(tag);
        return entity.hasMetadata(key) ? (MetadataValue)entity.getMetadata(key).get(0) : null;
    }

    public static boolean hasTempMetadata(Entity player, String tag) {
        return player.hasMetadata(CompMetadata.createTempMetadataKey(tag));
    }

    public static void removeTempMetadata(Entity player, String tag) {
        String key = CompMetadata.createTempMetadataKey(tag);
        if (player.hasMetadata(key)) {
            player.removeMetadata(key, (Plugin)SimplePlugin.getInstance());
        }
    }

    private static String createTempMetadataKey(String tag) {
        return SimplePlugin.getNamed() + "_" + tag;
    }

    public static final class MetadataFile
    extends YamlSectionConfig {
        private static volatile Object LOCK = new Object();
        private static final MetadataFile instance = new MetadataFile();
        private final StrictMap<UUID, List<String>> entityMetadataMap = new StrictMap();
        private final StrictMap<Location, BlockCache> blockMetadataMap = new StrictMap();

        private MetadataFile() {
            super("Metadata");
            this.loadConfiguration(NO_DEFAULT, "data.db");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onLoadFinish() {
            Object object = LOCK;
            synchronized (object) {
                this.loadEntities();
                this.loadBlockStates();
                this.save();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadEntities() {
            Object object = LOCK;
            synchronized (object) {
                this.entityMetadataMap.clear();
                for (String uuidName : this.getMap("Entity").keySet()) {
                    UUID uuid = UUID.fromString(uuidName);
                    if (!(this.getObject("Entity." + uuidName) instanceof List)) {
                        this.setNoSave("Entity." + uuidName, null);
                        continue;
                    }
                    List<String> metadata = this.getStringList("Entity." + uuidName);
                    Entity entity = Remain.getEntity(uuid);
                    if (metadata.isEmpty() || entity == null || !entity.isValid() || entity.isDead()) continue;
                    this.entityMetadataMap.put(uuid, metadata);
                    this.applySavedMetadata(metadata, (Metadatable)entity);
                }
                this.setNoSave("Entity", this.entityMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadBlockStates() {
            Object object = LOCK;
            synchronized (object) {
                this.blockMetadataMap.clear();
                for (String locationRaw : this.getMap("Block").keySet()) {
                    Location location = SerializeUtil.deserializeLocation(locationRaw);
                    BlockCache blockCache = this.get("Block." + locationRaw, BlockCache.class);
                    Block block = location.getBlock();
                    if (CompMaterial.isAir(block) || CompMaterial.fromBlock(block) != blockCache.getType()) continue;
                    this.blockMetadataMap.put(location, blockCache);
                    this.applySavedMetadata(blockCache.getMetadata(), (Metadatable)block);
                }
                this.setNoSave("Block", this.blockMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applySavedMetadata(List<String> metadata, Metadatable entity) {
            Object object = LOCK;
            synchronized (object) {
                for (String metadataLine : metadata) {
                    if (metadataLine.isEmpty()) continue;
                    String[] lines = metadataLine.split(CompMetadata.DELIMITER);
                    Valid.checkBoolean(lines.length == 3, "Malformed metadata line for " + entity + ". Length 3 != " + lines.length + ". Data: " + metadataLine, new Object[0]);
                    String key = lines[1];
                    String value = lines[2];
                    entity.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SimplePlugin.getInstance(), (Object)value));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMetadata(Entity entity, @NonNull String key, String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            Object object = LOCK;
            synchronized (object) {
                List metadata = this.entityMetadataMap.getOrPut(entity.getUniqueId(), new ArrayList());
                Iterator i = metadata.iterator();
                while (i.hasNext()) {
                    String meta = (String)i.next();
                    if (CompMetadata.getTag(meta, key) == null) continue;
                    i.remove();
                }
                if (value != null && !value.isEmpty()) {
                    String formatted = CompMetadata.format(key, value);
                    metadata.add(formatted);
                }
                this.save("Entity", this.entityMetadataMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMetadata(BlockState blockState, String key, String value) {
            Object object = LOCK;
            synchronized (object) {
                BlockCache blockCache = this.blockMetadataMap.getOrPut(blockState.getLocation(), new BlockCache(CompMaterial.fromBlock(blockState.getBlock()), new ArrayList<String>()));
                Iterator<String> i = blockCache.getMetadata().iterator();
                while (i.hasNext()) {
                    String meta = i.next();
                    if (CompMetadata.getTag(meta, key) == null) continue;
                    i.remove();
                }
                if (value != null && !value.isEmpty()) {
                    String formatted = CompMetadata.format(key, value);
                    blockCache.getMetadata().add(formatted);
                }
                for (Map.Entry<Location, BlockCache> entry : this.blockMetadataMap.entrySet()) {
                    this.setNoSave("Block." + SerializeUtil.serializeLoc(entry.getKey()), entry.getValue().serialize());
                }
                this.save();
            }
        }

        public static MetadataFile getInstance() {
            return instance;
        }

        public static final class BlockCache
        implements ConfigSerializable {
            private final CompMaterial type;
            private final List<String> metadata;

            public static BlockCache deserialize(SerializedMap map) {
                CompMaterial type = map.getMaterial("Type");
                List<String> metadata = map.getStringList("Metadata");
                return new BlockCache(type, metadata);
            }

            @Override
            public SerializedMap serialize() {
                SerializedMap map = new SerializedMap();
                map.put("Type", this.type.toString());
                map.put("Metadata", this.metadata);
                return map;
            }

            public CompMaterial getType() {
                return this.type;
            }

            public List<String> getMetadata() {
                return this.metadata;
            }

            public BlockCache(CompMaterial type, List<String> metadata) {
                this.type = type;
                this.metadata = metadata;
            }
        }
    }
}

