/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.remain.CompMaterial;

public enum CompColor {
    BLUE(DyeColor.BLUE),
    BLACK(DyeColor.BLACK),
    DARK_AQUA(DyeColor.CYAN),
    DARK_BLUE(DyeColor.BLUE),
    AQUA(DyeColor.LIGHT_BLUE),
    GRAY(CompColor.getEnum("LIGHT_GRAY", "SILVER", DyeColor.class), null, "SILVER"),
    DARK_GRAY(DyeColor.GRAY),
    DARK_GREEN(DyeColor.GREEN),
    GREEN(DyeColor.LIME),
    GOLD(DyeColor.ORANGE),
    BROWN(DyeColor.BROWN, ChatColor.GOLD),
    DARK_RED(DyeColor.RED),
    RED(DyeColor.RED),
    WHITE(DyeColor.WHITE),
    YELLOW(DyeColor.YELLOW),
    DARK_PURPLE(DyeColor.PURPLE),
    LIGHT_PURPLE(DyeColor.MAGENTA),
    PINK(DyeColor.PINK, ChatColor.LIGHT_PURPLE);

    private final DyeColor dye;
    private final ChatColor chatColor;
    private final String legacyName;

    private CompColor(DyeColor dye) {
        this(dye, null);
    }

    private CompColor(DyeColor dye, ChatColor chatColor) {
        this(dye, chatColor, null);
    }

    private CompColor(DyeColor dye, ChatColor chatColor, String legacyName) {
        this.dye = dye;
        this.chatColor = chatColor == null ? ChatColor.valueOf((String)this.toString()) : chatColor;
        this.legacyName = Common.getOrEmpty(legacyName);
    }

    private static <T extends Enum<T>> T getEnum(String newName, String oldName, Class<T> clazz) {
        T en = ReflectionUtil.lookupEnumSilent(clazz, newName);
        if (en == null) {
            en = ReflectionUtil.lookupEnumSilent(clazz, oldName);
        }
        return en;
    }

    public static final CompColor fromWoolData(byte data) {
        return CompColor.fromDye(DyeColor.getByWoolData((byte)data));
    }

    public static final CompColor fromName(String name) {
        name = name.toUpperCase();
        for (CompColor comp : CompColor.values()) {
            if (!comp.chatColor.toString().equals(name) && !comp.dye.toString().equals(name) && !comp.legacyName.equals(name)) continue;
            return comp;
        }
        throw new FoException("Could not get CompColor from name: " + name);
    }

    public static final CompColor fromDye(DyeColor dye) {
        for (CompColor comp : CompColor.values()) {
            if (comp.dye != dye && !comp.legacyName.equals(dye.toString())) continue;
            return comp;
        }
        throw new FoException("Could not get CompColor from DyeColor." + dye.toString());
    }

    public static final CompColor fromChatColor(ChatColor color) {
        for (CompColor comp : CompColor.values()) {
            if (comp.chatColor != color && !comp.legacyName.equals(color.toString())) continue;
            return comp;
        }
        throw new FoException("Could not get CompColor from ChatColor." + color.name());
    }

    public static final DyeColor toDye(ChatColor color) {
        CompColor c = ReflectionUtil.lookupEnumSilent(CompColor.class, color.name());
        return c != null ? c.getDye() : DyeColor.WHITE;
    }

    public static final ChatColor toColor(DyeColor dye) {
        for (CompColor c : CompColor.values()) {
            if (c.getDye() != dye) continue;
            return c.getChatColor();
        }
        return ChatColor.WHITE;
    }

    public static final CompMaterial toConcrete(ChatColor color) {
        CompMaterial wool = CompColor.toWool(color);
        return CompMaterial.fromString(wool.toString().replace("_WOOL", MinecraftVersion.olderThan(MinecraftVersion.V.v1_12) ? "_STAINED_GLASS" : "_CONCRETE"));
    }

    public static final CompMaterial toWool(ChatColor color) {
        CompColor comp = CompColor.fromChatColor(color);
        switch (comp) {
            case AQUA: {
                return CompMaterial.LIGHT_BLUE_WOOL;
            }
            case BLACK: {
                return CompMaterial.BLACK_WOOL;
            }
            case BLUE: {
                return CompMaterial.BLUE_WOOL;
            }
            case BROWN: {
                return CompMaterial.BROWN_WOOL;
            }
            case DARK_AQUA: {
                return CompMaterial.CYAN_WOOL;
            }
            case DARK_BLUE: {
                return CompMaterial.BLUE_WOOL;
            }
            case DARK_GRAY: {
                return CompMaterial.GRAY_WOOL;
            }
            case DARK_GREEN: {
                return CompMaterial.GREEN_WOOL;
            }
            case DARK_PURPLE: {
                return CompMaterial.PURPLE_WOOL;
            }
            case DARK_RED: {
                return CompMaterial.RED_WOOL;
            }
            case GOLD: {
                return CompMaterial.ORANGE_WOOL;
            }
            case GRAY: {
                return CompMaterial.LIGHT_GRAY_WOOL;
            }
            case GREEN: {
                return CompMaterial.LIME_WOOL;
            }
            case LIGHT_PURPLE: {
                return CompMaterial.MAGENTA_WOOL;
            }
            case PINK: {
                return CompMaterial.PINK_WOOL;
            }
            case RED: {
                return CompMaterial.RED_WOOL;
            }
            case WHITE: {
                return CompMaterial.WHITE_WOOL;
            }
            case YELLOW: {
                return CompMaterial.YELLOW_WOOL;
            }
        }
        return CompMaterial.WHITE_WOOL;
    }

    public static final List<ChatColor> getChatColors() {
        ArrayList<ChatColor> list = new ArrayList<ChatColor>();
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor() || color.isFormat()) continue;
            list.add(color);
        }
        return list;
    }

    public DyeColor getDye() {
        return this.dye;
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }
}

