/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.remain;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;

class BungeeChatProvider {
    BungeeChatProvider() {
    }

    static void sendComponent(CommandSender sender, Object comps) {
        if (comps instanceof TextComponent) {
            BungeeChatProvider.sendComponent0(sender, new BaseComponent[]{(TextComponent)comps});
        } else {
            BungeeChatProvider.sendComponent0(sender, (BaseComponent[])comps);
        }
    }

    private static void sendComponent0(CommandSender sender, BaseComponent ... comps) {
        StringBuilder plainMessage = new StringBuilder();
        for (BaseComponent comp : comps) {
            plainMessage.append(comp.toLegacyText().replaceAll("\u00a7x", ""));
        }
        if (!(sender instanceof Player)) {
            BungeeChatProvider.tell0(sender, plainMessage.toString());
            return;
        }
        try {
            ((Player)sender).spigot().sendMessage(comps);
        }
        catch (NoClassDefFoundError | NoSuchMethodError ex) {
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_7)) {
                Common.error(ex, "Error printing JSON message, sending as plain.");
            }
            BungeeChatProvider.tell0(sender, plainMessage.toString());
        }
        catch (Exception ex) {
            BungeeChatProvider.tell0(sender, plainMessage.toString());
        }
    }

    private static void tell0(CommandSender sender, String msg) {
        Valid.checkNotNull(sender, "Sender cannot be null");
        if (msg.isEmpty() || "none".equals(msg)) {
            return;
        }
        String stripped = msg.startsWith("[JSON]") ? msg.replaceFirst("\\[JSON\\]", "").trim() : msg;
        for (String part : stripped.split("\n")) {
            sender.sendMessage(part);
        }
    }
}

