/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.plugin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.bungee.SimpleBungee;
import org.mineacademy.fo.collection.StrictList;
import org.mineacademy.fo.command.SimpleCommand;
import org.mineacademy.fo.command.SimpleCommandGroup;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.event.SimpleListener;
import org.mineacademy.fo.exception.FoException;
import org.mineacademy.fo.menu.Menu;
import org.mineacademy.fo.menu.MenuListener;
import org.mineacademy.fo.menu.tool.Rocket;
import org.mineacademy.fo.menu.tool.Tool;
import org.mineacademy.fo.menu.tool.ToolsListener;
import org.mineacademy.fo.metrics.Metrics;
import org.mineacademy.fo.model.DiscordListener;
import org.mineacademy.fo.model.EnchantmentListener;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.model.JavaScriptExecutor;
import org.mineacademy.fo.model.SimpleEnchantment;
import org.mineacademy.fo.model.SimpleScoreboard;
import org.mineacademy.fo.model.SpigotUpdater;
import org.mineacademy.fo.plugin.FoundationListener;
import org.mineacademy.fo.plugin.FoundationPacketListener;
import org.mineacademy.fo.plugin.Reloadables;
import org.mineacademy.fo.remain.CompMetadata;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.SimpleLocalization;
import org.mineacademy.fo.settings.SimpleSettings;
import org.mineacademy.fo.settings.YamlConfig;
import org.mineacademy.fo.settings.YamlStaticConfig;
import org.mineacademy.fo.visual.BlockVisualizer;

public abstract class SimplePlugin
extends JavaPlugin
implements Listener {
    private static volatile boolean reloading = false;
    private static volatile SimplePlugin instance;
    protected boolean isEnabled = true;
    private final Reloadables reloadables = new Reloadables();
    private boolean startingReloadables = false;

    public static SimplePlugin getInstance() {
        if (instance == null) {
            instance = (SimplePlugin)JavaPlugin.getPlugin(SimplePlugin.class);
            Objects.requireNonNull(instance, "Cannot get a new instance! Have you reloaded?");
        }
        return instance;
    }

    public static final String getVersion() {
        return SimplePlugin.getInstance().getDescription().getVersion();
    }

    public static final String getNamed() {
        return SimplePlugin.hasInstance() ? SimplePlugin.getInstance().getName() : "No instance yet";
    }

    public static final File getSource() {
        return SimplePlugin.getInstance().getFile();
    }

    public static final File getData() {
        return SimplePlugin.getInstance().getDataFolder();
    }

    public static final boolean isMainCommand(String label) {
        return SimplePlugin.getInstance().getMainCommand() != null && SimplePlugin.getInstance().getMainCommand().getLabel().equals(label);
    }

    public static final boolean hasInstance() {
        return instance != null;
    }

    public final void onLoad() {
        try {
            SimplePlugin.getInstance();
        }
        catch (Throwable ex) {
            if (MinecraftVersion.olderThan(MinecraftVersion.V.v1_7)) {
                instance = this;
            }
            throw ex;
        }
        this.onPluginLoad();
    }

    public final void onEnable() {
        this.checkShading();
        if (!this.isEnabled) {
            return;
        }
        if (!this.checkLibraries0() || !this.checkServerVersions0()) {
            this.isEnabled = false;
            this.setEnabled(false);
            return;
        }
        Debugger.detectDebugMode();
        if (this.getStartupLogo() != null) {
            Common.ADD_LOG_PREFIX = false;
        }
        this.onPluginPreStart();
        if (!this.isEnabled || !this.isEnabled()) {
            return;
        }
        if (this.getStartupLogo() != null) {
            boolean hadLogPrefix = Common.ADD_LOG_PREFIX;
            Common.ADD_LOG_PREFIX = false;
            Common.log(this.getStartupLogo());
            Common.ADD_LOG_PREFIX = hadLogPrefix;
        }
        try {
            if (this.getSettings() != null) {
                YamlStaticConfig.load(this.getSettings());
                Valid.checkBoolean(SimpleSettings.isSettingsCalled() != null && SimpleLocalization.isLocalizationCalled() != null, "Developer forgot to call Settings or Localization", new Object[0]);
            }
            if (!this.isEnabled || !this.isEnabled()) {
                return;
            }
            SimplePlugin.checkSingletons();
            try {
                HookManager.loadDependencies();
            }
            catch (Throwable throwable) {
                Common.throwError(throwable, "Error while loading " + this.getName() + " dependencies!");
            }
            if (!this.isEnabled || !this.isEnabled()) {
                return;
            }
            CompMetadata.MetadataFile.getInstance();
            if (this.getMainCommand() != null) {
                Valid.checkBoolean(!SimpleSettings.MAIN_COMMAND_ALIASES.isEmpty(), "Please make a settings class extending SimpleSettings and specify Command_Aliases in your settings file.", new Object[0]);
                this.getMainCommand().register(SimpleSettings.MAIN_COMMAND_ALIASES);
            }
            this.startingReloadables = true;
            this.onReloadablesStart();
            this.startingReloadables = false;
            this.onPluginStart();
            if (!this.isEnabled || !this.isEnabled()) {
                return;
            }
            this.registerBungeeCord();
            if (this.getUpdateCheck() != null) {
                this.getUpdateCheck().run();
            }
            this.registerEvents(this);
            this.registerEvents(new MenuListener());
            this.registerEvents(new FoundationListener());
            this.registerEvents(new ToolsListener());
            this.registerEvents(new EnchantmentListener());
            FoundationPacketListener.addPacketListener();
            if (HookManager.isDiscordSRVLoaded()) {
                this.reloadables.registerEvents(new DiscordListener.DiscordListenerImpl());
            }
            Common.setTellPrefix(SimpleSettings.PLUGIN_PREFIX);
            int pluginId = this.getMetricsPluginId();
            if (pluginId != -1) {
                new Metrics((Plugin)this, pluginId);
            }
            JavaScriptExecutor.run("");
        }
        catch (Throwable t) {
            this.displayError0(t);
        }
    }

    private final void registerBungeeCord() {
        Messenger messenger = this.getServer().getMessenger();
        SimpleBungee bungee = this.getBungeeCord();
        if (bungee != null) {
            messenger.registerIncomingPluginChannel((Plugin)this, bungee.getChannel(), (PluginMessageListener)bungee.getListener());
            messenger.registerOutgoingPluginChannel((Plugin)this, bungee.getChannel());
            this.reloadables.registerEvents(bungee.getListener());
            Debugger.debug("bungee", "Registered BungeeCord listener for " + bungee.getChannel());
        }
    }

    private static void checkSingletons() {
        try (JarFile file = new JarFile(SimplePlugin.getSource());){
            Enumeration<JarEntry> entry = file.entries();
            while (entry.hasMoreElements()) {
                JarEntry jar = entry.nextElement();
                String name = jar.getName().replace("/", ".");
                try {
                    boolean isEnchant;
                    if (!name.endsWith(".class")) continue;
                    String className = name.substring(0, name.length() - 6);
                    Class<?> clazz = null;
                    try {
                        clazz = SimplePlugin.class.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError error) {
                        continue;
                    }
                    boolean isTool = Tool.class.isAssignableFrom(clazz) && !Tool.class.equals(clazz) && !Rocket.class.equals(clazz);
                    boolean bl = isEnchant = SimpleEnchantment.class.isAssignableFrom(clazz) && !SimpleEnchantment.class.equals(clazz);
                    if (!isTool && !isEnchant) continue;
                    if (isEnchant && MinecraftVersion.olderThan(MinecraftVersion.V.v1_13)) {
                        System.out.println("**** WARNING ****");
                        System.out.println("SimpleEnchantment requires Minecraft 1.13.2 or greater. The following class will not be registered: " + clazz.getName());
                        continue;
                    }
                    try {
                        Field instanceField = null;
                        for (Field field : clazz.getDeclaredFields()) {
                            if (!Tool.class.isAssignableFrom(field.getType()) && !Enchantment.class.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                            instanceField = field;
                        }
                        if (SimpleEnchantment.class.isAssignableFrom(clazz)) {
                            Valid.checkNotNull(instanceField, "Your enchant class " + clazz.getSimpleName() + " must be a singleton and have static 'instance' field and private constructors!");
                        }
                        if (instanceField == null) continue;
                        instanceField.setAccessible(true);
                        Object instance = instanceField.get(null);
                        for (Constructor<?> con : instance.getClass().getDeclaredConstructors()) {
                            Valid.checkBoolean(Modifier.isPrivate(con.getModifiers()), "Constructor " + con + " not private! Did you put '@NoArgsConstructor(access = AccessLevel.PRIVATE)' in your tools class?", new Object[0]);
                        }
                        if (!(instance instanceof Listener)) continue;
                        Common.registerEvents((Listener)instance);
                    }
                    catch (NoSuchFieldError instanceField) {
                    }
                    catch (Throwable t) {
                        String error = Common.getOrEmpty(t.getMessage());
                        if (t instanceof NoClassDefFoundError && error.contains("org/bukkit/entity")) {
                            System.out.println("**** WARNING ****");
                            if (error.contains("DragonFireball")) {
                                System.out.println("Your Minecraft version does not have DragonFireball class, we suggest replacing it with a Fireball instead in: " + clazz);
                                continue;
                            }
                            System.out.println("Your Minecraft version does not have " + error + " class you call in: " + clazz);
                            continue;
                        }
                        Common.error(t, "Failed to register events in " + clazz.getSimpleName() + " class " + clazz);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof VerifyError) continue;
                    Common.error(t, "Failed to scan class '" + name + "' using Foundation!");
                }
            }
        }
        catch (Throwable t) {
            Common.error(t, "Failed to scan classes using Foundation!");
        }
    }

    private final void checkShading() {
        try {
            throw new ShadingException();
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private final boolean checkLibraries0() {
        boolean md_5 = false;
        boolean gson = false;
        try {
            Class.forName("net.md_5.bungee.api.chat.BaseComponent");
            md_5 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.google.gson.JsonSyntaxException");
            gson = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!md_5 || !gson) {
            System.out.println("==================================================");
            System.out.println("Your Minecraft version (" + (Object)((Object)MinecraftVersion.getCurrent()) + ")");
            System.out.println("lacks libraries " + this.getName() + " needs:");
            System.out.println("JSON Chat (by md_5) found: " + md_5);
            System.out.println("Gson (by Google) found: " + gson);
            System.out.println(" ");
            System.out.println("To fix that, please install BungeeChatAPI:");
            System.out.println("https://www.spigotmc.org/resources/38379/");
            System.out.println("==================================================");
            return false;
        }
        return true;
    }

    private final boolean checkServerVersions0() {
        if (!MinecraftVersion.getCurrent().isTested()) {
            System.out.println(Common.consoleLine());
            System.out.println("** Your Minecraft version " + (Object)((Object)MinecraftVersion.getCurrent()) + " has not yet");
            System.out.println("been officialy tested with the Foundation");
            System.out.println("library that powers the " + SimplePlugin.getNamed() + " plugin.");
            System.out.println(" ");
            System.out.println("For your safety, the plugin is now disabled.");
            System.out.println(Common.consoleLine());
            return false;
        }
        MinecraftVersion.V minimumVersion = this.getMinimumVersion();
        if (minimumVersion != null && MinecraftVersion.olderThan(minimumVersion)) {
            Common.logFramed(false, this.getName() + " requires Minecraft " + (Object)((Object)minimumVersion) + " or newer to run.", "Please upgrade your server.");
            return false;
        }
        MinecraftVersion.V maximumVersion = this.getMaximumVersion();
        if (maximumVersion != null && MinecraftVersion.newerThan(maximumVersion)) {
            Common.logFramed(false, this.getName() + " requires Minecraft " + (Object)((Object)maximumVersion) + " or older to run.", "Please downgrade your server or", "wait for the new version.");
            return false;
        }
        return true;
    }

    protected final void displayError0(Throwable throwable) {
        Debugger.printStackTrace(throwable);
        Common.log("&c  _   _                       _ ", "&c  | | | | ___   ___  _ __  ___| |", "&c  | |_| |/ _ \\ / _ \\| '_ \\/ __| |", "&c  |  _  | (_) | (_) | |_) \\__ \\_|", "&4  |_| |_|\\___/ \\___/| .__/|___(_)", "&4                    |_|          ", "&4!-----------------------------------------------------!", " &cError loading " + this.getDescription().getName() + " v" + this.getDescription().getVersion() + ", plugin is disabled!", " &cRunning on " + this.getServer().getBukkitVersion() + " (" + MinecraftVersion.getServerVersion() + ") & Java " + System.getProperty("java.version"), "&4!-----------------------------------------------------!");
        if (throwable instanceof InvalidConfigurationException) {
            Common.log(" &cSeems like your config is not a valid YAML.");
            Common.log(" &cUse online services like");
            Common.log(" &chttp://yaml-online-parser.appspot.com/");
            Common.log(" &cto check for syntax errors!");
        } else if (throwable instanceof UnsupportedOperationException || throwable.getCause() != null && throwable.getCause() instanceof UnsupportedOperationException) {
            if (this.getServer().getBukkitVersion().startsWith("1.2.5")) {
                Common.log(" &cSorry but Minecraft 1.2.5 is no longer supported!");
            } else {
                Common.log(" &cUnable to setup reflection!");
                Common.log(" &cYour server is either too old or");
                Common.log(" &cthe plugin broke on the new version :(");
            }
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String error = "Unable to get the error message, search above.";
        if (throwable.getMessage() != null && !throwable.getMessage().isEmpty() && !throwable.getMessage().equals("null")) {
            error = throwable.getMessage();
        }
        Common.log(" &cError: " + error);
        Common.log("&4!-----------------------------------------------------!");
        this.getPluginLoader().disablePlugin((Plugin)this);
    }

    public final void onDisable() {
        if (!this.isEnabled) {
            return;
        }
        try {
            this.onPluginStop();
        }
        catch (Throwable t) {
            Common.log("&cPlugin might not shut down property. Got " + t.getClass().getSimpleName() + ": " + t.getMessage());
        }
        this.unregisterReloadables();
        try {
            for (Player player : Remain.getOnlinePlayers()) {
                SimpleScoreboard.clearBoardsFor(player);
            }
        }
        catch (Throwable t) {
            Common.log("Error clearing scoreboards for players..");
            t.printStackTrace();
        }
        try {
            for (Player player : Remain.getOnlinePlayers()) {
                Menu menu = Menu.getMenu(player);
                if (menu == null) continue;
                player.closeInventory();
            }
        }
        catch (Throwable t) {
            Common.log("Error closing menu inventories for players..");
            t.printStackTrace();
        }
        Objects.requireNonNull(instance, "Instance of " + this.getName() + " already nulled!");
        instance = null;
    }

    protected void onPluginLoad() {
    }

    protected void onPluginPreStart() {
    }

    protected abstract void onPluginStart();

    protected void onPluginStop() {
    }

    protected void onPluginPreReload() {
    }

    protected void onPluginReload() {
    }

    protected void onReloadablesStart() {
    }

    public final void reload() {
        boolean hadLogPrefix = Common.ADD_LOG_PREFIX;
        Common.ADD_LOG_PREFIX = false;
        Common.log(Common.consoleLineSmooth());
        Common.log(" ");
        Common.log("Reloading plugin " + this.getName() + " v" + SimplePlugin.getVersion());
        Common.log(" ");
        reloading = true;
        try {
            Debugger.detectDebugMode();
            this.unregisterReloadables();
            this.onPluginPreReload();
            this.reloadables.reload();
            YamlConfig.clearLoadedFiles();
            if (this.getSettings() != null) {
                YamlStaticConfig.load(this.getSettings());
            }
            FoundationPacketListener.addPacketListener();
            Common.setTellPrefix(SimpleSettings.PLUGIN_PREFIX);
            this.onPluginReload();
            if (this.getMainCommand() != null) {
                this.getMainCommand().register(SimpleSettings.MAIN_COMMAND_ALIASES);
            }
            this.startingReloadables = true;
            this.onReloadablesStart();
            this.startingReloadables = false;
            this.registerBungeeCord();
        }
        catch (Throwable t) {
            try {
                Common.throwError(t, "Error reloading " + this.getName() + " " + SimplePlugin.getVersion());
            }
            catch (Throwable throwable) {
                Common.log(Common.consoleLineSmooth());
                Common.ADD_LOG_PREFIX = hadLogPrefix;
                reloading = false;
                throw throwable;
            }
            Common.log(Common.consoleLineSmooth());
            Common.ADD_LOG_PREFIX = hadLogPrefix;
            reloading = false;
        }
        Common.log(Common.consoleLineSmooth());
        Common.ADD_LOG_PREFIX = hadLogPrefix;
        reloading = false;
    }

    private final void unregisterReloadables() {
        SimpleSettings.resetSettingsCall();
        SimpleLocalization.resetLocalizationCall();
        BlockVisualizer.stopAll();
        if (this.getMainCommand() != null && this.getMainCommand().isRegistered()) {
            this.getMainCommand().unregister();
        }
        try {
            HookManager.unloadDependencies((Plugin)this);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected final void registerEventsIf(Listener listener, boolean condition) {
        if (condition) {
            if (this.startingReloadables) {
                this.reloadables.registerEvents(listener);
            } else {
                this.registerEvents(listener);
            }
        }
    }

    protected final void registerEvents(Listener listener) {
        if (this.startingReloadables) {
            this.reloadables.registerEvents(listener);
        } else {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
    }

    protected final void registerEventsIf(SimpleListener<? extends Event> listener, boolean condition) {
        if (condition) {
            if (this.startingReloadables) {
                this.reloadables.registerEvents(listener);
            } else {
                this.registerEvents(listener);
            }
        }
    }

    protected final void registerEvents(SimpleListener<? extends Event> listener) {
        if (this.startingReloadables) {
            this.reloadables.registerEvents(listener);
        } else {
            listener.register();
        }
    }

    protected final void registerCommand(Command command) {
        Remain.registerCommand(command);
    }

    protected final void registerCommand(SimpleCommand command) {
        command.register();
    }

    protected final void registerCommands(String label, SimpleCommandGroup group) {
        this.registerCommands(label, null, group);
    }

    protected final void registerCommands(String label, List<String> aliases, SimpleCommandGroup group) {
        if (this.getMainCommand() != null && this.getMainCommand().getLabel().equals(label)) {
            throw new FoException("Your main command group is registered automatically!");
        }
        group.register(label, aliases);
    }

    protected final void registerCommands(StrictList<String> labelAndAliases, SimpleCommandGroup group) {
        Valid.checkBoolean(!labelAndAliases.isEmpty(), "Must specify at least label for command group: " + group, new Object[0]);
        if (this.getMainCommand() != null && this.getMainCommand().getLabel().equals(labelAndAliases.get(0))) {
            throw new FoException("Your main command group is registered automatically!");
        }
        group.register(labelAndAliases);
    }

    protected String[] getStartupLogo() {
        return null;
    }

    public MinecraftVersion.V getMinimumVersion() {
        return null;
    }

    public MinecraftVersion.V getMaximumVersion() {
        return null;
    }

    public List<Class<? extends YamlStaticConfig>> getSettings() {
        return null;
    }

    public SimpleCommandGroup getMainCommand() {
        return null;
    }

    public int getFoundedYear() {
        return -1;
    }

    public SpigotUpdater getUpdateCheck() {
        return null;
    }

    public int getMetricsPluginId() {
        return -1;
    }

    public int getRegexTimeout() {
        throw new FoException("Must override getRegexTimeout()");
    }

    public boolean regexStripColors() {
        return true;
    }

    public boolean regexCaseInsensitive() {
        return true;
    }

    public boolean regexUnicode() {
        return true;
    }

    public SimpleBungee getBungeeCord() {
        return null;
    }

    public boolean enforeNewLine() {
        return false;
    }

    @Deprecated
    public boolean areScriptVariablesEnabled() {
        return false;
    }

    protected final File getFile() {
        return super.getFile();
    }

    @Deprecated
    public final PluginCommand getCommand(String name) {
        return super.getCommand(name);
    }

    @Deprecated
    public final boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        throw this.unsupported("onCommand");
    }

    @Deprecated
    public final List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        throw this.unsupported("onTabComplete");
    }

    @Deprecated
    public final FileConfiguration getConfig() {
        throw this.unsupported("getConfig");
    }

    @Deprecated
    public final void saveConfig() {
        throw this.unsupported("saveConfig");
    }

    @Deprecated
    public final void saveDefaultConfig() {
        throw this.unsupported("saveDefaultConfig");
    }

    @Deprecated
    public final void reloadConfig() {
        throw new FoException("Cannot call reloadConfig in " + this.getName() + ", use reload()!");
    }

    private final FoException unsupported(String method) {
        return new FoException("Cannot call " + method + " in " + this.getName() + ", use YamlConfig or SimpleCommand classes in Foundation for that!");
    }

    public static boolean isReloading() {
        return reloading;
    }

    private final class ShadingException
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public ShadingException() {
            if (!SimplePlugin.getNamed().equals(SimplePlugin.this.getDescription().getName())) {
                System.out.println(Common.consoleLine());
                System.out.println("We have a class path problem in the Foundation library");
                System.out.println("preventing " + SimplePlugin.this.getDescription().getName() + " from loading correctly!");
                System.out.println("");
                System.out.println("This is likely caused by two plugins having the");
                System.out.println("same Foundation library paths - make sure you");
                System.out.println("relocale the package! If you are testing using");
                System.out.println("Ant, only test one plugin at the time.");
                System.out.println("");
                System.out.println("Possible cause: " + SimplePlugin.getNamed());
                System.out.println("Foundation package: " + SimplePlugin.class.getPackage().getName());
                System.out.println(Common.consoleLine());
                SimplePlugin.this.isEnabled = false;
            }
        }
    }
}

