/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.GeoAPI;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.TimeUtil;
import org.mineacademy.fo.collection.StrictMap;
import org.mineacademy.fo.collection.expiringmap.ExpiringMap;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.model.Replacer;
import org.mineacademy.fo.model.Variable;
import org.mineacademy.fo.remain.Remain;
import org.mineacademy.fo.settings.SimpleSettings;

public final class Variables {
    public static boolean REPLACE_COLORS = true;
    protected static final Pattern BRACKET_PLACEHOLDER_PATTERN = Pattern.compile("[{]([^{}]+)[}]");
    protected static final Pattern BRACKET_REL_PLACEHOLDER_PATTERN = Pattern.compile("[{](rel_)([^}]+)[}]");
    private static final StrictMap<String, Function<CommandSender, String>> customVariables = new StrictMap();
    private static final StrictMap<String, Map<String, String>> cache = new StrictMap();
    private static final Map<String, Map<String, String>> customCache = Variables.makeNewFastCache();

    public static Set<String> getVariables() {
        return Collections.unmodifiableSet(customVariables.keySet());
    }

    public static void addVariable(String variable, Function<CommandSender, String> replacer) {
        customVariables.put(variable, replacer);
    }

    public static void removeVariable(String variable) {
        customVariables.remove(variable);
    }

    public static boolean hasVariable(String variable) {
        return customVariables.contains(variable);
    }

    public static List<String> replaceAll(List<String> messages, CommandSender sender) {
        return Variables.replaceAll(Variable.VariableScope.FORMAT, messages, sender);
    }

    public static List<String> replaceAll(List<String> messages, CommandSender sender, Map<String, Object> replacements) {
        return Variables.replaceAll(Variable.VariableScope.FORMAT, messages, sender, replacements);
    }

    public static List<String> replaceAll(Variable.VariableScope scope, List<String> messages, CommandSender sender) {
        return Variables.replaceAll(scope, messages, sender, null);
    }

    public static List<String> replaceAll(Variable.VariableScope scope, List<String> messages, CommandSender sender, Map<String, Object> replacements) {
        ArrayList<String> replaced = new ArrayList<String>(messages);
        for (int i = 0; i < replaced.size(); ++i) {
            String message = (String)replaced.get(i);
            replaced.set(i, Variables.replace(scope, message, sender, replacements));
        }
        return replaced;
    }

    public static String replace(String message, CommandSender sender) {
        return Variables.replace(Variable.VariableScope.FORMAT, message, sender);
    }

    public static String replace(String message, CommandSender sender, Map<String, Object> replacements) {
        return Variables.replace(Variable.VariableScope.FORMAT, message, sender, replacements);
    }

    @Deprecated
    public static String replace(boolean replaceCustom, String message, CommandSender sender) {
        return Variables.replace(message, sender);
    }

    public static String replace(Variable.VariableScope scope, String message, CommandSender sender) {
        return Variables.replace(scope, message, sender, null);
    }

    public static String replace(Variable.VariableScope scope, String message, CommandSender sender, Map<String, Object> replacements) {
        if (message == null || message.isEmpty()) {
            return "";
        }
        String original = message;
        boolean senderIsPlayer = sender instanceof Player;
        if (replacements != null && !replacements.isEmpty()) {
            message = Replacer.replaceArray(message, replacements);
        }
        if (senderIsPlayer) {
            Map<String, String> cached = customCache.get(sender.getName());
            if (cached != null && cached.containsKey(message)) {
                return cached.get(message);
            }
            message = Variables.replaceJavascriptVariables0(scope, message, sender);
            message = HookManager.replacePlaceholders((Player)sender, message);
        }
        message = Variables.replaceHardVariables0(sender, message);
        if (REPLACE_COLORS) {
            message = Common.colorize(message);
        }
        if (senderIsPlayer) {
            Map<String, String> map = customCache.get(sender.getName());
            if (map != null) {
                map.put(original, message);
            } else {
                customCache.put(sender.getName(), Common.newHashMap(original, message));
            }
        }
        return message;
    }

    private static String replaceJavascriptVariables0(Variable.VariableScope scope, String message, CommandSender sender) {
        for (Variable variable : Variable.getVariables()) {
            String key = variable.getKey();
            if (variable.getScope() != scope || !message.contains(key)) continue;
            try {
                message = message.replace(key, variable.getValue(sender));
            }
            catch (Throwable t) {
                Common.throwError(t, "Failed to replace a custom variable!", "Message: " + message, "Variable: " + key, "%error");
            }
        }
        return message;
    }

    private static String replaceHardVariables0(CommandSender sender, String message) {
        Player player;
        Matcher matcher = BRACKET_PLACEHOLDER_PATTERN.matcher(message);
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        while (matcher.find()) {
            Map<String, String> senderCache;
            String storedVariable;
            String variable = matcher.group(1);
            boolean isSenderCached = cache.contains(sender.getName());
            boolean makeCache = true;
            String value = null;
            if (isSenderCached && (storedVariable = (senderCache = cache.get(sender.getName())).get(variable)) != null) {
                value = storedVariable;
                makeCache = false;
            }
            if (makeCache && (value = Variables.replaceVariable0(variable, player, sender)) != null) {
                Map<String, String> speciCache = cache.getOrPut(sender.getName(), Variables.makeNewCache());
                speciCache.put(variable, value);
            }
            if (value == null) continue;
            message = message.replace("{" + variable + "}", Common.colorize(value));
        }
        return message;
    }

    private static String replaceVariable0(String variable, Player player, CommandSender console) {
        String found;
        boolean insertSpace = variable.endsWith("+");
        if (insertSpace) {
            variable = variable.substring(0, variable.length() - 1);
        }
        return (found = Variables.lookupVariable0(player, console, variable)) == null ? null : found + (insertSpace && !found.isEmpty() ? " " : "");
    }

    private static String lookupVariable0(Player player, CommandSender console, String variable) {
        Function<CommandSender, String> customReplacer;
        GeoAPI.GeoResponse geoResponse = null;
        if (player != null && Arrays.asList("country_code", "country_name", "region_name", "isp").contains(variable)) {
            geoResponse = GeoAPI.getCountry(player.getAddress());
        }
        if ((customReplacer = customVariables.get(variable)) != null) {
            return customReplacer.apply(console);
        }
        switch (variable) {
            case "bungee_server_name": {
                return SimpleSettings.BUNGEE_SERVER_NAME;
            }
            case "server_name": {
                return SimpleSettings.SERVER_NAME;
            }
            case "nms_version": {
                return MinecraftVersion.getServerVersion();
            }
            case "timestamp": {
                return TimeUtil.getFormattedDate();
            }
            case "town": {
                return player == null ? "" : HookManager.getTownName(player);
            }
            case "nation": {
                return player == null ? "" : HookManager.getNation(player);
            }
            case "faction": {
                return player == null ? "" : HookManager.getFaction(player);
            }
            case "world": {
                return player == null ? "" : HookManager.getWorldAlias(player.getWorld());
            }
            case "health": {
                return player == null ? "" : Variables.formatHealth0(player) + ChatColor.RESET;
            }
            case "player": 
            case "player_name": {
                return player == null ? Common.resolveSenderName(console) : player.getName();
            }
            case "tab_name": {
                return player == null ? Common.resolveSenderName(console) : player.getPlayerListName();
            }
            case "display_name": {
                return player == null ? Common.resolveSenderName(console) : player.getDisplayName();
            }
            case "nick": {
                return player == null ? Common.resolveSenderName(console) : HookManager.getNick((CommandSender)player);
            }
            case "player_prefix": 
            case "pl_prefix": {
                return player == null ? "" : HookManager.getPlayerPrefix(player);
            }
            case "player_suffix": 
            case "pl_suffix": {
                return player == null ? "" : HookManager.getPlayerSuffix(player);
            }
            case "player_group": 
            case "pl_group": {
                return player == null ? "" : HookManager.getPlayerPermissionGroup(player);
            }
            case "player_primary_group": 
            case "pl_primary_group": {
                return player == null ? "" : HookManager.getPlayerPrimaryGroup(player);
            }
            case "ip_address": 
            case "pl_address": {
                return player == null ? "" : Variables.formatIp0(player);
            }
            case "country_code": {
                return player == null ? "" : geoResponse.getCountryCode();
            }
            case "country_name": {
                return player == null ? "" : geoResponse.getCountryName();
            }
            case "region_name": {
                return player == null ? "" : geoResponse.getRegionName();
            }
            case "isp": {
                return player == null ? "" : geoResponse.getIsp();
            }
        }
        return null;
    }

    private static String formatHealth0(Player player) {
        int hp = Remain.getHealth((LivingEntity)player);
        return (hp > 10 ? ChatColor.DARK_GREEN : (hp > 5 ? ChatColor.GOLD : ChatColor.RED)) + "" + hp;
    }

    private static String formatIp0(Player player) {
        try {
            return player.getAddress().toString().split("\\:")[0];
        }
        catch (Throwable t) {
            return player.getAddress() != null ? player.getAddress().toString() : "";
        }
    }

    private static Map<String, Map<String, String>> makeNewFastCache() {
        return ExpiringMap.builder().maxSize(300).expiration(10L, TimeUnit.MILLISECONDS).build();
    }

    private static Map<String, String> makeNewCache() {
        return ExpiringMap.builder().maxSize(300).expiration(1L, TimeUnit.SECONDS).build();
    }
}

