/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.List;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;
import org.mineacademy.fo.model.Actionable;
import org.mineacademy.fo.model.ConfigItems;
import org.mineacademy.fo.model.JavaScriptExecutor;
import org.mineacademy.fo.model.Variables;
import org.mineacademy.fo.settings.YamlConfig;

public final class Variable
extends YamlConfig
implements Actionable {
    private static final ConfigItems<Variable> loadedVariables = new ConfigItems<Variable>("variable", "variables", Variable.class, false);
    private VariableScope scope;
    private String key;
    private String value;
    @Nullable
    private String senderPermission;
    @Nullable
    private String receiverPermission;
    @Nullable
    private List<String> hoverText;
    @Nullable
    private String hoverItem;
    @Nullable
    private String openUrl;
    @Nullable
    private String suggestCommand;
    @Nullable
    private String runCommand;

    @Override
    protected void onLoadFinish() {
        this.key = this.getString("Key");
        Valid.checkNotNull(this.key, "Please set the 'Key' variable name in " + this.getFileName() + " variable file!");
        this.value = this.getString("Value");
        Valid.checkNotNull(this.value, "Please set the 'Value' variable output in " + this.getFileName() + " variable file!");
        this.scope = this.get("Scope", VariableScope.class, VariableScope.FORMAT);
        this.hoverText = this.getStringList("Hover");
        this.hoverItem = this.getString("Hover_Item");
        this.openUrl = this.getString("Open_Url");
        this.suggestCommand = this.getString("Suggest_Command");
        this.runCommand = this.getString("Run_Command");
        this.senderPermission = this.getString("Sender_Permission");
        this.receiverPermission = this.getString("Receiver_Permission");
    }

    public String getValue(CommandSender player) {
        if (player instanceof Player) {
            String script = Variables.replace(this.scope, this.value, player);
            return String.valueOf(JavaScriptExecutor.run(script, player));
        }
        return "";
    }

    public void setScope(VariableScope score) {
        this.scope = score;
        this.save();
    }

    public void setKey(String key) {
        this.key = key;
        this.save();
    }

    public void setValue(String value) {
        this.value = value;
        this.save();
    }

    @Override
    public void setHoverText(List<String> hoverText) {
        this.hoverText = hoverText;
        this.save();
    }

    @Override
    public void setHoverItem(String hoverItem) {
        this.hoverItem = hoverItem;
        this.save();
    }

    @Override
    public void setOpenUrl(String openUrl) {
        this.openUrl = openUrl;
        this.save();
    }

    @Override
    public void setSuggestCommand(String suggestCommand) {
        this.suggestCommand = suggestCommand;
        this.save();
    }

    @Override
    public void setRunCommand(String runCommand) {
        this.runCommand = runCommand;
        this.save();
    }

    @Override
    public void setSenderPermission(String senderPermission) {
        this.senderPermission = senderPermission;
        this.save();
    }

    @Override
    public void setReceiverPermission(String receiverPermission) {
        this.receiverPermission = receiverPermission;
        this.save();
    }

    @Override
    public SerializedMap serialize() {
        return SerializedMap.ofArray("Key", this.key, "Value", this.value, "Hover", this.hoverText, "Hover_Item", this.hoverItem, "Open_Url", this.openUrl, "Suggest_Command", this.suggestCommand, "Run_Command", this.runCommand, "Sender_Permission", this.senderPermission, "Receiver_Permission", this.receiverPermission);
    }

    public static void loadVariables() {
        loadedVariables.loadItems();
    }

    public static Variable loadOrCreateVariable(String name) {
        return loadedVariables.loadOrCreateItem(name);
    }

    public static void removeVariable(Variable variable) {
        loadedVariables.removeItem(variable);
    }

    public static boolean isVariableLoaded(String name) {
        return loadedVariables.isItemLoaded(name);
    }

    public static Variable findVariable(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return loadedVariables.findItem(name);
    }

    public static List<Variable> getVariables() {
        return loadedVariables.getItems();
    }

    public static List<String> getVariableNames() {
        return loadedVariables.getItemNames();
    }

    private Variable() {
    }

    public VariableScope getScope() {
        return this.scope;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getSenderPermission() {
        return this.senderPermission;
    }

    @Override
    @Nullable
    public String getReceiverPermission() {
        return this.receiverPermission;
    }

    @Override
    @Nullable
    public List<String> getHoverText() {
        return this.hoverText;
    }

    @Override
    @Nullable
    public String getHoverItem() {
        return this.hoverItem;
    }

    @Override
    @Nullable
    public String getOpenUrl() {
        return this.openUrl;
    }

    @Override
    @Nullable
    public String getSuggestCommand() {
        return this.suggestCommand;
    }

    @Override
    @Nullable
    public String getRunCommand() {
        return this.runCommand;
    }

    static {
        loadedVariables.setVerbose(true);
    }

    public static enum VariableScope {
        FORMAT,
        CHAT;

    }
}

