/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.remain.Remain;

class TownyHook {
    TownyHook() {
    }

    Collection<? extends Player> getTownResidentsOnline(Player pl) {
        ArrayList<Player> recipients = new ArrayList<Player>();
        String playersTown = this.getTownName(pl);
        if (!playersTown.isEmpty()) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!playersTown.equals(this.getTownName(player))) continue;
                recipients.add(player);
            }
        }
        return recipients;
    }

    Collection<? extends Player> getNationPlayersOnline(Player pl) {
        ArrayList<Player> recipients = new ArrayList<Player>();
        String playerNation = this.getNationName(pl);
        if (!playerNation.isEmpty()) {
            for (Player player : Remain.getOnlinePlayers()) {
                if (!playerNation.equals(this.getNationName(player))) continue;
                recipients.add(player);
            }
        }
        Debugger.debug("towny", "Players in " + pl.getName() + "'s nation '" + playerNation + "': " + recipients);
        return recipients;
    }

    String getTownName(Player pl) {
        Town t = this.getTown(pl);
        return t != null ? t.getName() : "";
    }

    String getNationName(Player pl) {
        Nation n = this.getNation(pl);
        return n != null ? n.getName() : "";
    }

    List<String> getTowns() {
        try {
            return Common.convert(TownyUniverse.getDataSource().getTowns(), TownyObject::getName);
        }
        catch (Throwable e) {
            return new ArrayList<String>();
        }
    }

    String getTown(Location loc) {
        try {
            return TownyUniverse.getTownName((Location)loc);
        }
        catch (Throwable e) {
            return null;
        }
    }

    String getTownOwner(Location loc) {
        try {
            return TownyUniverse.getDataSource().getTown(TownyUniverse.getTownName((Location)loc)).getMayor().getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private Nation getNation(Player pl) {
        Town town = this.getTown(pl);
        try {
            return town.getNation();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private Town getTown(Player pl) {
        Resident res = this.getResident(pl);
        try {
            return res.getTown();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private Resident getResident(Player pl) {
        try {
            return TownyUniverse.getDataSource().getResident(pl.getName());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

