/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.bukkit.Bukkit;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.settings.SimpleLocalization;

public class SpigotUpdater
implements Runnable {
    private final int resourceId;
    private final boolean download;
    private boolean newVersionAvailable = false;
    private String newVersion = "";

    public SpigotUpdater(int resourceId) {
        this(resourceId, false);
    }

    public SpigotUpdater(int resourceId, boolean download) {
        this.resourceId = resourceId;
        this.download = download;
    }

    @Override
    public void run() {
        if (this.resourceId == -1) {
            return;
        }
        String currentVersion = SimplePlugin.getVersion();
        if (!this.canUpdateFrom(currentVersion)) {
            return;
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openConnection();
            connection.setRequestMethod("GET");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                this.newVersion = line = reader.readLine();
            }
            if (this.newVersion.isEmpty()) {
                return;
            }
            if (this.isNewerVersion(currentVersion, this.newVersion) && this.canUpdateTo(this.newVersion)) {
                this.newVersionAvailable = true;
                if (this.download) {
                    connection = (HttpURLConnection)new URL("https://api.spiget.org/v2/resources/" + this.resourceId + "/download").openConnection();
                    connection.setRequestProperty("User-Agent", SimplePlugin.getNamed());
                    Valid.checkBoolean(connection.getResponseCode() == 200, "Downloading update for " + SimplePlugin.getNamed() + " returned " + connection.getResponseCode() + ", aborting.", new Object[0]);
                    ReadableByteChannel channel = Channels.newChannel(connection.getInputStream());
                    File updateFolder = Bukkit.getUpdateFolderFile();
                    FileUtil.createIfNotExists(updateFolder);
                    File destination = new File(updateFolder, SimplePlugin.getNamed() + "-" + this.newVersion + ".jar");
                    FileOutputStream output = new FileOutputStream(destination);
                    output.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
                    output.flush();
                    output.close();
                    Common.log(this.getDownloadMessage());
                } else {
                    Common.log(this.getNotifyMessage());
                }
            }
        }
        catch (UnknownHostException ex) {
            Common.log("Could not check for update from " + ex.getMessage() + ".");
        }
        catch (IOException ex) {
            if (!ex.getMessage().startsWith("Server returned HTTP response code: 403")) {
                if (ex.getMessage().startsWith("Server returned HTTP response code:")) {
                    Common.log("Could not check for update, SpigotMC site appears to be down (or unaccessible): " + ex.getMessage());
                } else {
                    Common.error(ex, "IOException performing update from SpigotMC.org check for " + SimplePlugin.getNamed());
                }
            }
        }
        catch (Exception ex) {
            Common.error(ex, "Unknown error performing update from SpigotMC.org check for " + SimplePlugin.getNamed());
        }
    }

    protected boolean canUpdateFrom(String currentVersion) {
        return !currentVersion.contains("SNAPSHOT") && !currentVersion.contains("DEV");
    }

    protected boolean canUpdateTo(String newVersion) {
        return !newVersion.contains("SNAPSHOT") && !newVersion.contains("DEV");
    }

    private boolean isNewerVersion(String current, String remote) {
        String[] remoteParts;
        if (remote.contains("-LEGACY")) {
            return false;
        }
        String[] currParts = this.removeTagsInNumber(current).split("\\.");
        if (currParts.length != (remoteParts = this.removeTagsInNumber(remote).split("\\.")).length) {
            boolean olderIsLonger = currParts.length > remoteParts.length;
            String[] modifiedParts = new String[olderIsLonger ? currParts.length : remoteParts.length];
            for (int i = 0; i < (olderIsLonger ? currParts.length : remoteParts.length); ++i) {
                modifiedParts[i] = olderIsLonger ? (remoteParts.length > i ? remoteParts[i] : "0") : (currParts.length > i ? currParts[i] : "0");
            }
            if (olderIsLonger) {
                remoteParts = modifiedParts;
            } else {
                currParts = modifiedParts;
            }
        }
        for (int i = 0; i < currParts.length; ++i) {
            if (Integer.parseInt(currParts[i]) > Integer.parseInt(remoteParts[i])) {
                return false;
            }
            if (Integer.parseInt(remoteParts[i]) <= Integer.parseInt(currParts[i])) continue;
            return true;
        }
        return false;
    }

    protected String removeTagsInNumber(String raw) {
        return raw.split("\\-")[0];
    }

    public final String getNotifyMessage() {
        return this.replaceVariables(SimpleLocalization.Update.AVAILABLE);
    }

    public final String getDownloadMessage() {
        return this.replaceVariables(SimpleLocalization.Update.DOWNLOADED);
    }

    protected String replaceVariables(String message) {
        return message.replace("{resource_id}", this.resourceId + "").replace("{plugin_name}", SimplePlugin.getNamed()).replace("{new}", this.newVersion).replace("{current}", SimplePlugin.getVersion()).replace("{user_id}", "%%__USER__%%");
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersionAvailable;
    }

    public String getNewVersion() {
        return this.newVersion;
    }
}

