/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import org.mineacademy.fo.TimeUtil;

public final class SimpleTime {
    private final String raw;
    private final int timeTicks;

    private SimpleTime(String time) {
        this.raw = time;
        this.timeTicks = (int)TimeUtil.toTicks(time);
    }

    public static SimpleTime fromSeconds(int seconds) {
        return SimpleTime.from(seconds + " seconds");
    }

    public static SimpleTime from(String time) {
        return new SimpleTime(time);
    }

    public int getTimeSeconds() {
        return this.timeTicks / 20;
    }

    public int getTimeTicks() {
        return this.timeTicks;
    }

    public String toString() {
        return this.raw;
    }

    public String getRaw() {
        return this.raw;
    }
}

