/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.remain.CompSound;

public final class SimpleSound {
    @NonNull
    private Sound sound;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private boolean randomPitch = false;

    public SimpleSound(Sound sound, float volume, float pitch) {
        this(sound, volume, pitch, false);
    }

    public SimpleSound(String line) {
        Valid.checkNotNull(line);
        if ("none".equals(line)) {
            this.sound = CompSound.CLICK.getSound();
            this.volume = 0.0f;
            return;
        }
        String[] values = line.contains(", ") ? line.split(", ") : line.split(" ");
        try {
            this.sound = CompSound.convert(values[0]);
        }
        catch (IllegalArgumentException ex) {
            Common.throwError(ex, "Sound '" + values[0] + "' does not exists (in your Minecraft version)!", "Notice: Sound names has changed as per 1.9. See:", "https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html");
        }
        if (values.length == 1) {
            this.volume = 1.0f;
            this.pitch = 1.5f;
            return;
        }
        Valid.checkBoolean(values.length == 3, "Malformed sound type, use format: 'sound' OR 'sound volume pitch'. Got: " + line, new Object[0]);
        Valid.checkNotNull(this.sound, "Unable to parse sound from: " + line);
        this.volume = Float.parseFloat(values[1]);
        this.pitch = Float.parseFloat(values[2]);
    }

    public void play(Iterable<Player> players) {
        for (Player player : players) {
            this.play(player);
        }
    }

    public void play(Player player) {
        Valid.checkNotNull(this.sound);
        player.playSound(player.getLocation(), this.sound, this.volume, this.getPitch());
    }

    public void play(Location location) {
        Valid.checkNotNull(this.sound);
        location.getWorld().playSound(location, this.sound, this.volume, this.getPitch());
    }

    public float getPitch() {
        return this.randomPitch ? (float)Math.random() : this.pitch;
    }

    public String toString() {
        return this.sound + ", " + this.volume + ", " + this.pitch;
    }

    @NonNull
    public Sound getSound() {
        return this.sound;
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isRandomPitch() {
        return this.randomPitch;
    }

    public SimpleSound(@NonNull Sound sound, float volume, float pitch, boolean randomPitch) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.randomPitch = randomPitch;
    }
}

