/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.remain.CompMaterial;
import org.mineacademy.fo.remain.Remain;

public final class SimpleComponent {
    private static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    private final List<PermissibleComponent> pastComponents = new ArrayList<PermissibleComponent>();
    private final boolean colorize;
    private PermissibleComponent[] currentComponents;

    private SimpleComponent() {
        this(true, "");
    }

    private SimpleComponent(boolean colorize, String ... text) {
        this.colorize = colorize;
        this.currentComponents = SimpleComponent.fromLegacyText(colorize ? String.join((CharSequence)"\n", Common.colorize(text)) : String.join((CharSequence)"\n", text), null, null);
    }

    public SimpleComponent onHover(Collection<String> texts) {
        return this.onHover(texts.toArray(new String[texts.size()]));
    }

    public SimpleComponent onHover(String ... text) {
        return this.onHover(HoverEvent.Action.SHOW_TEXT, String.join((CharSequence)"\n", text));
    }

    public SimpleComponent onHover(ItemStack item) {
        return CompMaterial.isAir(item.getType()) ? this.onHover("Air") : this.onHover(HoverEvent.Action.SHOW_ITEM, Remain.toJson(item));
    }

    public SimpleComponent onHover(HoverEvent.Action action, String text) {
        List<BaseComponent> baseComponents = Common.convert(Arrays.asList(SimpleComponent.fromLegacyText(this.colorize ? Common.colorize(text) : text, null, null)), PermissibleComponent::getComponent);
        for (PermissibleComponent component : this.currentComponents) {
            component.getComponent().setHoverEvent(new HoverEvent(action, baseComponents.toArray(new BaseComponent[baseComponents.size()])));
        }
        return this;
    }

    public SimpleComponent onClickRunCmd(String text) {
        return this.onClick(ClickEvent.Action.RUN_COMMAND, text);
    }

    public SimpleComponent onClickSuggestCmd(String text) {
        return this.onClick(ClickEvent.Action.SUGGEST_COMMAND, text);
    }

    public SimpleComponent onClickOpenUrl(String url) {
        return this.onClick(ClickEvent.Action.OPEN_URL, url);
    }

    public SimpleComponent onClick(ClickEvent.Action action, String text) {
        for (PermissibleComponent component : this.currentComponents) {
            component.getComponent().setClickEvent(new ClickEvent(action, Common.colorize(text)));
        }
        return this;
    }

    public SimpleComponent append(String text) {
        return this.append(text, null);
    }

    public SimpleComponent append(String text, String viewPermission) {
        BaseComponent lastComponentFormatting = null;
        for (PermissibleComponent baseComponent : this.currentComponents) {
            this.pastComponents.add(baseComponent);
            lastComponentFormatting = baseComponent.getComponent();
        }
        this.currentComponents = SimpleComponent.fromLegacyText(this.colorize ? Common.colorize(text) : text, lastComponentFormatting, viewPermission);
        return this;
    }

    public TextComponent build() {
        TextComponent mainComponent = new TextComponent("");
        for (PermissibleComponent pastComponent : this.pastComponents) {
            mainComponent.addExtra(pastComponent.getComponent());
        }
        for (PermissibleComponent currentComponent : this.currentComponents) {
            mainComponent.addExtra(currentComponent.getComponent());
        }
        return mainComponent;
    }

    public List<PermissibleComponent> getComponents() {
        return Common.joinArrays(this.pastComponents, Arrays.asList(this.currentComponents));
    }

    public String getPlainMessage() {
        return this.build().toLegacyText();
    }

    public <T extends CommandSender> void send(Iterable<T> senders) {
        TextComponent mainComponent = this.build();
        for (CommandSender sender : senders) {
            Remain.sendComponent(sender, mainComponent);
        }
    }

    public <T extends CommandSender> void send(T ... senders) {
        TextComponent mainComponent = this.build();
        for (T sender : senders) {
            Remain.sendComponent(sender, mainComponent);
        }
    }

    public static PermissibleComponent[] fromLegacyText(@NonNull String message, @Nullable BaseComponent lastComponentFormatting, @Nullable String viewPermission) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ArrayList<PermissibleComponent> components = new ArrayList<PermissibleComponent>();
        if (lastComponentFormatting != null) {
            if (lastComponentFormatting.isBold()) {
                message = ChatColor.BOLD + message;
            }
            if (lastComponentFormatting.isItalic()) {
                message = ChatColor.ITALIC + message;
            }
            if (lastComponentFormatting.isObfuscated()) {
                message = ChatColor.MAGIC + message;
            }
            if (lastComponentFormatting.isStrikethrough()) {
                message = ChatColor.STRIKETHROUGH + message;
            }
            if (lastComponentFormatting.isUnderlined()) {
                message = ChatColor.UNDERLINE + message;
            }
            message = lastComponentFormatting.getColor() + message;
        }
        Matcher matcher = URL_PATTERN.matcher(message);
        StringBuilder builder = new StringBuilder();
        Object component = new TextComponent();
        block18: for (int i = 0; i < message.length(); ++i) {
            Object old;
            char c = message.charAt(i);
            if (c == '\u00a7') {
                ChatColor format;
                if (++i >= message.length()) break;
                c = message.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((format = ChatColor.getByChar((char)c)) == null) continue;
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent((TextComponent)old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(new PermissibleComponent((BaseComponent)old, viewPermission));
                }
                switch (format.getName().toUpperCase()) {
                    case "BOLD": {
                        component.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case "ITALIC": {
                        component.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case "UNDERLINE": {
                        component.setUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case "STRIKETHROUGH": {
                        component.setStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case "OBFUSCATED": {
                        component.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case "MAGIC": {
                        component.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case "RESET": {
                        format = ChatColor.RESET;
                    }
                    default: {
                        component = new TextComponent();
                        component.setColor(format);
                        if (format != ChatColor.RESET) continue block18;
                        component.setBold(Boolean.valueOf(false));
                        component.setItalic(Boolean.valueOf(false));
                        component.setUnderlined(Boolean.valueOf(false));
                        component.setStrikethrough(Boolean.valueOf(false));
                        component.setObfuscated(Boolean.valueOf(false));
                        break;
                    }
                }
                continue;
            }
            int pos = message.indexOf(32, i);
            if (pos == -1) {
                pos = message.length();
            }
            if (matcher.region(i, pos).find()) {
                if (builder.length() > 0) {
                    old = component;
                    component = new TextComponent((TextComponent)old);
                    old.setText(builder.toString());
                    builder = new StringBuilder();
                    components.add(new PermissibleComponent((BaseComponent)old, viewPermission));
                }
                old = component;
                component = new TextComponent((TextComponent)old);
                String urlString = message.substring(i, pos);
                component.setText(urlString);
                component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, urlString.startsWith("http") ? urlString : "http://" + urlString));
                components.add(new PermissibleComponent((BaseComponent)component, viewPermission));
                i += pos - i - 1;
                component = old;
                continue;
            }
            builder.append(c);
        }
        component.setText(builder.toString());
        components.add(new PermissibleComponent((BaseComponent)component, viewPermission));
        return (PermissibleComponent[])components.stream().toArray(PermissibleComponent[]::new);
    }

    public static SimpleComponent of(String ... text) {
        return SimpleComponent.of(true, text);
    }

    public static SimpleComponent of(boolean colorize, String ... text) {
        return new SimpleComponent(colorize, text);
    }

    public static class PermissibleComponent {
        private final BaseComponent component;
        private final String permission;

        public PermissibleComponent(BaseComponent component, String permission) {
            this.component = component;
            this.permission = permission;
        }

        public BaseComponent getComponent() {
            return this.component;
        }

        public String getPermission() {
            return this.permission;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissibleComponent)) {
                return false;
            }
            PermissibleComponent other = (PermissibleComponent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BaseComponent this$component = this.getComponent();
            BaseComponent other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            String this$permission = this.getPermission();
            String other$permission = other.getPermission();
            return !(this$permission == null ? other$permission != null : !this$permission.equals(other$permission));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PermissibleComponent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BaseComponent $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            String $permission = this.getPermission();
            result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
            return result;
        }

        public String toString() {
            return "SimpleComponent.PermissibleComponent(component=" + this.getComponent() + ", permission=" + this.getPermission() + ")";
        }
    }
}

