/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.SerializeUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.SerializedMap;

public final class Replacer {
    private static final String DELIMITER = "%D3L1M1T3R%";
    private final String[] messages;
    private String[] variables;
    private String[] replacedMessage;

    private Replacer(String ... messages) {
        this.messages = messages;
    }

    @Deprecated
    public Replacer find(String ... variables) {
        this.variables = variables;
        return this;
    }

    @Deprecated
    public String replaceAll(Object ... associativeArray) {
        SerializedMap map = SerializedMap.ofArray(associativeArray);
        ArrayList<String> find = new ArrayList<String>();
        ArrayList<Object> replaced = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            find.add(entry.getKey());
            replaced.add(entry.getValue());
        }
        this.find(find.toArray(new String[find.size()]));
        this.replace(replaced.toArray(new Object[replaced.size()]));
        return this.getReplacedMessageJoined();
    }

    @Deprecated
    public Replacer replace(Object ... replacements) {
        Valid.checkNotNull(this.variables, "call find() first");
        Valid.checkBoolean(replacements.length == this.variables.length, "Variables " + this.variables.length + " != replacements " + replacements.length, new Object[0]);
        String message = StringUtils.join((Object[])this.messages, (String)DELIMITER);
        for (int i = 0; i < this.variables.length; ++i) {
            String serialized;
            String find = this.variables[i];
            if (!find.startsWith("{")) {
                find = "{" + find;
            }
            if (!find.endsWith("}")) {
                find = find + "}";
            }
            Object rep = i < replacements.length ? replacements[i] : null;
            try {
                serialized = Objects.toString(SerializeUtil.serialize(rep));
            }
            catch (SerializeUtil.SerializeFailedException ex) {
                serialized = rep.toString();
            }
            message = message.replace(find, rep != null ? serialized : "");
        }
        this.replacedMessage = message.split(DELIMITER);
        return this;
    }

    @Deprecated
    public void tell(CommandSender recipient) {
        Valid.checkNotNull(this.replacedMessage, "Replaced message not yet set, use find() and replace()");
        Common.tell(recipient, this.replacedMessage);
    }

    @Deprecated
    public String getReplacedMessageJoined() {
        Valid.checkNotNull(this.replacedMessage, "Replaced message not yet set, use find() and replace()");
        return StringUtils.join((Object[])this.replacedMessage, (String)" ");
    }

    @Deprecated
    public static Replacer of(String ... messages) {
        return new Replacer(messages);
    }

    public static String replaceArray(String message, Object ... replacements) {
        SerializedMap map = SerializedMap.ofArray(replacements);
        return Replacer.replaceVariables(message, map);
    }

    public static List<String> replaceArray(List<String> list, Object ... replacements) {
        list = new ArrayList<String>(list);
        SerializedMap map = SerializedMap.ofArray(replacements);
        for (int i = 0; i < list.size(); ++i) {
            String message = list.get(i);
            message = Replacer.replaceVariables(message, map);
            list.set(i, message);
        }
        return list;
    }

    private static String replaceVariables(String message, SerializedMap variables) {
        for (Map.Entry<String, Object> replacement : variables.entrySet()) {
            String key = replacement.getKey();
            key = key.charAt(0) != '{' ? "{" + key : key;
            key = key.charAt(key.length() - 1) != '}' ? key + "}" : key;
            message = message.replace(key, Common.simplify(replacement.getValue()));
        }
        return message;
    }

    public Replacer(String[] messages, String[] variables, String[] replacedMessage) {
        this.messages = messages;
        this.variables = variables;
        this.replacedMessage = replacedMessage;
    }

    public String[] getReplacedMessage() {
        return this.replacedMessage;
    }
}

