/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.ReflectionUtil;
import org.mineacademy.fo.remain.Remain;

class RegionAccessor {
    private static Constructor<?> regionFileConstructor;
    private static Method isChunkSaved;
    private static boolean atleast1_13;
    private static boolean atleast1_14;
    private static boolean atleast1_15;
    private static boolean atleast1_16;
    private static final String saveMethodName;

    RegionAccessor() {
    }

    static Object getRegionFile(String worldName, File file) {
        try {
            File container = new File(Bukkit.getWorldContainer(), worldName);
            return atleast1_16 ? regionFileConstructor.newInstance(file, container, true) : (atleast1_15 ? regionFileConstructor.newInstance(file, container) : regionFileConstructor.newInstance(file));
        }
        catch (Throwable ex) {
            throw new RuntimeException("Could not create region file from " + file, ex);
        }
    }

    static boolean isChunkSaved(Object region, int x, int z) {
        try {
            if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_13)) {
                Object chunkCoordinates = ReflectionUtil.getNMSClass("ChunkCoordIntPair").getConstructor(Integer.TYPE, Integer.TYPE).newInstance(x, z);
                return (Boolean)isChunkSaved.invoke(region, chunkCoordinates);
            }
            return (Boolean)isChunkSaved.invoke(region, x, z);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException("Could not find if region file " + region + " has chunk at " + x + " " + z, ex);
        }
    }

    static void save(Object region) {
        try {
            region.getClass().getDeclaredMethod(saveMethodName, new Class[0]).invoke(region, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtil.ReflectionException("Error saving region " + region, ex);
        }
    }

    static {
        atleast1_13 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_13);
        atleast1_14 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_14);
        atleast1_15 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_15);
        atleast1_16 = MinecraftVersion.atLeast(MinecraftVersion.V.v1_16);
        saveMethodName = atleast1_13 ? "close" : "c";
        try {
            Class<?> regionFileClass = ReflectionUtil.getNMSClass("RegionFile");
            Constructor<?> constructor = atleast1_16 ? regionFileClass.getConstructor(File.class, File.class, Boolean.TYPE) : (regionFileConstructor = atleast1_15 ? regionFileClass.getConstructor(File.class, File.class) : regionFileClass.getConstructor(File.class));
            isChunkSaved = atleast1_14 ? regionFileClass.getMethod("b", ReflectionUtil.getNMSClass("ChunkCoordIntPair")) : regionFileClass.getMethod(atleast1_13 ? "b" : "c", Integer.TYPE, Integer.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            Remain.sneaky(ex);
        }
    }
}

