/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import org.mineacademy.fo.RandomUtil;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.model.RangedValue;

public final class RangedRandomValue
extends RangedValue {
    public RangedRandomValue(int value) {
        this(value, value);
    }

    public RangedRandomValue(int min, int max) {
        super(min, max);
        Valid.checkBoolean(min >= 0 && max >= 0, "Values may not be negative", new Object[0]);
        Valid.checkBoolean(min <= max, "Minimum must be lower or equal maximum", new Object[0]);
    }

    public static RangedRandomValue parse(String line) {
        RangedValue random = RangedValue.parse(line);
        return new RangedRandomValue(random.getMinInt(), random.getMaxInt());
    }

    public int getRandom() {
        return RandomUtil.nextBetween(this.getMinInt(), this.getMaxInt());
    }

    public boolean isInRange(int value) {
        return value >= this.getMinInt() && value <= this.getMaxInt();
    }
}

