/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.RandomUtil;
import org.mineacademy.fo.Valid;

public abstract class RandomNoRepeatPicker<T> {
    private final List<T> list = new ArrayList<T>();

    public void setItems(Iterable<T> list) {
        Valid.checkBoolean(list != null && list.iterator().hasNext(), "Cannot set items to an empty list!", new Object[0]);
        this.list.clear();
        this.list.addAll(Common.toList(list));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public T pickFrom(Iterable<T> items) {
        return this.pickFromFor(items, null);
    }

    public T pickFromFor(Iterable<T> items, Player player) {
        for (T item : items) {
            this.list.add(item);
        }
        return this.pickRandom(player);
    }

    public T pickRandom() {
        return this.pickRandom(null);
    }

    public T pickRandom(Player player) {
        if (this.list.isEmpty()) {
            return null;
        }
        while (!this.list.isEmpty()) {
            T picked = this.list.remove(RandomUtil.nextInt(this.list.size()));
            if (picked == null || !this.canObtain(player, picked)) continue;
            return picked;
        }
        return null;
    }

    protected abstract boolean canObtain(Player var1, T var2);

    public static final <T> RandomNoRepeatPicker<T> newPicker(Class<T> pickedType) {
        return RandomNoRepeatPicker.newPicker((Player player, T type) -> true);
    }

    public static final <T> RandomNoRepeatPicker<T> newPicker(final BiFunction<Player, T, Boolean> canObtain) {
        return new RandomNoRepeatPicker<T>(){

            @Override
            protected boolean canObtain(Player player, T picked) {
                return (Boolean)canObtain.apply(player, picked);
            }
        };
    }
}

