/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.remain.Remain;

class ProtocolLibHook {
    private final ProtocolManager manager = ProtocolLibrary.getProtocolManager();

    ProtocolLibHook() {
    }

    final void addPacketListener(Object listener) {
        Valid.checkBoolean(listener instanceof PacketListener, "Listener must extend or implements PacketListener or PacketAdapter", new Object[0]);
        this.manager.addPacketListener((PacketListener)listener);
    }

    final void removePacketListeners(Plugin plugin) {
        this.manager.removePacketListeners(plugin);
    }

    final void sendPacket(PacketContainer packet) {
        for (Player player : Remain.getOnlinePlayers()) {
            this.sendPacket(player, packet);
        }
    }

    final void sendPacket(Player player, Object packet) {
        Valid.checkNotNull(player);
        Valid.checkBoolean(packet instanceof PacketContainer, "Packet must be instance of PacketContainer from ProtocolLib", new Object[0]);
        try {
            this.manager.sendServerPacket(player, (PacketContainer)packet);
        }
        catch (InvocationTargetException e) {
            Common.error(e, "Failed to send " + ((PacketContainer)packet).getType() + " packet to " + player.getName());
        }
    }
}

