/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.model.HookManager;
import org.mineacademy.fo.model.Variables;
import org.mineacademy.fo.plugin.SimplePlugin;

class PlaceholderAPIHook {
    private final Set<HookManager.PAPIPlaceholder> placeholders = new HashSet<HookManager.PAPIPlaceholder>();
    private static volatile VariablesInjector injector;

    PlaceholderAPIHook() {
        this.unregister();
        try {
            injector = new VariablesInjector();
            injector.register();
        }
        catch (Throwable throwable) {
            Common.error(throwable, "Failed to inject our variables into PlaceholderAPI!");
        }
    }

    final void unregister() {
        if (injector != null) {
            try {
                injector.unregister();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    final void addPlaceholder(HookManager.PAPIPlaceholder placeholder) {
        this.placeholders.add(placeholder);
    }

    final String replacePlaceholders(Player pl, String msg) {
        try {
            return this.setPlaceholders(pl, msg);
        }
        catch (Throwable t) {
            Common.error(t, "PlaceholderAPI failed to replace variables!", "Player: " + pl.getName(), "Message: " + msg, "Error: %error");
            return msg;
        }
    }

    private String setPlaceholders(Player player, String text) {
        Map hooks = PlaceholderAPI.getPlaceholders();
        if (hooks.isEmpty()) {
            return text;
        }
        Matcher matcher = Variables.BRACKET_PLACEHOLDER_PATTERN.matcher(text);
        while (matcher.find()) {
            String value;
            String format = matcher.group(1);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase();
            String params = format.substring(index + 1);
            if (!hooks.containsKey(identifier) || (value = ((PlaceholderHook)hooks.get(identifier)).onRequest((OfflinePlayer)player, params)) == null) continue;
            text = text.replaceAll(Pattern.quote(matcher.group()), Matcher.quoteReplacement(Common.colorize(value)));
        }
        return text;
    }

    final String replaceRelationPlaceholders(Player one, Player two, String msg) {
        try {
            return this.setRelationalPlaceholders(one, two, msg);
        }
        catch (Throwable t) {
            Common.error(t, "PlaceholderAPI failed to replace relation variables!", "Player one: " + one, "Player two: " + two, "Message: " + msg, "Error: %error");
            return msg;
        }
    }

    private String setRelationalPlaceholders(Player one, Player two, String text) {
        Map hooks = PlaceholderAPI.getPlaceholders();
        if (hooks.isEmpty()) {
            return text;
        }
        Matcher m = Variables.BRACKET_REL_PLACEHOLDER_PATTERN.matcher(text);
        while (m.find()) {
            String format = m.group(2);
            int index = format.indexOf("_");
            if (index <= 0 || index >= format.length()) continue;
            String identifier = format.substring(0, index).toLowerCase();
            String params = format.substring(index + 1);
            if (!hooks.containsKey(identifier) || !(hooks.get(identifier) instanceof Relational)) continue;
            Relational rel = (Relational)hooks.get(identifier);
            String value = one != null && two != null ? rel.onPlaceholderRequest(one, two, params) : "";
            if (value == null) continue;
            text = text.replaceAll(Pattern.quote(m.group()), Matcher.quoteReplacement(Common.colorize(value)));
        }
        return text;
    }

    private class VariablesInjector
    extends PlaceholderExpansion {
        private VariablesInjector() {
        }

        public boolean persist() {
            return true;
        }

        public boolean canRegister() {
            return true;
        }

        public String getAuthor() {
            return SimplePlugin.getInstance().getDescription().getAuthors().toString();
        }

        public String getIdentifier() {
            return SimplePlugin.getNamed().toLowerCase().replace("%", "").replace(" ", "").replace("_", "");
        }

        public String getVersion() {
            return SimplePlugin.getInstance().getDescription().getVersion();
        }

        public String onRequest(OfflinePlayer offlinePlayer, @NonNull String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            boolean insertSpace = identifier.endsWith("+");
            identifier = insertSpace ? identifier.substring(0, identifier.length() - 1) : identifier;
            for (HookManager.PAPIPlaceholder replacer : PlaceholderAPIHook.this.placeholders) {
                if (!identifier.equalsIgnoreCase(replacer.getVariable())) continue;
                try {
                    Player player = offlinePlayer.getPlayer();
                    if (player == null) {
                        return null;
                    }
                    String value = Common.getOrEmpty(replacer.getValue().apply(player, identifier));
                    return value + (!value.isEmpty() && insertSpace ? " " : "");
                }
                catch (Exception e) {
                    Common.error(e, "Failed to replace your '" + identifier + "' variable for " + offlinePlayer.getName());
                }
            }
            return null;
        }
    }
}

