/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.debug.LagCatcher;
import org.mineacademy.fo.event.RegionScanCompleteEvent;
import org.mineacademy.fo.model.LimitedQueue;
import org.mineacademy.fo.model.RegionAccessor;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.remain.Remain;

public abstract class OfflineRegionScanner {
    private static final String[] FOLDERS = new String[]{"region", "DIM-1/region", "DIM1/region"};
    private static final Pattern FILE_PATTERN = Pattern.compile("r\\.(.+)\\.(.+)\\.mca");
    private static int OPERATION_WAIT_SECONDS = 1;
    private int done = 0;
    private int totalFiles = 0;
    private World world;
    private long lastTick = System.currentTimeMillis();

    public final void scan(World world) {
        this.scan0(world);
    }

    private final void scan0(World world) {
        Thread watchdog = null;
        try {
            Field f = Class.forName("org.spigotmc.WatchdogThread").getDeclaredField("instance");
            try {
                f.setAccessible(true);
                watchdog = (Thread)f.get(null);
                watchdog.suspend();
            }
            catch (Throwable t) {
                System.out.println("FAILED TO DISABLE WATCHDOG, ABORTING! See below and report to us. NO DATA WERE MANIPULATED.");
                Common.callEvent(new RegionScanCompleteEvent(world));
                t.printStackTrace();
                return;
            }
        }
        catch (ReflectiveOperationException f) {
            // empty catch block
        }
        System.out.println(Common.consoleLine());
        System.out.println("Scanning regions in " + world.getName());
        System.out.println(Common.consoleLine());
        LagCatcher.start("Region scanner for " + world.getName());
        File[] files = OfflineRegionScanner.getRegionFiles(world);
        if (files == null) {
            Common.log("Unable to locate the region files for: " + world.getName());
            return;
        }
        LimitedQueue<File> queue = new LimitedQueue<File>(files.length + 1);
        queue.addAll(Arrays.asList(files));
        this.totalFiles = files.length;
        this.world = world;
        this.schedule(world.getName(), (Queue<File>)((Object)queue));
        if (watchdog != null) {
            watchdog.resume();
        }
        LagCatcher.end("Region scanner for " + world.getName(), true);
    }

    private final void schedule(final String worldName, final Queue<File> queue) {
        new BukkitRunnable(){

            public void run() {
                File file = (File)queue.poll();
                if (file == null) {
                    System.out.println(Common.consoleLine());
                    System.out.println("Region scanner finished.");
                    System.out.println(Common.consoleLine());
                    Common.callEvent(new RegionScanCompleteEvent(OfflineRegionScanner.this.world));
                    OfflineRegionScanner.this.onScanFinished();
                    this.cancel();
                    return;
                }
                OfflineRegionScanner.this.scanFile(worldName, file);
                Common.runLater(20 * OPERATION_WAIT_SECONDS, () -> OfflineRegionScanner.this.schedule(worldName, queue));
            }
        }.runTask((Plugin)SimplePlugin.getInstance());
    }

    private final void scanFile(String worldName, File file) {
        Matcher matcher = FILE_PATTERN.matcher(file.getName());
        if (!matcher.matches()) {
            return;
        }
        int regionX = Integer.parseInt(matcher.group(1));
        int regionZ = Integer.parseInt(matcher.group(2));
        System.out.print("[" + Math.round((double)this.done++ / (double)this.totalFiles * 100.0) + "%] Processing " + file);
        if (System.currentTimeMillis() - this.lastTick > 4000L) {
            long free = Runtime.getRuntime().freeMemory() / 1000000L;
            if (free < 200L) {
                System.out.print(" [Low memory (" + free + "Mb)! Running GC and increasing delay between operations ..]");
                OPERATION_WAIT_SECONDS = 2;
                System.gc();
                Common.sleep(5000);
            } else {
                System.out.print(" [free memory = " + free + " mb]");
            }
            this.lastTick = System.currentTimeMillis();
        }
        System.out.println();
        Object region = RegionAccessor.getRegionFile(worldName, file);
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                int chunkX = x + (regionX << 5);
                int chunkZ = z + (regionZ << 5);
                if (!RegionAccessor.isChunkSaved(region, x, z)) continue;
                Chunk chunk = this.world.getChunkAt(chunkX, chunkZ);
                this.onChunkScan(chunk);
            }
        }
        try {
            RegionAccessor.save(region);
        }
        catch (Throwable t) {
            System.out.println("Failed to save region " + file + ", operation stopped.");
            Remain.sneaky(t);
        }
    }

    protected abstract void onChunkScan(Chunk var1);

    protected void onScanFinished() {
    }

    public static File[] getRegionFiles(World world) {
        File regionDir = OfflineRegionScanner.getRegionDirectory(world);
        return regionDir == null ? null : regionDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".mca"));
    }

    private static final File getRegionDirectory(World world) {
        for (String f : FOLDERS) {
            File file = new File(world.getWorldFolder(), f);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    public static int getEstimatedWaitTimeSec(World world) {
        File[] files = OfflineRegionScanner.getRegionFiles(world);
        return (OPERATION_WAIT_SECONDS + 2) * files.length;
    }
}

