/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.NonNull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.collection.expiringmap.ExpiringMap;
import org.mineacademy.fo.plugin.SimplePlugin;

public final class JavaScriptExecutor {
    private static final ScriptEngine engine;
    private static final Map<UUID, Map<String, Object>> resultCache;

    public static Object run(String javascript) {
        return JavaScriptExecutor.run(javascript, null, null);
    }

    public static Object run(String javascript, CommandSender sender) {
        return JavaScriptExecutor.run(javascript, sender, null);
    }

    public static Object run(@NonNull String javascript, CommandSender sender, Event event) {
        Object result;
        Map<String, Object> cached;
        if (javascript == null) {
            throw new NullPointerException("javascript is marked non-null but is null");
        }
        Map<String, Object> map = cached = sender instanceof Player ? resultCache.get(((Player)sender).getUniqueId()) : null;
        if (cached != null && (result = cached.get(javascript)) != null) {
            return result;
        }
        try {
            engine.getBindings(100).clear();
            if (sender != null) {
                engine.put("player", sender);
            }
            if (event != null) {
                engine.put("event", event);
            }
            result = engine.eval(javascript);
            if (sender instanceof Player) {
                if (cached == null) {
                    cached = new HashMap<String, Object>();
                }
                cached.put(javascript, result);
                resultCache.put(((Player)sender).getUniqueId(), cached);
            }
            return result;
        }
        catch (ScriptException ex) {
            Common.error(ex, "Script executing failed!", "Script: " + javascript, "%error");
            return null;
        }
    }

    public static Object run(String javascript, Map<String, Object> replacements) throws ScriptException {
        engine.getBindings(100).clear();
        if (replacements != null) {
            for (Map.Entry<String, Object> replacement : replacements.entrySet()) {
                engine.put(replacement.getKey(), replacement.getValue());
            }
        }
        return engine.eval(javascript);
    }

    static {
        resultCache = ExpiringMap.builder().expiration(1L, TimeUnit.SECONDS).build();
        Thread.currentThread().setContextClassLoader(SimplePlugin.class.getClassLoader());
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = engineManager.getEngineByName("Nashorn");
        if (scriptEngine == null) {
            engineManager = new ScriptEngineManager(null);
            scriptEngine = engineManager.getEngineByName("Nashorn");
        }
        if ((engine = engineManager.getEngineByName("Nashorn")) == null) {
            Common.logFramed(true, "JavaScript placeholders will not function!", "", "Your Java version/distribution lacks the", "Nashorn library for JavaScript placeholders.", "Please install Oracle Java 8 JDK.");
        }
    }
}

