/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.MinecraftVersion;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.model.AuthMeHook;
import org.mineacademy.fo.model.CMIHook;
import org.mineacademy.fo.model.CitizensHook;
import org.mineacademy.fo.model.DiscordSRVHook;
import org.mineacademy.fo.model.EssentialsHook;
import org.mineacademy.fo.model.FactionsHook;
import org.mineacademy.fo.model.FactionsMassive;
import org.mineacademy.fo.model.FactionsUUID;
import org.mineacademy.fo.model.LWCHook;
import org.mineacademy.fo.model.LocketteProHook;
import org.mineacademy.fo.model.MVdWPlaceholderHook;
import org.mineacademy.fo.model.McMMOHook;
import org.mineacademy.fo.model.MultiverseHook;
import org.mineacademy.fo.model.NickyHook;
import org.mineacademy.fo.model.PlaceholderAPIHook;
import org.mineacademy.fo.model.PlotSquaredHook;
import org.mineacademy.fo.model.ProtocolLibHook;
import org.mineacademy.fo.model.ResidenceHook;
import org.mineacademy.fo.model.TownyHook;
import org.mineacademy.fo.model.VaultHook;
import org.mineacademy.fo.model.WorldEditHook;
import org.mineacademy.fo.model.WorldGuardHook;
import org.mineacademy.fo.plugin.SimplePlugin;
import org.mineacademy.fo.region.Region;
import org.mineacademy.fo.remain.Remain;

public final class HookManager {
    private static AuthMeHook authMe;
    private static EssentialsHook essentialsxHook;
    private static MultiverseHook multiverseHook;
    private static ProtocolLibHook protocolLibHook;
    private static TownyHook townyHook;
    private static VaultHook vaultHook;
    private static PlaceholderAPIHook placeholderAPIHook;
    private static FactionsHook factionsHook;
    private static NickyHook nickyHook;
    private static MVdWPlaceholderHook MVdWPlaceholderHook;
    private static McMMOHook mcmmoHook;
    private static LWCHook lwcHook;
    private static LocketteProHook locketteProHook;
    private static ResidenceHook residenceHook;
    private static WorldEditHook worldeditHook;
    private static WorldGuardHook worldguardHook;
    private static PlotSquaredHook plotSquaredHook;
    private static CMIHook CMIHook;
    private static CitizensHook citizensHook;
    private static DiscordSRVHook discordSRVHook;
    private static boolean nbtAPIDummyHook;
    private static boolean nuVotifierDummyHook;
    private static boolean townyChatDummyHook;

    public static void loadDependencies() {
        String ver;
        if (Common.doesPluginExistSilently("AuthMe")) {
            authMe = new AuthMeHook();
        }
        if (Common.doesPluginExistSilently("Multiverse-Core")) {
            multiverseHook = new MultiverseHook();
        }
        if (Common.doesPluginExistSilently("Towny")) {
            townyHook = new TownyHook();
        }
        if (Common.doesPluginExistSilently("Vault")) {
            vaultHook = new VaultHook();
        }
        if (Common.doesPluginExistSilently("PlaceholderAPI")) {
            placeholderAPIHook = new PlaceholderAPIHook();
        }
        if (Common.doesPluginExistSilently("Nicky")) {
            nickyHook = new NickyHook();
        }
        if (Common.doesPluginExistSilently("MVdWPlaceholderAPI")) {
            MVdWPlaceholderHook = new MVdWPlaceholderHook();
        }
        if (Common.doesPluginExistSilently("LWC")) {
            lwcHook = new LWCHook();
        }
        if (Common.doesPluginExistSilently("Lockette")) {
            locketteProHook = new LocketteProHook();
        }
        if (Common.doesPluginExistSilently("Residence")) {
            residenceHook = new ResidenceHook();
        }
        if (Common.doesPluginExistSilently("WorldEdit")) {
            worldeditHook = new WorldEditHook();
        }
        if (Common.doesPluginExistSilently("WorldGuard")) {
            worldguardHook = new WorldGuardHook(worldeditHook);
        }
        if (Common.doesPluginExistSilently("mcMMO")) {
            mcmmoHook = new McMMOHook();
        }
        if (Common.doesPluginExistSilently("CMI")) {
            CMIHook = new CMIHook();
        }
        if (Common.doesPluginExistSilently("Citizens")) {
            citizensHook = new CitizensHook();
        }
        if (Common.doesPluginExistSilently("NBTAPI")) {
            nbtAPIDummyHook = true;
        }
        if (Common.doesPluginExistSilently("Votifier")) {
            nuVotifierDummyHook = true;
        }
        if (Common.doesPluginExistSilently("TownyChat")) {
            townyChatDummyHook = true;
        }
        if (Common.doesPluginExistSilently("DiscordSRV")) {
            try {
                Class.forName("github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel");
                discordSRVHook = new DiscordSRVHook();
            }
            catch (ClassNotFoundException ex) {
                Common.error(ex, "&c" + SimplePlugin.getNamed() + " failed to hook DiscordSRV because the plugin is outdated (1.18.x is supported)!");
            }
        }
        if (Common.doesPluginExistSilently("Essentials")) {
            boolean isEssentialsX = Bukkit.getPluginManager().getPlugin("Essentials").getDescription().getAuthors().contains("drtshock");
            if (isEssentialsX) {
                essentialsxHook = new EssentialsHook();
            } else {
                Common.log("Detected old Essentials. We only support EssentialsX, see https://spigotmc.org/resources/9089");
            }
        }
        if (Common.doesPluginExistSilently("PlotSquared")) {
            ver = Bukkit.getPluginManager().getPlugin("PlotSquared").getDescription().getVersion();
            if (ver.startsWith("5.")) {
                plotSquaredHook = new PlotSquaredHook();
            } else {
                Common.log("&eCould not hook into PlotSquared, version 5.x required, you have " + ver);
            }
        }
        if (Common.doesPluginExistSilently("ProtocolLib")) {
            protocolLibHook = new ProtocolLibHook();
            try {
                if (MinecraftVersion.newerThan(MinecraftVersion.V.v1_6)) {
                    Class.forName("com.comphenix.protocol.wrappers.WrappedChatComponent");
                }
            }
            catch (Throwable t) {
                protocolLibHook = null;
                Common.throwError(t, "You are running an old and unsupported version of ProtocolLib, please update it.");
            }
        }
        if (Common.doesPluginExistSilently("Factions")) {
            ver = Bukkit.getPluginManager().getPlugin("Factions").getDescription().getVersion();
            if (ver.startsWith("1.6")) {
                Common.log("Recognized and hooked FactionsUUID...");
                factionsHook = new FactionsUUID();
            } else if (ver.startsWith("2.")) {
                Class<?> mplayer = null;
                try {
                    mplayer = Class.forName("com.massivecraft.factions.entity.MPlayer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (mplayer != null) {
                    Common.log("Recognized and hooked MCore Factions...");
                    factionsHook = new FactionsMassive();
                } else {
                    Common.log("&cRecognized MCore Factions, but not hooked! Check if you have the latest version!");
                }
            }
        }
    }

    @Deprecated
    public static void unloadDependencies(Plugin plugin) {
        if (HookManager.isProtocolLibLoaded()) {
            protocolLibHook.removePacketListeners(plugin);
        }
        if (HookManager.isPlaceholderAPILoaded()) {
            placeholderAPIHook.unregister();
        }
    }

    public static boolean isAuthMeLoaded() {
        return authMe != null;
    }

    public static boolean isCMILoaded() {
        return CMIHook != null;
    }

    public static boolean isCitizensLoaded() {
        return citizensHook != null;
    }

    public static boolean isEssentialsXLoaded() {
        return essentialsxHook != null;
    }

    public static boolean isMultiverseCoreLoaded() {
        return multiverseHook != null;
    }

    public static boolean isProtocolLibLoaded() {
        return protocolLibHook != null;
    }

    public static boolean isTownyLoaded() {
        return townyHook != null;
    }

    public static boolean isTownyChatLoaded() {
        return townyHook != null && townyChatDummyHook;
    }

    public static boolean isVaultLoaded() {
        return vaultHook != null;
    }

    public static boolean isPlaceholderAPILoaded() {
        return placeholderAPIHook != null;
    }

    public static boolean isFactionsLoaded() {
        return factionsHook != null;
    }

    public static boolean isNickyLoaded() {
        return nickyHook != null;
    }

    public static boolean isMVdWPlaceholderAPILoaded() {
        return MVdWPlaceholderHook != null;
    }

    public static boolean isMcMMOLoaded() {
        return mcmmoHook != null;
    }

    public static boolean isLWCLoaded() {
        return lwcHook != null;
    }

    public static boolean isLocketteProLoaded() {
        return locketteProHook != null;
    }

    public static boolean isResidenceLoaded() {
        return residenceHook != null;
    }

    public static boolean isWorldEditLoaded() {
        return worldeditHook != null;
    }

    public static boolean isWorldGuardLoaded() {
        return worldguardHook != null;
    }

    public static boolean isPlotSquaredLoaded() {
        return plotSquaredHook != null;
    }

    public static boolean isDiscordSRVLoaded() {
        return discordSRVHook != null;
    }

    public static boolean isNbtAPILoaded() {
        return nbtAPIDummyHook;
    }

    public static boolean isNuVotifierLoaded() {
        return nuVotifierDummyHook;
    }

    public static boolean isFAWELoaded() {
        Plugin worldEdit = Bukkit.getPluginManager().getPlugin("WorldEdit");
        String desc = worldEdit != null ? worldEdit.getDescription().getDescription() : null;
        return "Fast Async WorldEdit plugin".equals(desc);
    }

    public static boolean isLogged(Player player) {
        return !HookManager.isAuthMeLoaded() || authMe.isLogged(player);
    }

    public static boolean isAfk(Player player) {
        boolean essAFK = HookManager.isEssentialsXLoaded() && essentialsxHook.isAfk(player.getName());
        boolean cmiAFK = HookManager.isCMILoaded() && CMIHook.isAfk(player);
        return essAFK || cmiAFK;
    }

    public static boolean isVanished(Player player) {
        boolean essVanish = HookManager.isEssentialsXLoaded() ? essentialsxHook.isVanished(player.getName()) : false;
        boolean cmiVanish = HookManager.isCMILoaded() ? CMIHook.isVanished(player) : false;
        return essVanish || cmiVanish;
    }

    public static boolean isMuted(Player player) {
        boolean isEssMuted = HookManager.isEssentialsXLoaded() ? essentialsxHook.isMuted(player.getName()) : false;
        boolean isCMIMuted = HookManager.isCMILoaded() ? CMIHook.isMuted(player) : false;
        return isEssMuted || isCMIMuted;
    }

    public static void setGodMode(Player player, boolean godMode) {
        if (HookManager.isEssentialsXLoaded()) {
            essentialsxHook.setGodMode(player, godMode);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setGodMode(player, godMode);
        }
    }

    public static void setBackLocation(Player player, Location location) {
        if (HookManager.isEssentialsXLoaded()) {
            essentialsxHook.setBackLocation(player.getName(), location);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setLastTeleportLocation(player, location);
        }
    }

    public static void setIgnore(UUID player, UUID who, boolean ignore) {
        if (HookManager.isEssentialsXLoaded()) {
            essentialsxHook.setIgnore(player, who, ignore);
        }
        if (HookManager.isCMILoaded()) {
            CMIHook.setIgnore(player, who, ignore);
        }
    }

    public static boolean isIgnoring(UUID player, UUID who) {
        Valid.checkBoolean(player != null, "Player to check ignore from cannot be null/empty", new Object[0]);
        Valid.checkBoolean(who != null, "Player to check ignore to cannot be null/empty", new Object[0]);
        return HookManager.isEssentialsXLoaded() ? essentialsxHook.isIgnoring(player, who) : (HookManager.isCMILoaded() ? CMIHook.isIgnoring(player, who) : false);
    }

    public static String getNick(CommandSender sender) {
        String cmiNick;
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player != null && HookManager.isNPC((Entity)player)) {
            Common.log("&eWarn: Called getNick for NPC " + player.getName() + "! Notify the developers to add an ignore check at " + Debugger.traceRoute(true));
            return player.getName();
        }
        if (player == null) {
            return sender.getName();
        }
        String nickyNick = HookManager.isNickyLoaded() ? nickyHook.getNick(player) : null;
        String essNick = HookManager.isEssentialsXLoaded() ? essentialsxHook.getNick(player.getName()) : null;
        String string = cmiNick = HookManager.isCMILoaded() ? CMIHook.getNick(player) : null;
        String nick = nickyNick != null ? nickyNick : (cmiNick != null ? cmiNick : (essNick != null ? essNick : sender.getName()));
        return Common.stripColors(nick.replace("\u00a7x", ""));
    }

    public static String getNameFromNick(@NonNull String nick) {
        String cmiNick;
        if (nick == null) {
            throw new NullPointerException("nick is marked non-null but is null");
        }
        String essNick = HookManager.isEssentialsXLoaded() ? essentialsxHook.getNameFromNick(nick) : nick;
        String string = cmiNick = HookManager.isCMILoaded() ? CMIHook.getNameFromNick(nick) : nick;
        return !essNick.equals(nick) && !"".equals(essNick) ? essNick : (!cmiNick.equals(nick) && !"".equals(cmiNick) ? cmiNick : nick);
    }

    public static Player getReplyTo(Player player) {
        return HookManager.isEssentialsXLoaded() ? essentialsxHook.getReplyTo(player.getName()) : null;
    }

    public static String getWorldAlias(World world) {
        return HookManager.isMultiverseCoreLoaded() ? multiverseHook.getWorldAlias(world.getName()) : world.getName();
    }

    public static String getNation(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getNationName(player) : null;
    }

    public static String getTownName(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getTownName(player) : null;
    }

    public static Collection<? extends Player> getTownResidentsOnline(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getTownResidentsOnline(player) : new ArrayList();
    }

    public static Collection<? extends Player> getNationPlayersOnline(Player player) {
        return HookManager.isTownyLoaded() ? townyHook.getNationPlayersOnline(player) : new ArrayList();
    }

    public static String getTownOwner(Location location) {
        return HookManager.isTownyLoaded() ? townyHook.getTownOwner(location) : null;
    }

    public static String getTown(Location location) {
        return HookManager.isTownyLoaded() ? townyHook.getTown(location) : null;
    }

    public static List<String> getTowns() {
        return HookManager.isTownyLoaded() ? townyHook.getTowns() : new ArrayList<String>();
    }

    public static String getPlayerPrefix(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerPrefix(player) : "";
    }

    public static String getPlayerSuffix(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerSuffix(player) : "";
    }

    public static String getPlayerPermissionGroup(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPlayerGroup(player) : "";
    }

    public static double getBalance(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getBalance(player) : 0.0;
    }

    public static String getCurrencySingular() {
        return HookManager.isVaultLoaded() ? vaultHook.getCurrencyNameSG() : null;
    }

    public static String getCurrencyPlural() {
        return HookManager.isVaultLoaded() ? vaultHook.getCurrencyNamePL() : null;
    }

    public static void withdraw(Player player, double amount) {
        if (HookManager.isVaultLoaded()) {
            vaultHook.withdraw(player, amount);
        }
    }

    public static void deposit(Player player, double amount) {
        if (HookManager.isVaultLoaded()) {
            vaultHook.deposit(player, amount);
        }
    }

    @Deprecated
    public static boolean hasPermissionUnsafe(UUID id, String perm) {
        OfflinePlayer player = Remain.getOfflinePlayerByUUID(id);
        Boolean has = player != null && HookManager.isVaultLoaded() ? vaultHook.hasPerm(player.getName(), perm) : null;
        return HookManager.hasPerm0(player, has);
    }

    @Deprecated
    public static boolean hasPermissionUnsafe(String name, String perm) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
        Boolean has = player != null && player.getName() != null && HookManager.isVaultLoaded() ? vaultHook.hasPerm(player.getName(), perm) : null;
        return HookManager.hasPerm0(player, has);
    }

    private static boolean hasPerm0(OfflinePlayer player, Boolean has) {
        if (has != null) {
            if (!has.booleanValue() && player != null) {
                return player.isOp();
            }
            return has;
        }
        return player != null && player.isOp();
    }

    public static String getPlayerPrimaryGroup(Player player) {
        return HookManager.isVaultLoaded() ? vaultHook.getPrimaryGroup(player) : "";
    }

    public static boolean isChatIntegrated() {
        return HookManager.isVaultLoaded() ? vaultHook.isChatIntegrated() : false;
    }

    public static boolean isEconomyIntegrated() {
        return HookManager.isVaultLoaded() ? vaultHook.isEconomyIntegrated() : false;
    }

    @Deprecated
    public static void updateVaultIntegration() {
        if (HookManager.isVaultLoaded()) {
            vaultHook.setIntegration();
        }
    }

    public static String replacePlaceholders(Player player, String message) {
        if (message == null || "".equals(message.trim())) {
            return message;
        }
        message = HookManager.isPlaceholderAPILoaded() ? placeholderAPIHook.replacePlaceholders(player, message) : message;
        message = HookManager.isMVdWPlaceholderAPILoaded() ? MVdWPlaceholderHook.replacePlaceholders(player, message) : message;
        return message;
    }

    public static String replaceRelationPlaceholders(Player one, Player two, String msg) {
        if (msg == null || "".equals(msg.trim())) {
            return msg;
        }
        return HookManager.isPlaceholderAPILoaded() ? placeholderAPIHook.replaceRelationPlaceholders(one, two, msg) : msg;
    }

    @Deprecated
    public static void addPlaceholder(String variable, BiFunction<Player, String, String> value) {
        if (HookManager.isPlaceholderAPILoaded()) {
            placeholderAPIHook.addPlaceholder(new PAPIPlaceholder(variable, value));
        }
    }

    public static void addPlaceholder(String variable, Function<Player, String> value) {
        if (HookManager.isPlaceholderAPILoaded()) {
            placeholderAPIHook.addPlaceholder(new PAPIPlaceholder(variable, (player, identifier) -> (String)value.apply((Player)player)));
        }
    }

    public static Collection<String> getFactions() {
        return HookManager.isFactionsLoaded() ? factionsHook.getFactions() : null;
    }

    public static String getFaction(Player player) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFaction(player) : null;
    }

    public static Collection<? extends Player> getOnlineFactionPlayers(Player player) {
        return HookManager.isFactionsLoaded() ? factionsHook.getSameFactionPlayers(player) : null;
    }

    public static String getFaction(Location location) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFaction(location) : null;
    }

    public static String getFactionOwner(Location location) {
        return HookManager.isFactionsLoaded() ? factionsHook.getFactionOwner(location) : null;
    }

    public static void addPacketListener(Object adapter) {
        Valid.checkBoolean(HookManager.isProtocolLibLoaded(), "Cannot add packet listeners if ProtocolLib isn't installed", new Object[0]);
        protocolLibHook.addPacketListener(adapter);
    }

    public static void sendPacket(Player player, Object packetContainer) {
        Valid.checkBoolean(HookManager.isProtocolLibLoaded(), "Sending packets requires ProtocolLib installed and loaded", new Object[0]);
        protocolLibHook.sendPacket(player, packetContainer);
    }

    public static String getLWCOwner(Block block) {
        return HookManager.isLWCLoaded() ? lwcHook.getOwner(block) : null;
    }

    public static boolean isLocketteOwner(Block block, Player player) {
        return HookManager.isLocketteProLoaded() ? locketteProHook.isOwner(block, player) : false;
    }

    public static Collection<String> getResidences() {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidences() : new ArrayList<String>();
    }

    public static String getResidence(Location location) {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidence(location) : null;
    }

    public static String getResidenceOwner(Location location) {
        return HookManager.isResidenceLoaded() ? residenceHook.getResidenceOwner(location) : null;
    }

    public static List<String> getRegions(Location loc) {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getRegionsAt(loc) : new ArrayList();
    }

    public static List<String> getRegions() {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getAllRegions() : new ArrayList<String>();
    }

    public static Region getRegion(String name) {
        return HookManager.isWorldGuardLoaded() ? worldguardHook.getRegion(name) : null;
    }

    public static Collection<? extends Player> getPlotPlayers(Player players) {
        return HookManager.isPlotSquaredLoaded() ? plotSquaredHook.getPlotPlayers(players) : null;
    }

    public static String getActivePartyChat(Player player) {
        return HookManager.isMcMMOLoaded() ? mcmmoHook.getActivePartyChat(player) : null;
    }

    public static boolean isNPC(Entity entity) {
        return HookManager.isCitizensLoaded() ? citizensHook.isNPC(entity) : false;
    }

    public static Set<String> getDiscordChannels() {
        return HookManager.isDiscordSRVLoaded() ? discordSRVHook.getChannels() : new HashSet<String>();
    }

    public static void sendDiscordMessage(String senderName, String channel, String message) {
        if (HookManager.isDiscordSRVLoaded()) {
            discordSRVHook.sendMessage(senderName, channel, message);
        }
    }

    public static void sendDiscordMessage(CommandSender sender, String channel, String message) {
        if (HookManager.isDiscordSRVLoaded()) {
            discordSRVHook.sendMessage(sender, channel, message);
        }
    }

    public static void sendDiscordMessage(String channel, String message) {
        if (HookManager.isDiscordSRVLoaded()) {
            discordSRVHook.sendMessage(channel, message);
        }
    }

    private HookManager() {
    }

    static {
        nbtAPIDummyHook = false;
        nuVotifierDummyHook = false;
        townyChatDummyHook = false;
    }

    static class PAPIPlaceholder {
        private final String variable;
        private final BiFunction<Player, String, String> value;

        public PAPIPlaceholder(String variable, BiFunction<Player, String, String> value) {
            this.variable = variable;
            this.value = value;
        }

        public String getVariable() {
            return this.variable;
        }

        public BiFunction<Player, String, String> getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PAPIPlaceholder)) {
                return false;
            }
            PAPIPlaceholder other = (PAPIPlaceholder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$variable = this.getVariable();
            String other$variable = other.getVariable();
            if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
                return false;
            }
            BiFunction<Player, String, String> this$value = this.getValue();
            BiFunction<Player, String, String> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PAPIPlaceholder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            BiFunction<Player, String, String> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "HookManager.PAPIPlaceholder(variable=" + this.getVariable() + ", value=" + this.getValue() + ")";
        }
    }
}

