/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.ArrayList;
import java.util.List;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.FileUtil;
import org.mineacademy.fo.Valid;

@Deprecated
public abstract class FileReader<T> {
    private final String matcher;
    private T object = null;

    public FileReader(String matcher) {
        this.matcher = matcher;
    }

    protected final T getObject() {
        return this.object;
    }

    public abstract T newInstance(String var1);

    public abstract void onLineParse(String var1);

    public boolean canFinish() {
        return true;
    }

    public void onObjectPreSave() {
    }

    public final List<T> load(String path) {
        try {
            return this.load0(path);
        }
        catch (Throwable t) {
            Common.throwError(t, "&cError reading " + path, "&cCheck for syntax errors.", "Error: " + t.getMessage());
            return null;
        }
    }

    private final List<T> load0(String path) {
        List<String> lines = FileUtil.readLines(FileUtil.extract(path));
        ArrayList<String> loadedLines = new ArrayList<String>();
        ArrayList<T> loadedValues = new ArrayList<T>();
        String previous = null;
        this.object = null;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i).trim();
            if (!line.isEmpty() && !line.startsWith("#")) {
                if (line.startsWith(this.matcher + " ")) {
                    if (this.object != null) {
                        this.onObjectPreSave();
                        if (this.canFinish()) {
                            Valid.checkBoolean(!loadedLines.contains(line), path + " already contains: " + line + " (line " + i + ")", new Object[0]);
                            loadedLines.add(line);
                            loadedValues.add(this.object);
                        }
                    }
                    this.object = this.newInstance(line);
                    previous = this.object.toString();
                } else {
                    if (this.object == null && previous == null) {
                        throw new NullPointerException("File " + path + " appears to have wrong encoding! Learn how to fix it here: http://tiny.cc/chc_encoding");
                    }
                    Valid.checkNotNull(this.object, "Cannot define operator when nothing is being created! File: '" + path + "' Line " + i + ": '" + line + "' Previous: '" + previous + "'");
                    this.onLineParse(line);
                }
            }
            if (i + 1 != lines.size() || this.object == null) continue;
            this.onObjectPreSave();
            if (!this.canFinish()) continue;
            loadedLines.add(line);
            loadedValues.add(this.object);
        }
        return loadedValues;
    }
}

