/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;

class EssentialsHook {
    private final Essentials ess = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");

    EssentialsHook() {
    }

    void setGodMode(Player player, boolean godMode) {
        User user = this.getUser(player.getName());
        if (user != null) {
            user.setGodModeEnabled(godMode);
        }
    }

    void setIgnore(UUID player, UUID toIgnore, boolean ignore) {
        try {
            User user = this.ess.getUser(player);
            User toIgnoreUser = this.ess.getUser(toIgnore);
            if (ignore && user.isIgnoredPlayer((IUser)toIgnoreUser)) {
                return;
            }
            user.setIgnoredPlayer((IUser)toIgnoreUser, ignore);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean isIgnoring(UUID player, UUID ignoringPlayer) {
        try {
            User user = this.ess.getUser(player);
            User ignored = this.ess.getUser(ignoringPlayer);
            return user != null && ignored != null && user.isIgnoredPlayer((IUser)ignored);
        }
        catch (Throwable t) {
            return false;
        }
    }

    boolean isAfk(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isAfk() : false;
    }

    boolean isVanished(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isVanished() : false;
    }

    boolean isMuted(String pl) {
        User user = this.getUser(pl);
        return user != null ? user.isMuted() : false;
    }

    Player getReplyTo(String recipient) {
        User user = this.getUser(recipient);
        if (user == null) {
            return null;
        }
        try {
            String replyPlayer = user.getReplyRecipient().getName();
            Player bukkitPlayer = Bukkit.getPlayer((String)replyPlayer);
            if (bukkitPlayer != null && bukkitPlayer.isOnline()) {
                return bukkitPlayer;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    String getNick(String player) {
        User user = this.getUser(player);
        if (user == null) {
            Common.log("&cMalfunction getting Essentials user. Have you reloaded?");
            return player;
        }
        String essNick = Common.getOrEmpty(user.getNickname());
        return "".equals(essNick) ? null : essNick;
    }

    String getNameFromNick(String nick) {
        UserMap users = this.ess.getUserMap();
        if (users != null) {
            for (UUID userId : users.getAllUniqueUsers()) {
                User user = users.getUser(userId);
                if (user == null || user.getNickname() == null || !Valid.colorlessEquals(user.getNickname().toLowerCase(), nick.toLowerCase())) continue;
                return Common.getOrDefault(user.getName(), nick);
            }
        }
        return nick;
    }

    void setBackLocation(String player, Location loc) {
        User user = this.getUser(player);
        if (user != null) {
            try {
                user.setLastLocation(loc);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private User getUser(String name) {
        if (this.ess.getUserMap() == null) {
            return null;
        }
        User user = null;
        try {
            user = this.ess.getUserMap().getUser(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = this.ess.getUserMap().getUserFromBukkit(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return user;
    }
}

