/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.mineacademy.fo.EntityUtil;
import org.mineacademy.fo.model.SimpleEnchantment;

public final class EnchantmentListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        if (damager instanceof LivingEntity) {
            this.execute((LivingEntity)damager, (enchant, level) -> enchant.onDamage((int)level, (LivingEntity)damager, event));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInteract(PlayerInteractEvent event) {
        this.execute((LivingEntity)event.getPlayer(), (enchant, level) -> enchant.onInteract((int)level, event));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakBlock(BlockBreakEvent event) {
        this.execute((LivingEntity)event.getPlayer(), (enchant, level) -> enchant.onBreakBlock((int)level, event));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onShoot(ProjectileLaunchEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)projectileSource;
            this.execute(shooter, (enchant, level) -> enchant.onShoot((int)level, shooter, event));
            EntityUtil.trackHit(event.getEntity(), hitEvent -> this.execute(shooter, (enchant, level) -> enchant.onHit((int)level, shooter, hitEvent)));
        }
    }

    private void execute(LivingEntity source, BiConsumer<SimpleEnchantment, Integer> executer) {
        ItemStack hand = source.getEquipment().getItemInHand();
        if (hand != null) {
            for (Map.Entry<SimpleEnchantment, Integer> e : SimpleEnchantment.findEnchantments(hand).entrySet()) {
                executer.accept(e.getKey(), e.getValue());
            }
        }
    }
}

