/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import java.io.File;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.mineacademy.fo.debug.Debugger;
import org.mineacademy.fo.model.DiscordSender;
import org.mineacademy.fo.plugin.SimplePlugin;

class DiscordSRVHook
implements Listener {
    DiscordSRVHook() {
    }

    Set<String> getChannels() {
        return DiscordSRV.getPlugin().getChannels().keySet();
    }

    boolean sendMessage(String sender, String channel, String message) {
        DiscordSender discordSender = new DiscordSender(sender);
        return this.sendMessage(discordSender, channel, message);
    }

    boolean sendMessage(String channel, String message) {
        return this.sendMessage((CommandSender)null, channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendMessage(CommandSender sender, String channel, String message) {
        TextChannel textChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(channel);
        if (textChannel == null) {
            Debugger.debug("discord", "[MC->Discord] Could not find Discord channel '" + channel + "'. Available: " + String.join((CharSequence)", ", this.getChannels()) + ". Not sending: " + message);
            return false;
        }
        if (sender instanceof Player) {
            YamlConfiguration discordConfig;
            Debugger.debug("discord", "[MC->Discord] " + sender.getName() + " send message to '" + channel + "' channel. Message: '" + message + "'");
            DiscordSRV instance = (DiscordSRV)JavaPlugin.getPlugin(DiscordSRV.class);
            File file = new File(SimplePlugin.getData().getParent(), "DiscordSRV/config.yml");
            if (file.exists() && (discordConfig = YamlConfiguration.loadConfiguration((File)file)) != null) {
                String outMessageKey = "DiscordChatChannelMinecraftToDiscord";
                boolean outMessageOldValue = discordConfig.getBoolean("DiscordChatChannelMinecraftToDiscord");
                discordConfig.set("DiscordChatChannelMinecraftToDiscord", (Object)true);
                try {
                    instance.processChatMessage((Player)sender, message, channel, false);
                }
                finally {
                    discordConfig.set("DiscordChatChannelMinecraftToDiscord", (Object)outMessageOldValue);
                }
            }
        } else {
            Debugger.debug("discord", "[MC->Discord] " + (sender == null ? "No given sender " : sender.getName() + " (generic)") + "sent message to '" + channel + "' channel. Message: '" + message + "'");
            DiscordUtil.sendMessage((TextChannel)textChannel, (String)message);
        }
        return true;
    }
}

