/*
 * Decompiled with CFR 0.152.
 */
package org.mineacademy.fo.model;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.ListenerPriority;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.DiscordGuildMessagePreProcessEvent;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Member;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageChannel;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.mineacademy.fo.Common;
import org.mineacademy.fo.Valid;
import org.mineacademy.fo.collection.StrictSet;
import org.mineacademy.fo.model.HookManager;

public abstract class DiscordListener
implements Listener {
    private static final StrictSet<DiscordListener> registeredListeners = new StrictSet();
    private Message message;

    protected DiscordListener() {
        registeredListeners.add(this);
    }

    private final void handleMessageReceived(DiscordGuildMessagePreProcessEvent event) {
        this.message = event.getMessage();
        this.onMessageReceived(event);
    }

    protected abstract void onMessageReceived(DiscordGuildMessagePreProcessEvent var1);

    protected final Player findPlayer(String playerName, String offlineMessage) {
        Player player = Bukkit.getPlayer((String)playerName);
        this.checkBoolean(player != null, offlineMessage);
        return player;
    }

    protected final void checkBoolean(boolean value, String warningMessage) throws RemovedMessageException {
        if (!value) {
            this.returnHandled(warningMessage);
        }
    }

    protected final void returnHandled(String message) {
        this.removeAndWarn(message);
        throw new RemovedMessageException();
    }

    protected final void removeAndWarn(String warningMessage) {
        this.removeAndWarn(this.message, warningMessage);
    }

    protected final void removeAndWarn(Message message, String warningMessage) {
        this.removeAndWarn(message, warningMessage, 2);
    }

    protected final void removeAndWarn(Message message, String warningMessage, int warningDurationSeconds) {
        message.delete().complete();
        MessageChannel channel = message.getChannel();
        Message channelWarningMessage = (Message)channel.sendMessage((CharSequence)warningMessage).complete();
        channel.deleteMessageById(channelWarningMessage.getIdLong()).completeAfter((long)warningDurationSeconds, TimeUnit.SECONDS);
    }

    protected final boolean hasRole(Member member, String roleName) {
        for (Role role : member.getRoles()) {
            if (!role.getName().equalsIgnoreCase(roleName)) continue;
            return true;
        }
        return false;
    }

    protected final void sendMessage(Player sender, String channel, String message) {
        HookManager.sendDiscordMessage((CommandSender)sender, channel, message);
    }

    protected final void sendMessage(String channel, String message) {
        HookManager.sendDiscordMessage(channel, message);
    }

    protected final Set<String> getChannels() {
        return HookManager.getDiscordChannels();
    }

    @Deprecated
    public static final class DiscordListenerImpl
    implements Listener {
        private static boolean registered = false;

        public DiscordListenerImpl() {
            Valid.checkBoolean(!registered, "Already registered!", new Object[0]);
            registered = true;
            DiscordSRV.api.subscribe((Object)this);
        }

        public void unsubscribe() {
            DiscordSRV.api.unsubscribe((Object)this);
        }

        @Subscribe(priority=ListenerPriority.MONITOR)
        public void onMessageReceived(DiscordGuildMessagePreProcessEvent event) {
            for (DiscordListener listener : registeredListeners) {
                try {
                    listener.handleMessageReceived(event);
                }
                catch (RemovedMessageException removedMessageException) {
                }
                catch (Throwable t) {
                    Common.error(t, "Failed to handle DiscordSRV!", "Sender: " + event.getAuthor().getName(), "Channel: " + event.getChannel().getName(), "Message: " + event.getMessage().getContentDisplay());
                }
            }
        }
    }

    private static final class RemovedMessageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private RemovedMessageException() {
        }
    }
}

